/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.Cpsr;
import com.github.unidbg.arm.backend.AbstractBackend;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.BlockHook;
import com.github.unidbg.arm.backend.CodeHook;
import com.github.unidbg.arm.backend.DebugHook;
import com.github.unidbg.arm.backend.EventMemHook;
import com.github.unidbg.arm.backend.ReadHook;
import com.github.unidbg.arm.backend.UnHook;
import com.github.unidbg.arm.backend.WriteHook;
import com.github.unidbg.arm.backend.unicorn.InterruptHook;
import com.github.unidbg.arm.backend.unicorn.Unicorn;
import com.github.unidbg.debugger.BreakPoint;
import com.github.unidbg.debugger.BreakPointCallback;
import com.github.unidbg.pointer.UnidbgPointer;
import java.util.Map;
import unicorn.UnicornException;

class Unicorn2Backend
extends AbstractBackend
implements Backend {
    private final Emulator<?> emulator;
    private final boolean is64Bit;
    private final Unicorn unicorn;
    private Unicorn.UnHook unHook;

    Unicorn2Backend(Emulator<?> emulator, boolean is64Bit) throws BackendException {
        this.emulator = emulator;
        this.is64Bit = is64Bit;
        try {
            this.unicorn = is64Bit ? new Unicorn(2, 0) : new Unicorn(1, 0);
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void switchUserMode() {
        if (!this.is64Bit) {
            Cpsr.getArm(this).switchUserMode();
        }
    }

    @Override
    public void enableVFP() {
        if (this.is64Bit) {
            long value = this.reg_read(261).longValue();
            this.reg_write(261, value |= 0x300000L);
        } else {
            int value = this.reg_read(111).intValue();
            this.reg_write(111, value |= 0xF00000);
            this.reg_write(4, 0x40000000);
        }
    }

    @Override
    public byte[] reg_read_vector(int regId) throws BackendException {
        try {
            if (this.is64Bit ? regId < 104 || regId > 135 : regId < 14 || regId > 29) {
                throw new UnsupportedOperationException("regId=" + regId);
            }
            return this.unicorn.reg_read(regId, 16);
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void reg_write_vector(int regId, byte[] vector) throws BackendException {
        if (vector.length != 16) {
            throw new IllegalStateException("Invalid vector size");
        }
        try {
            if (this.is64Bit ? regId < 104 || regId > 135 : regId < 14 || regId > 29) {
                throw new UnsupportedOperationException("regId=" + regId);
            }
            this.unicorn.reg_write(regId, vector);
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public Number reg_read(int regId) throws BackendException {
        try {
            return this.unicorn.reg_read(regId);
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void reg_write(int regId, Number value) throws BackendException {
        try {
            this.unicorn.reg_write(regId, this.is64Bit ? value.longValue() : (long)value.intValue());
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public byte[] mem_read(long address, long size) throws BackendException {
        try {
            return this.unicorn.mem_read(address, size);
        }
        catch (UnicornException e) {
            throw new BackendException("mem_read address=0x" + Long.toHexString(address) + ", size=" + size, e);
        }
    }

    @Override
    public void mem_write(long address, byte[] bytes) throws BackendException {
        try {
            this.unicorn.mem_write(address, bytes);
        }
        catch (UnicornException e) {
            throw new BackendException("mem_write address=0x" + Long.toHexString(address), e);
        }
    }

    @Override
    public void mem_map(long address, long size, int perms) throws BackendException {
        try {
            this.unicorn.mem_map(address, size, perms);
        }
        catch (UnicornException e) {
            throw new BackendException("mem_map address=0x" + Long.toHexString(address) + ", size=" + size + ", perms=0x" + Integer.toHexString(perms), e);
        }
    }

    @Override
    public void mem_protect(long address, long size, int perms) throws BackendException {
        try {
            this.unicorn.mem_protect(address, size, perms);
        }
        catch (UnicornException e) {
            throw new BackendException("mem_protect address=0x" + Long.toHexString(address) + ", size=" + size + ", perms=0x" + Integer.toHexString(perms), e);
        }
    }

    @Override
    public void mem_unmap(long address, long size) throws BackendException {
        try {
            this.unicorn.mem_unmap(address, size);
        }
        catch (UnicornException e) {
            throw new BackendException("mem_unmap address=0x" + Long.toHexString(address) + ", size=" + size, e);
        }
    }

    @Override
    public BreakPoint addBreakPoint(long address, BreakPointCallback callback2, boolean thumb) {
        BreakPointImpl breakPoint = new BreakPointImpl(callback2, thumb);
        this.unicorn.addBreakPoint(address);
        return breakPoint;
    }

    @Override
    public boolean removeBreakPoint(long address) {
        this.unicorn.removeBreakPoint(address);
        return true;
    }

    @Override
    public void setSingleStep(int singleStep) {
        this.unicorn.setSingleStep(singleStep);
    }

    @Override
    public void setFastDebug(boolean fastDebug) {
        this.unicorn.setFastDebug(fastDebug);
    }

    @Override
    public void hook_add_new(final CodeHook callback2, long begin, long end, Object user_data) throws BackendException {
        try {
            final Unicorn.UnHook unHook = this.unicorn.hook_add_new(new com.github.unidbg.arm.backend.unicorn.CodeHook(){

                @Override
                public void hook(Unicorn u, long address, int size, Object user) {
                    callback2.hook(Unicorn2Backend.this, address, size, user);
                }
            }, begin, end, user_data);
            callback2.onAttach(new UnHook(){

                @Override
                public void unhook() {
                    unHook.unhook();
                }
            });
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void debugger_add(final DebugHook callback2, long begin, long end, Object user_data) throws BackendException {
        try {
            final Unicorn.UnHook unHook = this.unicorn.debugger_add(new com.github.unidbg.arm.backend.unicorn.DebugHook(){

                @Override
                public void onBreak(Unicorn u, long address, int size, Object user) {
                    callback2.onBreak(Unicorn2Backend.this, address, size, user);
                }

                @Override
                public void hook(Unicorn u, long address, int size, Object user) {
                    callback2.hook(Unicorn2Backend.this, address, size, user);
                }
            }, begin, end, user_data);
            callback2.onAttach(new UnHook(){

                @Override
                public void unhook() {
                    unHook.unhook();
                }
            });
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void hook_add_new(final ReadHook callback2, long begin, long end, Object user_data) throws BackendException {
        try {
            final Unicorn.UnHook unHook = this.unicorn.hook_add_new(new com.github.unidbg.arm.backend.unicorn.ReadHook(){

                @Override
                public void hook(Unicorn u, long address, int size, Object user) {
                    callback2.hook(Unicorn2Backend.this, address, size, user);
                }
            }, begin, end, user_data);
            callback2.onAttach(new UnHook(){

                @Override
                public void unhook() {
                    unHook.unhook();
                }
            });
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void hook_add_new(final WriteHook callback2, long begin, long end, Object user_data) throws BackendException {
        try {
            final Unicorn.UnHook unHook = this.unicorn.hook_add_new(new com.github.unidbg.arm.backend.unicorn.WriteHook(){

                @Override
                public void hook(Unicorn u, long address, int size, long value, Object user) {
                    callback2.hook(Unicorn2Backend.this, address, size, value, user);
                }
            }, begin, end, user_data);
            callback2.onAttach(new UnHook(){

                @Override
                public void unhook() {
                    unHook.unhook();
                }
            });
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void hook_add_new(EventMemHook callback2, int type, Object user_data) throws BackendException {
        if ((type & 0x10) != 0) {
            this.hookEventMem(callback2, 16, user_data, EventMemHook.UnmappedType.Read);
        }
        if ((type & 0x20) != 0) {
            this.hookEventMem(callback2, 32, user_data, EventMemHook.UnmappedType.Write);
        }
        if ((type & 0x40) != 0) {
            this.hookEventMem(callback2, 64, user_data, EventMemHook.UnmappedType.Fetch);
        }
    }

    private void hookEventMem(final EventMemHook callback2, int type, Object user_data, final EventMemHook.UnmappedType unmappedType) {
        try {
            Map<Integer, Unicorn.UnHook> map = this.unicorn.hook_add_new(new com.github.unidbg.arm.backend.unicorn.EventMemHook(){

                @Override
                public boolean hook(Unicorn u, long address, int size, long value, Object user) {
                    return callback2.hook(Unicorn2Backend.this, address, size, value, user, unmappedType);
                }
            }, type, user_data);
            for (final Unicorn.UnHook unHook : map.values()) {
                callback2.onAttach(new UnHook(){

                    @Override
                    public void unhook() {
                        unHook.unhook();
                    }
                });
            }
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void hook_add_new(final com.github.unidbg.arm.backend.InterruptHook callback2, Object user_data) throws BackendException {
        try {
            final Unicorn.UnHook unHook = this.unicorn.hook_add_new(new InterruptHook(){

                @Override
                public void hook(Unicorn u, int intno, Object user) {
                    int swi;
                    if (Unicorn2Backend.this.is64Bit) {
                        UnidbgPointer pc = UnidbgPointer.register(Unicorn2Backend.this.emulator, 260);
                        swi = pc.getInt(-4L) >> 5 & 0xFFFF;
                    } else {
                        UnidbgPointer pc = UnidbgPointer.register(Unicorn2Backend.this.emulator, 11);
                        boolean isThumb = ARM.isThumb(Unicorn2Backend.this);
                        swi = isThumb ? pc.getShort(-2L) & 0xFF : pc.getInt(-4L) & 0xFFFFFF;
                    }
                    callback2.hook(Unicorn2Backend.this, intno, swi, user);
                }
            }, user_data);
            callback2.onAttach(new UnHook(){

                @Override
                public void unhook() {
                    unHook.unhook();
                }
            });
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void hook_add_new(final BlockHook callback2, long begin, long end, Object user_data) throws BackendException {
        try {
            final Unicorn.UnHook unHook = this.unicorn.hook_add_new(new com.github.unidbg.arm.backend.unicorn.BlockHook(){

                @Override
                public void hook(Unicorn u, long address, int size, Object user) {
                    callback2.hookBlock(Unicorn2Backend.this, address, size, user);
                }
            }, begin, end, user_data);
            callback2.onAttach(new UnHook(){

                @Override
                public void unhook() {
                    unHook.unhook();
                }
            });
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public final synchronized void emu_start(long begin, long until, long timeout, long count) throws BackendException {
        try {
            this.unicorn.emu_start(begin, until, timeout, count);
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void emu_stop() throws BackendException {
        try {
            this.unicorn.emu_stop();
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void destroy() throws BackendException {
        try {
            this.unicorn.closeAll();
        }
        catch (UnicornException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void context_restore(long context) {
        this.unicorn.context_restore(context);
    }

    @Override
    public void context_save(long context) {
        this.unicorn.context_save(context);
    }

    @Override
    public long context_alloc() {
        return this.unicorn.context_alloc();
    }

    @Override
    public void context_free(long context) {
        Unicorn.free(context);
    }

    @Override
    public void registerEmuCountHook(long emu_count) {
        if (this.unHook != null) {
            throw new IllegalStateException();
        }
        if (emu_count <= 0L) {
            throw new IllegalArgumentException();
        }
        this.unHook = this.unicorn.registerEmuCountHook(emu_count);
    }

    private static class BreakPointImpl
    implements BreakPoint {
        final BreakPointCallback callback;
        final boolean thumb;
        boolean isTemporary;

        public BreakPointImpl(BreakPointCallback callback2, boolean thumb) {
            this.callback = callback2;
            this.thumb = thumb;
        }

        @Override
        public void setTemporary(boolean temporary) {
            this.isTemporary = true;
        }

        @Override
        public boolean isTemporary() {
            return this.isTemporary;
        }

        @Override
        public BreakPointCallback getCallback() {
            return this.callback;
        }

        @Override
        public boolean isThumb() {
            return this.thumb;
        }
    }
}

