/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.context;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.context.BaseRegisterContext;
import com.github.unidbg.arm.context.EditableArm64RegisterContext;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;

public class BackendArm64RegisterContext
extends BaseRegisterContext
implements EditableArm64RegisterContext {
    private final Backend backend;

    public BackendArm64RegisterContext(Backend backend, Emulator<?> emulator) {
        super(emulator, 199, 8);
        this.backend = backend;
    }

    private long reg(int regId) {
        return this.backend.reg_read(regId).longValue();
    }

    @Override
    public void setXLong(int index, long value) {
        if (index >= 0 && index <= 28) {
            this.backend.reg_write(199 + index, value);
            return;
        }
        throw new IllegalArgumentException("invalid index: " + index);
    }

    @Override
    public long getXLong(int index) {
        if (index >= 0 && index <= 28) {
            return this.reg(199 + index);
        }
        throw new IllegalArgumentException("invalid index: " + index);
    }

    @Override
    public int getXInt(int index) {
        return (int)this.getXLong(index);
    }

    @Override
    public UnidbgPointer getXPointer(int index) {
        return UnidbgPointer.pointer(this.emulator, this.getXLong(index));
    }

    @Override
    public long getFp() {
        return this.reg(1);
    }

    @Override
    public UnidbgPointer getFpPointer() {
        return UnidbgPointer.pointer(this.emulator, this.getFp());
    }

    @Override
    public long getLR() {
        return this.reg(2);
    }

    @Override
    public UnidbgPointer getLRPointer() {
        return UnidbgPointer.pointer(this.emulator, this.getLR());
    }

    @Override
    public UnidbgPointer getPCPointer() {
        return UnidbgPointer.register(this.emulator, 260);
    }

    @Override
    public UnidbgPointer getStackPointer() {
        return UnidbgPointer.register(this.emulator, 4);
    }

    @Override
    public void setStackPointer(Pointer sp) {
        this.backend.reg_write(4, ((UnidbgPointer)sp).peer);
    }
}

