/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.debugger.gdb;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.debugger.AbstractDebugServer;
import com.github.unidbg.debugger.gdb.BreakpointCommand;
import com.github.unidbg.debugger.gdb.ContinueCommand;
import com.github.unidbg.debugger.gdb.DetachCommand;
import com.github.unidbg.debugger.gdb.EnableExtendedModeCommand;
import com.github.unidbg.debugger.gdb.ExtendedCommand;
import com.github.unidbg.debugger.gdb.GdbStubCommand;
import com.github.unidbg.debugger.gdb.KillCommand;
import com.github.unidbg.debugger.gdb.LastSignalCommand;
import com.github.unidbg.debugger.gdb.MemoryCommand;
import com.github.unidbg.debugger.gdb.QueryCommand;
import com.github.unidbg.debugger.gdb.RegisterCommand;
import com.github.unidbg.debugger.gdb.RegistersCommand;
import com.github.unidbg.debugger.gdb.SetThreadCommand;
import com.github.unidbg.debugger.gdb.StepCommand;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GdbStub
extends AbstractDebugServer {
    private static final Log log = LogFactory.getLog(GdbStub.class);
    static final String SIGTRAP = "05";
    final int[] registers;
    private String lastPacket;
    private final StringBuilder currentInputPacket = new StringBuilder();
    private int packetChecksum;
    private int packetFinished;
    private static final Map<String, GdbStubCommand> commands = new HashMap<String, GdbStubCommand>();

    public GdbStub(Emulator<?> emulator) {
        super(emulator);
        if (emulator.is32Bit()) {
            this.registers = new int[]{66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 12, 10, 11, 3};
        } else {
            this.registers = new int[34];
            for (int i = 0; i <= 28; ++i) {
                this.registers[i] = 199 + i;
            }
            this.registers[29] = 1;
            this.registers[30] = 2;
            this.registers[31] = 4;
            this.registers[32] = 260;
            this.registers[33] = 3;
        }
    }

    @Override
    protected void onServerStart() {
        ArrayList<Module> loaded = new ArrayList<Module>(this.emulator.getMemory().getLoadedModules());
        Collections.sort(loaded, new Comparator<Module>(){

            @Override
            public int compare(Module o1, Module o2) {
                return (int)(o1.base - o2.base);
            }
        });
        for (Module module : loaded) {
            System.err.println("[0x" + Long.toHexString(module.base) + "]" + module.name);
        }
    }

    final void send(String packet) {
        this.sendData(packet.getBytes());
    }

    private void sendPacket(String packet) {
        this.lastPacket = packet;
        this.send(packet);
    }

    final void makePacketAndSend(String data2) {
        if (log.isDebugEnabled()) {
            log.debug("makePacketAndSend: " + data2);
        }
        int checksum = 0;
        data2 = this.escapePacketData(data2);
        StringBuilder sb = new StringBuilder();
        sb.append("+");
        sb.append("$");
        for (int i = 0; i < data2.length(); ++i) {
            sb.append(data2.charAt(i));
            checksum += (byte)data2.charAt(i);
        }
        sb.append("#");
        sb.append(String.format("%02x", checksum & 0xFF));
        this.sendPacket(sb.toString());
    }

    private String escapePacketData(String data2) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data2.length(); ++i) {
            char c = data2.charAt(i);
            if (c == '$' || c == '#' || c == '}') {
                sb.append("}");
                sb.append(c ^ 0x20);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    protected void processInput(ByteBuffer input) {
        input.flip();
        block6: while (input.hasRemaining()) {
            char c = (char)input.get();
            if (this.currentInputPacket.length() == 0) {
                switch (c) {
                    case '-': {
                        this.reTransmitLastPacket();
                        continue block6;
                    }
                    case '+': {
                        continue block6;
                    }
                    case '\u0003': {
                        this.setSingleStep(1);
                        continue block6;
                    }
                    case '$': {
                        this.currentInputPacket.append(c);
                        this.packetChecksum = 0;
                        this.packetFinished = 0;
                        continue block6;
                    }
                }
                this.requestRetransmit();
                continue;
            }
            this.currentInputPacket.append(c);
            if (this.packetFinished > 0) {
                if (++this.packetFinished != 3) continue;
                if (this.checkPacket()) {
                    this.processCommand(this.currentInputPacket.substring(1, this.currentInputPacket.length() - 3));
                } else {
                    this.requestRetransmit();
                }
                this.currentInputPacket.setLength(0);
                continue;
            }
            if (c == '#') {
                this.packetFinished = 1;
                continue;
            }
            this.packetChecksum += c;
        }
        input.clear();
    }

    private void requestRetransmit() {
        this.send("-");
    }

    private void reTransmitLastPacket() {
        this.send(this.lastPacket);
    }

    private boolean checkPacket() {
        try {
            int checksum = Integer.parseInt(this.currentInputPacket.substring(this.currentInputPacket.length() - 2), 16);
            return checksum == (this.packetChecksum & 0xFF);
        }
        catch (NumberFormatException ex) {
            if (log.isDebugEnabled()) {
                log.debug("checkPacket currentInputPacket=" + this.currentInputPacket, ex);
            }
            return false;
        }
    }

    private void processCommand(String command) {
        for (String prefix : commands.keySet()) {
            if (!command.startsWith(prefix)) continue;
            GdbStubCommand cmd = commands.get(prefix);
            if (log.isDebugEnabled()) {
                log.debug("processCommand command=" + command + ", cmd=" + cmd);
            }
            if (!cmd.processCommand(this.emulator, this, command)) continue;
            return;
        }
        if (log.isDebugEnabled()) {
            log.warn("Unsupported command=" + command);
        }
        this.makePacketAndSend("");
    }

    @Override
    protected void onHitBreakPoint(Emulator<?> emulator, long address) {
        if (this.isDebuggerConnected()) {
            this.makePacketAndSend("S05");
        }
    }

    @Override
    protected boolean onDebuggerExit() {
        this.makePacketAndSend("W00");
        return true;
    }

    @Override
    protected void onDebuggerConnected() {
    }

    public String toString() {
        return "gdb";
    }

    static {
        ContinueCommand commandContinue = new ContinueCommand();
        commands.put("c", commandContinue);
        StepCommand commandStep = new StepCommand();
        commands.put("s", commandStep);
        BreakpointCommand commandBreakpoint = new BreakpointCommand();
        commands.put("z0", commandBreakpoint);
        commands.put("Z0", commandBreakpoint);
        MemoryCommand commandMemory = new MemoryCommand();
        commands.put("m", commandMemory);
        commands.put("M", commandMemory);
        RegistersCommand commandRegisters = new RegistersCommand();
        commands.put("g", commandRegisters);
        commands.put("G", commandRegisters);
        RegisterCommand commandRegister = new RegisterCommand();
        commands.put("p", commandRegister);
        commands.put("P", commandRegister);
        KillCommand commandKill = new KillCommand();
        commands.put("k", commandKill);
        EnableExtendedModeCommand commandEnableExtendedMode = new EnableExtendedModeCommand();
        commands.put("!", commandEnableExtendedMode);
        LastSignalCommand commandLastSignal = new LastSignalCommand();
        commands.put("?", commandLastSignal);
        DetachCommand commandDetach = new DetachCommand();
        commands.put("D", commandDetach);
        QueryCommand commandQuery = new QueryCommand();
        commands.put("q", commandQuery);
        SetThreadCommand commandSetThread = new SetThreadCommand();
        commands.put("H", commandSetThread);
        ExtendedCommand commandVCont = new ExtendedCommand();
        commands.put("vCont", commandVCont);
    }
}

