/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.hook;

import com.github.unidbg.Emulator;
import com.github.unidbg.Family;
import com.github.unidbg.Module;
import com.github.unidbg.arm.Arm64Hook;
import com.github.unidbg.arm.ArmHook;
import com.github.unidbg.arm.HookStatus;
import com.github.unidbg.arm.context.EditableArm32RegisterContext;
import com.github.unidbg.arm.context.EditableArm64RegisterContext;
import com.github.unidbg.hook.Arm32HookContext;
import com.github.unidbg.hook.Arm64HookContext;
import com.github.unidbg.hook.IHook;
import com.github.unidbg.hook.ReplaceCallback;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.spi.LibraryFile;
import com.sun.jna.Pointer;
import java.net.URL;
import java.util.Stack;

public abstract class BaseHook
implements IHook {
    protected final Emulator<?> emulator;
    protected final Module module;

    public BaseHook(Emulator<?> emulator, String libName) {
        this.emulator = emulator;
        this.module = emulator.getMemory().load(this.resolveLibrary(libName));
    }

    protected Pointer createReplacePointer(final ReplaceCallback callback2, final Pointer backup, boolean enablePostCall) {
        SvcMemory svcMemory = this.emulator.getSvcMemory();
        return svcMemory.registerSvc(this.emulator.is64Bit() ? new Arm64Hook(enablePostCall){
            private final Stack<Object> context;
            {
                super(enablePostCall);
                this.context = new Stack();
            }

            @Override
            protected HookStatus hook(Emulator<?> emulator) {
                return callback2.onCall(emulator, new Arm64HookContext(this.context, (EditableArm64RegisterContext)emulator.getContext()), backup.getLong(0L));
            }

            @Override
            public void handlePostCallback(Emulator<?> emulator) {
                super.handlePostCallback(emulator);
                EditableArm64RegisterContext registerContext = (EditableArm64RegisterContext)emulator.getContext();
                callback2.postCall(emulator, new Arm64HookContext(this.context, registerContext));
            }
        } : new ArmHook(enablePostCall){
            private final Stack<Object> context;
            {
                super(enablePostCall);
                this.context = new Stack();
            }

            @Override
            protected HookStatus hook(Emulator<?> emulator) {
                return callback2.onCall(emulator, new Arm32HookContext(this.context, (EditableArm32RegisterContext)emulator.getContext()), (long)backup.getInt(0L) & 0xFFFFFFFFL);
            }

            @Override
            public void handlePostCallback(Emulator<?> emulator) {
                super.handlePostCallback(emulator);
                EditableArm32RegisterContext registerContext = (EditableArm32RegisterContext)emulator.getContext();
                callback2.postCall(emulator, new Arm32HookContext(this.context, registerContext));
            }
        });
    }

    protected LibraryFile resolveLibrary(String libName) {
        Family family = this.emulator.getFamily();
        String lib = libName + family.getLibraryExtension();
        URL url = BaseHook.class.getResource(family.getLibraryPath() + lib);
        if (url == null) {
            throw new IllegalStateException("resolve library failed: " + lib);
        }
        return this.emulator.createURLibraryFile(url, lib);
    }

    @Override
    public Module getModule() {
        return this.module;
    }
}

