/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.hook.hookzz;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.hook.hookzz.HookZzArm32RegisterContext;
import com.github.unidbg.hook.hookzz.HookZzRegisterContext;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.util.Stack;

public class HookZzArm32RegisterContextImpl
extends HookZzRegisterContext
implements RegisterContext,
HookZzArm32RegisterContext {
    private final Pointer reg_ctx;
    private final Emulator<?> emulator;

    HookZzArm32RegisterContextImpl(Emulator<?> emulator, Stack<Object> context) {
        super(context);
        this.reg_ctx = UnidbgPointer.register(emulator, 66).share(8L);
        this.emulator = emulator;
    }

    @Override
    public UnidbgPointer getPointerArg(int index) {
        if (index < 4) {
            switch (index) {
                case 0: {
                    return this.getR0Pointer();
                }
                case 1: {
                    return this.getR1Pointer();
                }
                case 2: {
                    return this.getR2Pointer();
                }
                case 3: {
                    return this.getR3Pointer();
                }
            }
            throw new IllegalArgumentException("index=" + index);
        }
        UnidbgPointer sp = this.getStackPointer();
        return sp.getPointer((long)(index - 4) * (long)this.emulator.getPointerSize());
    }

    @Override
    public void setR0(int r0) {
        this.reg_ctx.setInt(0L, r0);
    }

    @Override
    public void setR1(int r1) {
        this.reg_ctx.setInt(4L, r1);
    }

    @Override
    public void setR2(int r2) {
        this.reg_ctx.setInt(8L, r2);
    }

    @Override
    public void setR3(int r3) {
        this.reg_ctx.setInt(12L, r3);
    }

    @Override
    public void setR4(int r4) {
        this.reg_ctx.setInt(16L, r4);
    }

    @Override
    public void setR5(int r5) {
        this.reg_ctx.setInt(20L, r5);
    }

    @Override
    public void setR6(int r6) {
        this.reg_ctx.setInt(24L, r6);
    }

    @Override
    public void setR7(int r7) {
        this.reg_ctx.setInt(28L, r7);
    }

    @Override
    public void setStackPointer(Pointer sp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getR0Long() {
        return (long)this.reg_ctx.getInt(0L) & 0xFFFFFFFFL;
    }

    @Override
    public long getR1Long() {
        return (long)this.reg_ctx.getInt(4L) & 0xFFFFFFFFL;
    }

    @Override
    public long getR2Long() {
        return (long)this.reg_ctx.getInt(8L) & 0xFFFFFFFFL;
    }

    @Override
    public long getR3Long() {
        return (long)this.reg_ctx.getInt(12L) & 0xFFFFFFFFL;
    }

    @Override
    public long getR4Long() {
        return (long)this.reg_ctx.getInt(16L) & 0xFFFFFFFFL;
    }

    @Override
    public long getR5Long() {
        return (long)this.reg_ctx.getInt(20L) & 0xFFFFFFFFL;
    }

    @Override
    public long getR6Long() {
        return (long)this.reg_ctx.getInt(24L) & 0xFFFFFFFFL;
    }

    @Override
    public long getR7Long() {
        return (long)this.reg_ctx.getInt(28L) & 0xFFFFFFFFL;
    }

    @Override
    public long getR8Long() {
        return (long)this.reg_ctx.getInt(32L) & 0xFFFFFFFFL;
    }

    @Override
    public long getR9Long() {
        return (long)this.reg_ctx.getInt(36L) & 0xFFFFFFFFL;
    }

    @Override
    public long getR10Long() {
        return (long)this.reg_ctx.getInt(40L) & 0xFFFFFFFFL;
    }

    @Override
    public long getR11Long() {
        return (long)this.reg_ctx.getInt(44L) & 0xFFFFFFFFL;
    }

    @Override
    public long getR12Long() {
        return (long)this.reg_ctx.getInt(48L) & 0xFFFFFFFFL;
    }

    @Override
    public long getLR() {
        return (long)this.reg_ctx.getInt(52L) & 0xFFFFFFFFL;
    }

    @Override
    public int getR0Int() {
        return (int)this.getR0Long();
    }

    @Override
    public int getR1Int() {
        return (int)this.getR1Long();
    }

    @Override
    public int getR2Int() {
        return (int)this.getR2Long();
    }

    @Override
    public int getR3Int() {
        return (int)this.getR3Long();
    }

    @Override
    public int getR4Int() {
        return (int)this.getR4Long();
    }

    @Override
    public int getR5Int() {
        return (int)this.getR5Long();
    }

    @Override
    public int getR6Int() {
        return (int)this.getR6Long();
    }

    @Override
    public int getR7Int() {
        return (int)this.getR7Long();
    }

    @Override
    public int getR8Int() {
        return (int)this.getR8Long();
    }

    @Override
    public int getR9Int() {
        return (int)this.getR9Long();
    }

    @Override
    public int getR10Int() {
        return (int)this.getR10Long();
    }

    @Override
    public int getR11Int() {
        return (int)this.getR11Long();
    }

    @Override
    public int getR12Int() {
        return (int)this.getR12Long();
    }

    @Override
    public UnidbgPointer getStackPointer() {
        return (UnidbgPointer)this.reg_ctx.share(56L);
    }

    @Override
    public UnidbgPointer getR0Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR0Long());
    }

    @Override
    public UnidbgPointer getR1Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR1Long());
    }

    @Override
    public UnidbgPointer getR2Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR2Long());
    }

    @Override
    public UnidbgPointer getR3Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR3Long());
    }

    @Override
    public UnidbgPointer getR4Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR4Long());
    }

    @Override
    public UnidbgPointer getR5Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR5Long());
    }

    @Override
    public UnidbgPointer getR6Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR6Long());
    }

    @Override
    public UnidbgPointer getR7Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR7Long());
    }

    @Override
    public UnidbgPointer getR8Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR8Long());
    }

    @Override
    public UnidbgPointer getR9Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR9Long());
    }

    @Override
    public UnidbgPointer getR10Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR10Long());
    }

    @Override
    public UnidbgPointer getR11Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR11Long());
    }

    @Override
    public UnidbgPointer getR12Pointer() {
        return UnidbgPointer.pointer(this.emulator, this.getR12Long());
    }

    @Override
    public UnidbgPointer getLRPointer() {
        return UnidbgPointer.pointer(this.emulator, this.getLR());
    }
}

