/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.hook.whale;

import com.github.unidbg.Emulator;
import com.github.unidbg.Family;
import com.github.unidbg.Svc;
import com.github.unidbg.Symbol;
import com.github.unidbg.hook.BaseHook;
import com.github.unidbg.hook.ReplaceCallback;
import com.github.unidbg.hook.whale.IWhale;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Whale
extends BaseHook
implements IWhale {
    private static final Log log = LogFactory.getLog(Whale.class);
    private final Symbol WInlineHookFunction;
    private final Symbol WImportHookFunction;

    public static IWhale getInstance(Emulator<?> emulator) {
        IWhale whale = (IWhale)emulator.get(Whale.class.getName());
        if (whale == null) {
            whale = new Whale(emulator);
            emulator.set(Whale.class.getName(), whale);
        }
        return whale;
    }

    private Whale(Emulator<?> emulator) {
        super(emulator, "libwhale");
        boolean isIOS = emulator.getFamily() == Family.iOS;
        this.WInlineHookFunction = this.module.findSymbolByName(isIOS ? "_WInlineHookFunction" : "WInlineHookFunction", false);
        this.WImportHookFunction = this.module.findSymbolByName(isIOS ? "_WImportHookFunction" : "WImportHookFunction", false);
        if (log.isDebugEnabled()) {
            log.debug("WInlineHookFunction=" + this.WInlineHookFunction + ", WImportHookFunction=" + this.WImportHookFunction);
        }
        if (this.WInlineHookFunction == null) {
            throw new IllegalStateException("WInlineHookFunction is null");
        }
        if (this.WImportHookFunction == null) {
            throw new IllegalStateException("WImportHookFunction is null");
        }
    }

    @Override
    public void inlineHookFunction(long address, ReplaceCallback callback2) {
        this.inlineHookFunction(address, callback2, false);
    }

    @Override
    public void inlineHookFunction(Symbol symbol, ReplaceCallback callback2) {
        this.inlineHookFunction(symbol.getAddress(), callback2);
    }

    @Override
    public void replace(long functionAddress, ReplaceCallback callback2) {
        this.inlineHookFunction(functionAddress, callback2);
    }

    @Override
    public void replace(Symbol symbol, ReplaceCallback callback2) {
        this.inlineHookFunction(symbol, callback2);
    }

    @Override
    public void replace(long functionAddress, ReplaceCallback callback2, boolean enablePostCall) {
        this.inlineHookFunction(functionAddress, callback2, enablePostCall);
    }

    @Override
    public void replace(Symbol symbol, ReplaceCallback callback2, boolean enablePostCall) {
        this.inlineHookFunction(symbol, callback2, enablePostCall);
    }

    @Override
    public void inlineHookFunction(long address, ReplaceCallback callback2, boolean enablePostCall) {
        UnidbgPointer backup = this.emulator.getMemory().malloc(this.emulator.getPointerSize(), false).getPointer();
        Pointer replace = this.createReplacePointer(callback2, backup, enablePostCall);
        this.WInlineHookFunction.call(this.emulator, UnidbgPointer.pointer(this.emulator, address), replace, backup);
    }

    @Override
    public void replace(long functionAddress, Svc svc) {
        if (svc == null) {
            throw new NullPointerException();
        }
        UnidbgPointer originCall = this.emulator.getMemory().malloc(this.emulator.getPointerSize(), false).getPointer();
        UnidbgPointer callback2 = this.emulator.getSvcMemory().registerSvc(svc);
        this.WInlineHookFunction.call(this.emulator, UnidbgPointer.pointer(this.emulator, functionAddress), callback2, originCall);
    }

    @Override
    public void replace(Symbol symbol, Svc svc) {
        this.replace(symbol.getAddress(), svc);
    }

    @Override
    public void inlineHookFunction(Symbol symbol, ReplaceCallback callback2, boolean enablePostCall) {
        this.inlineHookFunction(symbol.getAddress(), callback2, enablePostCall);
    }

    @Override
    public void importHookFunction(String symbol, ReplaceCallback callback2) {
        this.importHookFunction(symbol, callback2, false);
    }

    @Override
    public void importHookFunction(String symbol, ReplaceCallback callback2, boolean enablePostCall) {
        UnidbgPointer backup = this.emulator.getMemory().malloc(this.emulator.getPointerSize(), false).getPointer();
        Pointer replace = this.createReplacePointer(callback2, backup, enablePostCall);
        this.WImportHookFunction.call(this.emulator, symbol, null, replace, backup);
    }
}

