/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux;

import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.LongJumpException;
import com.github.unidbg.StopEmulatorException;
import com.github.unidbg.Svc;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.context.Arm32RegisterContext;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.file.FileResult;
import com.github.unidbg.file.IOResolver;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.linux.AndroidSyscallHandler;
import com.github.unidbg.linux.android.AndroidResolver;
import com.github.unidbg.linux.file.ByteArrayFileIO;
import com.github.unidbg.linux.file.DriverFileIO;
import com.github.unidbg.linux.file.LocalAndroidUdpSocket;
import com.github.unidbg.linux.file.LocalSocketIO;
import com.github.unidbg.linux.file.NetLinkSocket;
import com.github.unidbg.linux.file.TcpSocket;
import com.github.unidbg.linux.file.UdpSocket;
import com.github.unidbg.linux.struct.Stat32;
import com.github.unidbg.linux.struct.SysInfo32;
import com.github.unidbg.linux.thread.KitKatThread;
import com.github.unidbg.linux.thread.MarshmallowThread;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.thread.PopContextException;
import com.github.unidbg.thread.Task;
import com.github.unidbg.thread.ThreadContextSwitchException;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ARM32SyscallHandler
extends AndroidSyscallHandler {
    private static final Log log = LogFactory.getLog(ARM32SyscallHandler.class);
    private final SvcMemory svcMemory;
    private static final int CLONE_VM = 256;
    private static final int CLONE_FS = 512;
    private static final int CLONE_FILES = 1024;
    private static final int CLONE_SIGHAND = 2048;
    private static final int CLONE_PTRACE = 8192;
    private static final int CLONE_VFORK = 16384;
    private static final int CLONE_PARENT = 32768;
    private static final int CLONE_THREAD = 65536;
    private static final int CLONE_NEWNS = 131072;
    private static final int CLONE_SYSVSEM = 262144;
    private static final int CLONE_SETTLS = 524288;
    private static final int CLONE_PARENT_SETTID = 0x100000;
    private static final int CLONE_CHILD_CLEARTID = 0x200000;
    private static final int CLONE_DETACHED = 0x400000;
    private static final int CLONE_UNTRACED = 0x800000;
    private static final int CLONE_CHILD_SETTID = 0x1000000;
    private static final int CLONE_STOPPED = 0x2000000;
    private long persona;
    private static final short POLLIN = 1;
    private static final short POLLOUT = 4;
    private int mask = 18;
    private int sdk;
    private static final int PR_GET_DUMPABLE = 3;
    private static final int PR_SET_DUMPABLE = 4;
    private static final int PR_SET_NAME = 15;
    private static final int PR_GET_NAME = 16;
    private static final int BIONIC_PR_SET_VMA = 1398164801;
    private static final int PR_SET_PTRACER = 1499557217;
    private static final int CLOCK_REALTIME = 0;
    private static final int CLOCK_MONOTONIC = 1;
    private static final int CLOCK_THREAD_CPUTIME_ID = 3;
    private static final int CLOCK_MONOTONIC_RAW = 4;
    private static final int CLOCK_MONOTONIC_COARSE = 6;
    private static final int CLOCK_BOOTTIME = 7;
    private final long nanoTime = System.nanoTime();
    private static final int MMAP2_SHIFT = 12;

    public ARM32SyscallHandler(SvcMemory svcMemory) {
        this.svcMemory = svcMemory;
    }

    @Override
    public void hook(Backend backend, int intno, int swi, Object user) {
        int bkpt;
        Emulator emulator = (Emulator)user;
        UnidbgPointer pc = UnidbgPointer.register(emulator, 11);
        if (pc == null) {
            bkpt = swi;
        } else if (ARM.isThumb(backend)) {
            bkpt = pc.getShort(0L) & 0xFF;
        } else {
            int instruction = pc.getInt(0L);
            bkpt = instruction & 0xF | (instruction >> 8 & 0xFFF) << 4;
        }
        if (intno == 7) {
            this.createBreaker(emulator).brk(pc, bkpt);
            return;
        }
        if (intno == 1) {
            this.createBreaker(emulator).debug();
            return;
        }
        if (intno != 2) {
            throw new BackendException("intno=" + intno);
        }
        int NR = backend.reg_read(73).intValue();
        String syscall = null;
        Throwable exception = null;
        try {
            if (swi == 0 && NR == 0 && backend.reg_read(71).intValue() == 34952) {
                int number = backend.reg_read(70).intValue();
                Svc svc = this.svcMemory.getSvc(number);
                if (svc != null) {
                    svc.handlePostCallback(emulator);
                    return;
                }
                backend.emu_stop();
                throw new IllegalStateException("svc number: " + swi);
            }
            if (swi == 0 && NR == 0 && backend.reg_read(71).intValue() == 34918) {
                int number = backend.reg_read(70).intValue();
                Svc svc = this.svcMemory.getSvc(number);
                if (svc != null) {
                    svc.handlePreCallback(emulator);
                    return;
                }
                backend.emu_stop();
                throw new IllegalStateException("svc number: " + swi);
            }
            if (swi != 0) {
                if (swi == (ARM.isThumb(backend) ? 255 : 0xFFFFFF)) {
                    throw new PopContextException();
                }
                if (swi == (ARM.isThumb(backend) ? 255 : 0xFFFFFF) - 1) {
                    throw new ThreadContextSwitchException();
                }
                Svc svc = this.svcMemory.getSvc(swi);
                if (svc != null) {
                    backend.reg_write(66, (int)svc.handle(emulator));
                    return;
                }
                backend.emu_stop();
                throw new IllegalStateException("svc number: " + swi);
            }
            if (log.isTraceEnabled()) {
                ARM.showThumbRegs(emulator);
            }
            if (this.handleSyscall(emulator, NR)) {
                return;
            }
            switch (NR) {
                case 1: {
                    this.exit(emulator);
                    return;
                }
                case 2: {
                    backend.reg_write(66, this.fork(emulator));
                    return;
                }
                case 3: {
                    backend.reg_write(66, this.read(emulator));
                    return;
                }
                case 4: {
                    backend.reg_write(66, this.write(emulator));
                    return;
                }
                case 5: {
                    backend.reg_write(66, this.open(emulator));
                    return;
                }
                case 6: {
                    backend.reg_write(66, this.close(emulator));
                    return;
                }
                case 10: {
                    backend.reg_write(66, this.unlink(emulator));
                    return;
                }
                case 11: {
                    backend.reg_write(66, this.execve(emulator));
                    return;
                }
                case 19: {
                    backend.reg_write(66, this.lseek(emulator));
                    return;
                }
                case 26: {
                    backend.reg_write(66, this.ptrace(emulator));
                    return;
                }
                case 20: {
                    backend.reg_write(66, emulator.getPid());
                    return;
                }
                case 224: {
                    Task task = (Task)emulator.get(Task.TASK_KEY);
                    backend.reg_write(66, task == null ? 0 : task.getId());
                    return;
                }
                case 33: {
                    backend.reg_write(66, this.access(emulator));
                    return;
                }
                case 36: {
                    return;
                }
                case 37: {
                    backend.reg_write(66, this.kill(emulator));
                    return;
                }
                case 38: {
                    backend.reg_write(66, this.rename(emulator));
                    return;
                }
                case 39: {
                    backend.reg_write(66, this.mkdir(emulator));
                    return;
                }
                case 41: {
                    backend.reg_write(66, this.dup(emulator));
                    return;
                }
                case 42: {
                    backend.reg_write(66, this.pipe(emulator));
                    return;
                }
                case 45: {
                    backend.reg_write(66, this.brk(emulator));
                    return;
                }
                case 54: {
                    backend.reg_write(66, this.ioctl(emulator));
                    return;
                }
                case 57: {
                    backend.reg_write(66, this.setpgid(emulator));
                    return;
                }
                case 60: {
                    backend.reg_write(66, this.umask(emulator));
                    return;
                }
                case 63: {
                    backend.reg_write(66, this.dup2(backend, emulator));
                    return;
                }
                case 64: {
                    backend.reg_write(66, this.getppid(emulator));
                    return;
                }
                case 67: {
                    backend.reg_write(66, this.sigaction(emulator));
                    return;
                }
                case 73: {
                    backend.reg_write(66, this.rt_sigpending(emulator));
                    return;
                }
                case 78: {
                    backend.reg_write(66, this.gettimeofday(emulator));
                    return;
                }
                case 85: {
                    backend.reg_write(66, this.readlink(emulator));
                    return;
                }
                case 88: {
                    backend.reg_write(66, this.reboot(backend, emulator));
                    return;
                }
                case 91: {
                    backend.reg_write(66, this.munmap(backend, emulator));
                    return;
                }
                case 93: {
                    backend.reg_write(66, this.ftruncate(backend));
                    return;
                }
                case 94: {
                    backend.reg_write(66, this.fchmod(backend));
                    return;
                }
                case 96: {
                    backend.reg_write(66, this.getpriority(emulator));
                    return;
                }
                case 97: {
                    backend.reg_write(66, this.setpriority(emulator));
                    return;
                }
                case 103: {
                    backend.reg_write(66, this.syslog(backend, emulator));
                    return;
                }
                case 104: {
                    backend.reg_write(66, this.setitimer(emulator));
                    return;
                }
                case 116: {
                    backend.reg_write(66, this.sysinfo(emulator));
                    return;
                }
                case 118: {
                    backend.reg_write(66, this.fsync(backend));
                    return;
                }
                case 120: {
                    backend.reg_write(66, this.clone(emulator));
                    return;
                }
                case 122: {
                    backend.reg_write(66, this.uname(emulator));
                    return;
                }
                case 125: {
                    backend.reg_write(66, this.mprotect(backend, emulator));
                    return;
                }
                case 126: 
                case 175: {
                    backend.reg_write(66, this.sigprocmask(emulator));
                    return;
                }
                case 132: {
                    syscall = "getpgid";
                    break;
                }
                case 136: {
                    backend.reg_write(66, this.personality(backend));
                    return;
                }
                case 140: {
                    backend.reg_write(66, this.llseek(backend, emulator));
                    return;
                }
                case 142: {
                    backend.reg_write(66, this.newselect(backend, emulator));
                    return;
                }
                case 143: {
                    backend.reg_write(66, this.flock(backend));
                    return;
                }
                case 146: {
                    backend.reg_write(66, this.writev(backend, emulator));
                    return;
                }
                case 147: {
                    backend.reg_write(66, this.getsid(emulator));
                    return;
                }
                case 150: {
                    backend.reg_write(66, this.mlock(emulator));
                    return;
                }
                case 155: {
                    backend.reg_write(66, this.sched_getparam(emulator));
                    return;
                }
                case 156: {
                    backend.reg_write(66, this.sched_setscheduler(emulator));
                    return;
                }
                case 157: {
                    backend.reg_write(66, this.sched_getscheduler(emulator));
                    return;
                }
                case 158: {
                    backend.reg_write(66, this.sched_yield(emulator));
                    return;
                }
                case 162: {
                    backend.reg_write(66, this.nanosleep(emulator));
                    return;
                }
                case 163: {
                    backend.reg_write(66, this.mremap(emulator));
                    return;
                }
                case 168: 
                case 336: {
                    backend.reg_write(66, this.poll(backend, emulator));
                    return;
                }
                case 172: {
                    backend.reg_write(66, this.prctl(backend, emulator));
                    return;
                }
                case 176: {
                    backend.reg_write(66, this.rt_sigpending(emulator));
                    return;
                }
                case 177: {
                    backend.reg_write(66, this.rt_sigtimedwait(emulator));
                    return;
                }
                case 178: {
                    backend.reg_write(66, this.rt_sigqueue(emulator));
                    return;
                }
                case 180: {
                    backend.reg_write(66, this.pread64(emulator));
                    return;
                }
                case 183: {
                    backend.reg_write(66, this.getcwd(emulator));
                    return;
                }
                case 186: {
                    backend.reg_write(66, this.sigaltstack(emulator));
                    return;
                }
                case 192: {
                    backend.reg_write(66, this.mmap2(backend, emulator));
                    return;
                }
                case 194: {
                    backend.reg_write(66, this.ftruncate(backend));
                    return;
                }
                case 195: {
                    backend.reg_write(66, this.stat64(emulator));
                    return;
                }
                case 196: {
                    backend.reg_write(66, this.lstat(emulator));
                    return;
                }
                case 197: {
                    backend.reg_write(66, this.fstat(backend, emulator));
                    return;
                }
                case 199: 
                case 200: 
                case 201: 
                case 202: {
                    backend.reg_write(66, 0);
                    return;
                }
                case 205: {
                    backend.reg_write(66, this.getgroups(backend, emulator));
                    return;
                }
                case 208: {
                    backend.reg_write(66, this.setresuid32(backend));
                    return;
                }
                case 210: {
                    backend.reg_write(66, this.setresgid32(backend));
                    return;
                }
                case 214: {
                    backend.reg_write(66, this.setgid32(emulator));
                    return;
                }
                case 217: {
                    backend.reg_write(66, this.getdents64(emulator));
                    return;
                }
                case 220: {
                    syscall = "madvise";
                    backend.reg_write(66, 0);
                    return;
                }
                case 221: {
                    backend.reg_write(66, this.fcntl(backend, emulator));
                    return;
                }
                case 230: {
                    backend.reg_write(66, this.lgetxattr(backend, emulator));
                    return;
                }
                case 238: {
                    backend.reg_write(66, this.tkill(emulator));
                    return;
                }
                case 240: {
                    backend.reg_write(66, this.futex(emulator));
                    return;
                }
                case 241: {
                    backend.reg_write(66, this.sched_setaffinity(emulator));
                    return;
                }
                case 242: {
                    backend.reg_write(66, this.sched_getaffinity(emulator));
                    return;
                }
                case 248: {
                    this.exit_group(emulator);
                    return;
                }
                case 256: {
                    backend.reg_write(66, this.set_tid_address(emulator));
                    return;
                }
                case 263: {
                    backend.reg_write(66, this.clock_gettime(backend, emulator));
                    return;
                }
                case 266: {
                    Object context = emulator.getContext();
                    UnidbgPointer pathPointer = context.getPointerArg(0);
                    int size = context.getIntArg(1);
                    UnidbgPointer buf = context.getPointerArg(2).setSize(size);
                    String path = ((Pointer)pathPointer).getString(0L);
                    backend.reg_write(66, (int)this.statfs64(emulator, path, buf));
                    return;
                }
                case 268: {
                    backend.reg_write(66, this.tgkill(emulator));
                    return;
                }
                case 269: {
                    backend.reg_write(66, this.utimes(emulator));
                    return;
                }
                case 281: {
                    backend.reg_write(66, this.socket(backend, emulator));
                    return;
                }
                case 282: {
                    backend.reg_write(66, this.bind(emulator));
                    return;
                }
                case 283: {
                    backend.reg_write(66, this.connect(backend, emulator));
                    return;
                }
                case 284: {
                    backend.reg_write(66, this.listen(emulator));
                    return;
                }
                case 285: {
                    backend.reg_write(66, this.accept(emulator));
                    return;
                }
                case 286: {
                    backend.reg_write(66, this.getsockname(backend, emulator));
                    return;
                }
                case 287: {
                    backend.reg_write(66, this.getpeername(backend, emulator));
                    return;
                }
                case 290: {
                    backend.reg_write(66, this.sendto(backend, emulator));
                    return;
                }
                case 292: {
                    backend.reg_write(66, this.recvfrom(emulator));
                    return;
                }
                case 293: {
                    backend.reg_write(66, this.shutdown(backend, emulator));
                    return;
                }
                case 294: {
                    backend.reg_write(66, this.setsockopt(backend, emulator));
                    return;
                }
                case 295: {
                    backend.reg_write(66, this.getsockopt(backend, emulator));
                    return;
                }
                case 322: {
                    backend.reg_write(66, this.openat(emulator));
                    return;
                }
                case 323: {
                    backend.reg_write(66, this.mkdirat(emulator));
                    return;
                }
                case 327: {
                    backend.reg_write(66, this.fstatat64(backend, emulator));
                    return;
                }
                case 328: {
                    backend.reg_write(66, this.unlinkat(emulator));
                    return;
                }
                case 332: {
                    backend.reg_write(66, this.readlinkat(emulator));
                    return;
                }
                case 329: {
                    backend.reg_write(66, this.renameat(emulator));
                    return;
                }
                case 334: {
                    backend.reg_write(66, this.faccessat(backend, emulator));
                    return;
                }
                case 335: {
                    backend.reg_write(66, this.pselect6(emulator));
                    return;
                }
                case 345: {
                    backend.reg_write(66, this.getcpu(emulator));
                    return;
                }
                case 348: {
                    backend.reg_write(66, this.utimensat(backend, emulator));
                    return;
                }
                case 356: {
                    backend.reg_write(66, this.eventfd2(emulator));
                    return;
                }
                case 352: {
                    backend.reg_write(66, this.fallocate(emulator));
                    return;
                }
                case 358: {
                    backend.reg_write(66, this.dup3(emulator));
                    return;
                }
                case 359: {
                    backend.reg_write(66, this.pipe2(emulator));
                    return;
                }
                case 366: {
                    backend.reg_write(66, this.accept4(emulator));
                    return;
                }
                case 384: {
                    backend.reg_write(66, this.getrandom(emulator));
                    return;
                }
                case 983042: {
                    backend.reg_write(66, this.cacheflush(backend, emulator));
                    return;
                }
                case 983045: {
                    backend.reg_write(66, this.set_tls(backend, emulator));
                    return;
                }
            }
        }
        catch (StopEmulatorException e) {
            backend.emu_stop();
            return;
        }
        catch (LongJumpException e) {
            backend.emu_stop();
            throw e;
        }
        catch (Throwable e) {
            backend.emu_stop();
            exception = e;
        }
        if (exception == null && this.handleUnknownSyscall(emulator, NR)) {
            return;
        }
        log.warn("handleInterrupt intno=" + intno + ", NR=" + NR + ", svcNumber=0x" + Integer.toHexString(swi) + ", PC=" + pc + ", LR=" + emulator.getContext().getLRPointer() + ", syscall=" + syscall, exception);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
    }

    private int mlock(Emulator<?> emulator) {
        Object context = emulator.getContext();
        UnidbgPointer addr = context.getPointerArg(0);
        int len = context.getIntArg(1);
        if (log.isDebugEnabled()) {
            log.debug("mlock addr=" + addr + ", len=" + len);
        }
        return 0;
    }

    private int getrandom(Emulator<?> emulator) {
        Object context = emulator.getContext();
        UnidbgPointer buf = context.getPointerArg(0);
        int bufSize = context.getIntArg(1);
        int flags = context.getIntArg(2);
        return this.getrandom(buf, bufSize, flags);
    }

    private int clone(Emulator<?> emulator) {
        Arm32RegisterContext context = (Arm32RegisterContext)emulator.getContext();
        UnidbgPointer child_stack = context.getPointerArg(1);
        if (child_stack == null && context.getPointerArg(2) == null) {
            return this.fork(emulator);
        }
        int fn = context.getR5Int();
        int arg = context.getR6Int();
        if (child_stack != null && ((Pointer)child_stack).getInt(0L) == fn && ((Pointer)child_stack).getInt(4L) == arg) {
            return this.bionic_clone(emulator);
        }
        return this.pthread_clone(emulator);
    }

    private int tkill(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int tid = context.getIntArg(0);
        int sig = context.getIntArg(1);
        if (log.isDebugEnabled()) {
            log.debug("tkill tid=" + tid + ", sig=" + sig);
        }
        return 0;
    }

    private int setpgid(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int pid = context.getIntArg(0);
        int pgid = context.getIntArg(1);
        if (log.isDebugEnabled()) {
            log.debug("setpgid pid=" + pid + ", pgid=" + pgid);
        }
        return 0;
    }

    private int getsid(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int pid = context.getIntArg(0);
        if (log.isDebugEnabled()) {
            log.debug("getsid pid=" + pid);
        }
        return emulator.getPid();
    }

    private int readlinkat(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int dirfd = context.getIntArg(0);
        UnidbgPointer pathname = context.getPointerArg(1);
        UnidbgPointer buf = context.getPointerArg(2);
        int bufSize = context.getIntArg(3);
        String path = ((Pointer)pathname).getString(0L);
        if (dirfd != -100) {
            throw new BackendException();
        }
        return this.readlink(emulator, path, buf, bufSize);
    }

    private int readlink(Emulator<?> emulator) {
        Object context = emulator.getContext();
        UnidbgPointer pathname = context.getPointerArg(0);
        UnidbgPointer buf = context.getPointerArg(1);
        int bufSize = context.getIntArg(2);
        String path = ((Pointer)pathname).getString(0L);
        return this.readlink(emulator, path, buf, bufSize);
    }

    private int getppid(Emulator<?> emulator) {
        if (log.isDebugEnabled()) {
            log.debug("getppid");
        }
        return emulator.getPid();
    }

    private int getcpu(Emulator<?> emulator) {
        Arm32RegisterContext context = (Arm32RegisterContext)emulator.getContext();
        UnidbgPointer cpu = context.getR0Pointer();
        UnidbgPointer node = context.getR1Pointer();
        UnidbgPointer tcache = context.getR2Pointer();
        if (log.isDebugEnabled()) {
            log.debug("getcpu cpu=" + cpu + ", node=" + node + ", tcache=" + tcache);
        }
        if (cpu != null) {
            ((Pointer)cpu).setInt(0L, 0);
        }
        if (node != null) {
            ((Pointer)node).setInt(0L, 0);
        }
        return 0;
    }

    private int sysinfo(Emulator<?> emulator) {
        Arm32RegisterContext context = (Arm32RegisterContext)emulator.getContext();
        UnidbgPointer info = context.getR0Pointer();
        if (log.isDebugEnabled()) {
            log.debug("sysinfo info=" + info);
        }
        SysInfo32 sysInfo32 = new SysInfo32(info);
        sysInfo32.pack();
        return 0;
    }

    private int mremap(Emulator<?> emulator) {
        boolean fixed;
        Arm32RegisterContext context = (Arm32RegisterContext)emulator.getContext();
        UnidbgPointer old_address = context.getR0Pointer();
        int old_size = context.getR1Int();
        int new_size = context.getR2Int();
        int flags = context.getR3Int();
        UnidbgPointer new_address = context.getR4Pointer();
        if (log.isDebugEnabled()) {
            log.debug("mremap old_address=" + old_address + ", old_size=" + old_size + ", new_size=" + new_size + ", flags=" + flags + ", new_address=" + new_address);
        }
        if (old_size == 0) {
            throw new BackendException("old_size is zero");
        }
        boolean bl = fixed = (flags & 2) != 0;
        if ((flags & 1) == 0) {
            throw new BackendException("flags=" + flags);
        }
        Memory memory = emulator.getMemory();
        byte[] data2 = old_address.getByteArray(0L, old_size);
        int prot = memory.munmap(old_address.toUIntPeer(), old_size);
        long address = fixed ? memory.mmap2(new_address.toUIntPeer(), new_size, prot, 48, 0, 0) : memory.mmap2(0L, new_size, prot, 32, 0, 0);
        UnidbgPointer pointer = UnidbgPointer.pointer(emulator, address);
        assert (pointer != null);
        pointer.write(0L, data2, 0, data2.length);
        return (int)pointer.toUIntPeer();
    }

    protected int ptrace(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        int request = backend.reg_read(66).intValue();
        int pid = backend.reg_read(67).intValue();
        UnidbgPointer addr = UnidbgPointer.register(emulator, 68);
        UnidbgPointer data2 = UnidbgPointer.register(emulator, 69);
        log.info("ptrace request=0x" + Integer.toHexString(request) + ", pid=" + pid + ", addr=" + addr + ", data=" + data2);
        return 0;
    }

    private int utimes(Emulator<?> emulator) {
        UnidbgPointer filename = UnidbgPointer.register(emulator, 66);
        UnidbgPointer times = UnidbgPointer.register(emulator, 67);
        if (log.isDebugEnabled()) {
            log.debug("utimes filename=" + ((Pointer)filename).getString(0L) + ", times=" + times);
        }
        return 0;
    }

    private int utimensat(Backend backend, Emulator<?> emulator) {
        int dirfd = backend.reg_read(66).intValue();
        UnidbgPointer pathname = UnidbgPointer.register(emulator, 67);
        UnidbgPointer times = UnidbgPointer.register(emulator, 68);
        int flags = backend.reg_read(69).intValue();
        if (log.isDebugEnabled()) {
            log.debug("utimensat dirfd=" + dirfd + ", pathname=" + ((Pointer)pathname).getString(0L) + ", times=" + times + ", flags=" + flags);
        }
        return 0;
    }

    private int fsync(Backend backend) {
        int fd = backend.reg_read(66).intValue();
        if (log.isDebugEnabled()) {
            log.debug("fsync fd=" + fd);
        }
        return 0;
    }

    private int rename(Emulator<?> emulator) {
        Arm32RegisterContext context = (Arm32RegisterContext)emulator.getContext();
        UnidbgPointer oldpath = context.getR0Pointer();
        UnidbgPointer newpath = context.getR1Pointer();
        log.info("rename oldpath=" + ((Pointer)oldpath).getString(0L) + ", newpath=" + ((Pointer)newpath).getString(0L));
        return 0;
    }

    private int unlink(Emulator<?> emulator) {
        UnidbgPointer pathname = UnidbgPointer.register(emulator, 66);
        String path = FilenameUtils.normalize(((Pointer)pathname).getString(0L), true);
        log.info("unlink path=" + path);
        return 0;
    }

    private int pipe(Emulator<?> emulator) {
        UnidbgPointer pipefd = UnidbgPointer.register(emulator, 66);
        int readfd = ((Pointer)pipefd).getInt(0L);
        int writefd = ((Pointer)pipefd).getInt(4L);
        log.info("pipe readfd=" + readfd + ", writefd=" + writefd);
        emulator.getMemory().setErrno(14);
        return -1;
    }

    private int set_tls(Backend backend, Emulator<?> emulator) {
        UnidbgPointer tls = UnidbgPointer.register(emulator, 66);
        if (log.isDebugEnabled()) {
            log.debug("set_tls: " + tls);
        }
        backend.reg_write(113, tls.peer);
        return 0;
    }

    private int cacheflush(Backend backend, Emulator<?> emulator) {
        UnidbgPointer begin = UnidbgPointer.register(emulator, 66);
        UnidbgPointer end = UnidbgPointer.register(emulator, 67);
        int cache = backend.reg_read(68).intValue();
        if (log.isDebugEnabled()) {
            log.debug("cacheflush begin=" + begin + ", end=" + end + ", cache=" + cache);
        }
        return 0;
    }

    protected int fork(Emulator<?> emulator) {
        log.info("fork");
        Log log = LogFactory.getLog(AbstractEmulator.class);
        if (log.isDebugEnabled()) {
            this.createBreaker(emulator).debug();
        }
        emulator.getMemory().setErrno(38);
        return -1;
    }

    private int pthread_clone(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int flags = context.getIntArg(0);
        UnidbgPointer child_stack = context.getPointerArg(1);
        ArrayList<String> list = new ArrayList<String>();
        if ((flags & 0x100) != 0) {
            list.add("CLONE_VM");
        }
        if ((flags & 0x200) != 0) {
            list.add("CLONE_FS");
        }
        if ((flags & 0x400) != 0) {
            list.add("CLONE_FILES");
        }
        if ((flags & 0x800) != 0) {
            list.add("CLONE_SIGHAND");
        }
        if ((flags & 0x2000) != 0) {
            list.add("CLONE_PTRACE");
        }
        if ((flags & 0x4000) != 0) {
            list.add("CLONE_VFORK");
        }
        if ((flags & 0x8000) != 0) {
            list.add("CLONE_PARENT");
        }
        if ((flags & 0x10000) != 0) {
            list.add("CLONE_THREAD");
        }
        if ((flags & 0x20000) != 0) {
            list.add("CLONE_NEWNS");
        }
        if ((flags & 0x40000) != 0) {
            list.add("CLONE_SYSVSEM");
        }
        if ((flags & 0x80000) != 0) {
            list.add("CLONE_SETTLS");
        }
        if ((flags & 0x100000) != 0) {
            list.add("CLONE_PARENT_SETTID");
        }
        if ((flags & 0x200000) != 0) {
            list.add("CLONE_CHILD_CLEARTID");
        }
        if ((flags & 0x400000) != 0) {
            list.add("CLONE_DETACHED");
        }
        if ((flags & 0x800000) != 0) {
            list.add("CLONE_UNTRACED");
        }
        if ((flags & 0x1000000) != 0) {
            list.add("CLONE_CHILD_SETTID");
        }
        if ((flags & 0x2000000) != 0) {
            list.add("CLONE_STOPPED");
        }
        int threadId = this.incrementThreadId(emulator);
        UnidbgPointer fn = child_stack.getPointer(0L);
        child_stack = child_stack.share(4L, 0L);
        UnidbgPointer arg = child_stack.getPointer(0L);
        child_stack = child_stack.share(4L, 0L);
        if (this.threadDispatcherEnabled) {
            if (this.verbose) {
                System.out.printf("pthread_clone fn=%s%n", fn);
            }
            emulator.getThreadDispatcher().addThread(new KitKatThread(threadId, emulator.getReturnAddress(), child_stack, fn, arg));
            return threadId;
        }
        log.info("pthread_clone child_stack=" + child_stack + ", thread_id=" + threadId + ", fn=" + fn + ", arg=" + arg + ", flags=" + list);
        Log log = LogFactory.getLog(AbstractEmulator.class);
        if (log.isDebugEnabled()) {
            emulator.attach().debug();
        }
        return threadId;
    }

    private int bionic_clone(Emulator<?> emulator) {
        Arm32RegisterContext context = (Arm32RegisterContext)emulator.getContext();
        int flags = context.getR0Int();
        UnidbgPointer child_stack = context.getR1Pointer();
        UnidbgPointer pid = context.getR2Pointer();
        UnidbgPointer tls = context.getR3Pointer();
        UnidbgPointer ctid = context.getR4Pointer();
        UnidbgPointer fn = context.getR5Pointer();
        UnidbgPointer arg = context.getR6Pointer();
        ArrayList<String> list = new ArrayList<String>();
        if ((flags & 0x100) != 0) {
            list.add("CLONE_VM");
        }
        if ((flags & 0x200) != 0) {
            list.add("CLONE_FS");
        }
        if ((flags & 0x400) != 0) {
            list.add("CLONE_FILES");
        }
        if ((flags & 0x800) != 0) {
            list.add("CLONE_SIGHAND");
        }
        if ((flags & 0x2000) != 0) {
            list.add("CLONE_PTRACE");
        }
        if ((flags & 0x4000) != 0) {
            list.add("CLONE_VFORK");
        }
        if ((flags & 0x8000) != 0) {
            list.add("CLONE_PARENT");
        }
        if ((flags & 0x10000) != 0) {
            list.add("CLONE_THREAD");
        }
        if ((flags & 0x20000) != 0) {
            list.add("CLONE_NEWNS");
        }
        if ((flags & 0x40000) != 0) {
            list.add("CLONE_SYSVSEM");
        }
        if ((flags & 0x80000) != 0) {
            list.add("CLONE_SETTLS");
        }
        if ((flags & 0x100000) != 0) {
            list.add("CLONE_PARENT_SETTID");
        }
        if ((flags & 0x200000) != 0) {
            list.add("CLONE_CHILD_CLEARTID");
        }
        if ((flags & 0x400000) != 0) {
            list.add("CLONE_DETACHED");
        }
        if ((flags & 0x800000) != 0) {
            list.add("CLONE_UNTRACED");
        }
        if ((flags & 0x1000000) != 0) {
            list.add("CLONE_CHILD_SETTID");
        }
        if ((flags & 0x2000000) != 0) {
            list.add("CLONE_STOPPED");
        }
        int threadId = this.incrementThreadId(emulator);
        if (log.isDebugEnabled()) {
            log.debug("bionic_clone child_stack=" + child_stack + ", thread_id=" + threadId + ", pid=" + pid + ", tls=" + tls + ", ctid=" + ctid + ", fn=" + fn + ", arg=" + arg + ", flags=" + list);
        }
        if (this.threadDispatcherEnabled) {
            if (this.verbose) {
                System.out.printf("bionic_clone fn=%s%n", fn);
            }
            emulator.getThreadDispatcher().addThread(new MarshmallowThread(emulator, fn, arg, ctid, threadId));
        }
        ((Pointer)ctid).setInt(0L, threadId);
        return threadId;
    }

    private int flock(Backend backend) {
        int fd = backend.reg_read(66).intValue();
        int operation = backend.reg_read(67).intValue();
        if (log.isDebugEnabled()) {
            log.debug("flock fd=" + fd + ", operation=" + operation);
        }
        return 0;
    }

    private int fchmod(Backend backend) {
        int fd = backend.reg_read(66).intValue();
        int mode = backend.reg_read(67).intValue();
        if (log.isDebugEnabled()) {
            log.debug("fchmod fd=" + fd + ", mode=" + mode);
        }
        return 0;
    }

    private int llseek(Backend backend, Emulator<?> emulator) {
        FileIO io;
        int fd = backend.reg_read(66).intValue();
        long offset_high = (long)backend.reg_read(67).intValue() & 0xFFFFFFFFL;
        long offset_low = (long)backend.reg_read(68).intValue() & 0xFFFFFFFFL;
        long offset = offset_high << 32 | offset_low;
        UnidbgPointer result = UnidbgPointer.register(emulator, 69);
        int whence = backend.reg_read(70).intValue();
        if (log.isDebugEnabled()) {
            log.debug("llseek fd=" + fd + ", offset_high=" + offset_high + ", offset_low=" + offset_low + ", result=" + result + ", whence=" + whence);
        }
        if ((io = (FileIO)this.fdMap.get(fd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return io.llseek(offset, result, whence);
    }

    private int access(Emulator<AndroidFileIO> emulator) {
        int ret;
        Backend backend = emulator.getBackend();
        UnidbgPointer pathname = UnidbgPointer.register(emulator, 66);
        int mode = backend.reg_read(67).intValue();
        if (pathname == null) {
            emulator.getMemory().setErrno(22);
            return -1;
        }
        String path = ((Pointer)pathname).getString(0L);
        if (log.isDebugEnabled()) {
            log.debug("access pathname=" + path + ", mode=" + mode);
        }
        if ((ret = this.faccessat(emulator, path)) == -1) {
            log.info("access pathname=" + path + ", mode=" + mode);
        }
        return ret;
    }

    private int execve(Emulator<?> emulator) {
        Pointer pointer;
        Object context = emulator.getContext();
        UnidbgPointer filename = context.getPointerArg(0);
        Pointer argv = context.getPointerArg(1);
        Pointer envp = context.getPointerArg(2);
        assert (filename != null);
        ArrayList<String> args = new ArrayList<String>();
        while ((pointer = ((Pointer)argv).getPointer(0L)) != null) {
            args.add(pointer.getString(0L));
            argv = argv.share(4L);
        }
        ArrayList<String> env = new ArrayList<String>();
        while ((pointer = ((Pointer)envp).getPointer(0L)) != null) {
            env.add(pointer.getString(0L));
            envp = envp.share(4L);
        }
        log.info("execve filename=" + ((Pointer)filename).getString(0L) + ", args=" + args + ", env=" + env);
        Log log = LogFactory.getLog(AbstractEmulator.class);
        if (log.isDebugEnabled()) {
            this.createBreaker(emulator).debug();
        }
        emulator.getMemory().setErrno(13);
        return -1;
    }

    private int personality(Backend backend) {
        long persona = (long)backend.reg_read(66).intValue() & 0xFFFFFFFFL;
        if (log.isDebugEnabled()) {
            log.debug("personality persona=0x" + Long.toHexString(persona));
        }
        int old = (int)this.persona;
        if (persona != 0xFFFFFFFFL) {
            this.persona = persona;
        }
        return old;
    }

    private int shutdown(Backend backend, Emulator<?> emulator) {
        FileIO io;
        int sockfd = backend.reg_read(66).intValue();
        int how = backend.reg_read(67).intValue();
        if (log.isDebugEnabled()) {
            log.debug("shutdown sockfd=" + sockfd + ", how=" + how);
        }
        if ((io = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return io.shutdown(how);
    }

    private int dup(Emulator<?> emulator) {
        AndroidFileIO _new;
        Backend backend = emulator.getBackend();
        int oldfd = backend.reg_read(66).intValue();
        FileIO io = (FileIO)this.fdMap.get(oldfd);
        if (io == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug("dup oldfd=" + oldfd + ", io=" + io);
        }
        if ((_new = (AndroidFileIO)io.dup2()) == null) {
            throw new UnsupportedOperationException();
        }
        int newfd = this.getMinFd();
        this.fdMap.put(newfd, _new);
        return newfd;
    }

    private int stat64(Emulator<AndroidFileIO> emulator) {
        UnidbgPointer pathname = UnidbgPointer.register(emulator, 66);
        UnidbgPointer statbuf = UnidbgPointer.register(emulator, 67);
        String path = FilenameUtils.normalize(((Pointer)pathname).getString(0L), true);
        if (log.isDebugEnabled()) {
            log.debug("stat64 pathname=" + path + ", statbuf=" + statbuf);
        }
        return this.stat64(emulator, path, statbuf);
    }

    private int lstat(Emulator<AndroidFileIO> emulator) {
        UnidbgPointer pathname = UnidbgPointer.register(emulator, 66);
        UnidbgPointer statbuf = UnidbgPointer.register(emulator, 67);
        String path = FilenameUtils.normalize(((Pointer)pathname).getString(0L), true);
        if (log.isDebugEnabled()) {
            log.debug("lstat pathname=" + path + ", statbuf=" + statbuf);
        }
        return this.stat64(emulator, path, statbuf);
    }

    protected int stat64(Emulator<AndroidFileIO> emulator, String pathname, Pointer statbuf) {
        FileResult<AndroidFileIO> result = this.resolve(emulator, pathname, 0);
        if (result != null && result.isSuccess()) {
            return ((AndroidFileIO)result.io).fstat(emulator, new Stat32(statbuf));
        }
        log.info("stat64 pathname=" + pathname + ", LR=" + emulator.getContext().getLRPointer());
        emulator.getMemory().setErrno(result != null ? result.errno : 2);
        return -1;
    }

    private int newselect(Backend backend, Emulator<?> emulator) {
        int count;
        int nfds = backend.reg_read(66).intValue();
        UnidbgPointer readfds = UnidbgPointer.register(emulator, 67);
        UnidbgPointer writefds = UnidbgPointer.register(emulator, 68);
        UnidbgPointer exceptfds = UnidbgPointer.register(emulator, 69);
        UnidbgPointer timeout = UnidbgPointer.register(emulator, 70);
        int size = (nfds - 1) / 8 + 1;
        if (log.isDebugEnabled()) {
            byte[] data2;
            log.debug("newselect nfds=" + nfds + ", readfds=" + readfds + ", writefds=" + writefds + ", exceptfds=" + exceptfds + ", timeout=" + timeout);
            if (readfds != null) {
                data2 = ((Pointer)readfds).getByteArray(0L, size);
                Inspector.inspect(data2, "readfds");
            }
            if (writefds != null) {
                data2 = ((Pointer)writefds).getByteArray(0L, size);
                Inspector.inspect(data2, "writefds");
            }
        }
        if (exceptfds != null) {
            emulator.getMemory().setErrno(12);
            return -1;
        }
        if (writefds != null && (count = this.select(nfds, writefds, readfds, false)) > 0) {
            return count;
        }
        if (readfds != null) {
            count = this.select(nfds, readfds, writefds, true);
            if (count == 0) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
            return count;
        }
        throw new AbstractMethodError("newselect nfds=" + nfds + ", readfds=null, writefds=" + writefds + ", exceptfds=null, timeout=" + timeout);
    }

    protected int pselect6(Emulator<?> emulator) {
        int count;
        Arm32RegisterContext context = (Arm32RegisterContext)emulator.getContext();
        int nfds = context.getIntArg(0);
        UnidbgPointer readfds = context.getPointerArg(1);
        UnidbgPointer writefds = context.getPointerArg(2);
        UnidbgPointer exceptfds = context.getPointerArg(3);
        UnidbgPointer timeout = context.getR4Pointer();
        int size = (nfds - 1) / 8 + 1;
        if (log.isDebugEnabled()) {
            byte[] data2;
            log.debug("pselect6 nfds=" + nfds + ", readfds=" + readfds + ", writefds=" + writefds + ", exceptfds=" + exceptfds + ", timeout=" + timeout + ", LR=" + context.getLRPointer());
            if (readfds != null) {
                data2 = ((Pointer)readfds).getByteArray(0L, size);
                Inspector.inspect(data2, "readfds");
            }
            if (writefds != null) {
                data2 = ((Pointer)writefds).getByteArray(0L, size);
                Inspector.inspect(data2, "writefds");
            }
        }
        if (exceptfds != null) {
            emulator.getMemory().setErrno(12);
            return -1;
        }
        if (writefds != null && (count = this.select(nfds, writefds, readfds, false)) > 0) {
            return count;
        }
        if (readfds != null) {
            count = this.select(nfds, readfds, writefds, true);
            if (count == 0) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
            return count;
        }
        throw new AbstractMethodError("pselect6 nfds=" + nfds + ", readfds=null, writefds=" + writefds + ", exceptfds=null, timeout=" + timeout + ", LR=" + context.getLRPointer());
    }

    private int getpeername(Backend backend, Emulator<?> emulator) {
        FileIO io;
        int sockfd = backend.reg_read(66).intValue();
        UnidbgPointer addr = UnidbgPointer.register(emulator, 67);
        UnidbgPointer addrlen = UnidbgPointer.register(emulator, 68);
        if (log.isDebugEnabled()) {
            log.debug("getpeername sockfd=" + sockfd + ", addr=" + addr + ", addrlen=" + addrlen);
        }
        if ((io = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return io.getpeername(addr, addrlen);
    }

    private int poll(Backend backend, Emulator<?> emulator) {
        UnidbgPointer fds = UnidbgPointer.register(emulator, 66);
        int nfds = backend.reg_read(67).intValue();
        int timeout = backend.reg_read(68).intValue();
        int count = 0;
        for (int i = 0; i < nfds; ++i) {
            Pointer pollfd = fds.share((long)i * 8L);
            int fd = pollfd.getInt(0L);
            short events = pollfd.getShort(4L);
            if (log.isDebugEnabled()) {
                log.debug("poll fds=" + fds + ", nfds=" + nfds + ", timeout=" + timeout + ", fd=" + fd + ", events=" + events);
            }
            if (fd < 0) {
                pollfd.setShort(6L, (short)0);
                continue;
            }
            short revents = 0;
            if ((events & 4) != 0) {
                revents = 4;
            } else if ((events & 1) != 0) {
                revents = 1;
            }
            pollfd.setShort(6L, revents);
            ++count;
        }
        return count;
    }

    private int umask(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        int mask = backend.reg_read(66).intValue();
        if (log.isDebugEnabled()) {
            log.debug("umask mask=0x" + Long.toHexString(mask));
        }
        int old = this.mask;
        this.mask = mask;
        return old;
    }

    private int setresuid32(Backend backend) {
        int ruid = backend.reg_read(66).intValue();
        int euid = backend.reg_read(67).intValue();
        int suid = backend.reg_read(68).intValue();
        if (log.isDebugEnabled()) {
            log.debug("setresuid32 ruid=" + ruid + ", euid=" + euid + ", suid=" + suid);
        }
        return 0;
    }

    private int setgid32(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int gid = context.getIntArg(0);
        if (log.isDebugEnabled()) {
            log.debug("setgid32 gid=" + gid);
        }
        return 0;
    }

    private int setresgid32(Backend backend) {
        int rgid = backend.reg_read(66).intValue();
        int egid = backend.reg_read(67).intValue();
        int sgid = backend.reg_read(68).intValue();
        if (log.isDebugEnabled()) {
            log.debug("setresgid32 rgid=" + rgid + ", egid=" + egid + ", sgid=" + sgid);
        }
        return 0;
    }

    private int mkdir(Emulator<?> emulator) {
        Object context = emulator.getContext();
        UnidbgPointer pathname = context.getPointerArg(0);
        int mode = context.getIntArg(1);
        if (log.isDebugEnabled()) {
            log.debug("mkdir pathname=" + ((Pointer)pathname).getString(0L) + ", mode=" + mode);
        }
        emulator.getMemory().setErrno(13);
        return -1;
    }

    private int syslog(Backend backend, Emulator<?> emulator) {
        int type = backend.reg_read(66).intValue();
        UnidbgPointer bufp = UnidbgPointer.register(emulator, 67);
        int len = backend.reg_read(68).intValue();
        if (log.isDebugEnabled()) {
            log.debug("syslog type=" + type + ", bufp=" + bufp + ", len=" + len);
        }
        throw new UnsupportedOperationException();
    }

    private int sigprocmask(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int how = context.getIntArg(0);
        UnidbgPointer set = context.getPointerArg(1);
        UnidbgPointer oldset = context.getPointerArg(2);
        return this.sigprocmask(emulator, how, set, oldset);
    }

    private int lgetxattr(Backend backend, Emulator<?> emulator) {
        UnidbgPointer path = UnidbgPointer.register(emulator, 66);
        UnidbgPointer name = UnidbgPointer.register(emulator, 67);
        UnidbgPointer value = UnidbgPointer.register(emulator, 68);
        int size = backend.reg_read(69).intValue();
        if (log.isDebugEnabled()) {
            log.debug("lgetxattr path=" + ((Pointer)path).getString(0L) + ", name=" + ((Pointer)name).getString(0L) + ", value=" + value + ", size=" + size);
        }
        throw new UnsupportedOperationException();
    }

    private int reboot(Backend backend, Emulator<?> emulator) {
        int magic = backend.reg_read(66).intValue();
        int magic2 = backend.reg_read(67).intValue();
        int cmd = backend.reg_read(68).intValue();
        UnidbgPointer arg = UnidbgPointer.register(emulator, 69);
        if (log.isDebugEnabled()) {
            log.debug("reboot magic=" + magic + ", magic2=" + magic2 + ", cmd=" + cmd + ", arg=" + arg);
        }
        emulator.getMemory().setErrno(1);
        return -1;
    }

    private int setitimer(Emulator<?> emulator) {
        Arm32RegisterContext context = (Arm32RegisterContext)emulator.getContext();
        int which = context.getR0Int();
        UnidbgPointer new_value = context.getR1Pointer();
        UnidbgPointer old_value = context.getR2Pointer();
        if (log.isDebugEnabled()) {
            log.debug("setitimer which=" + which + ", new_value=" + new_value + ", old_value=" + old_value);
        }
        return 0;
    }

    private int sigaction(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int signum = context.getIntArg(0);
        UnidbgPointer act = context.getPointerArg(1);
        UnidbgPointer oldact = context.getPointerArg(2);
        return this.sigaction(emulator, signum, act, oldact);
    }

    private int recvfrom(Emulator<?> emulator) {
        FileIO file;
        Backend backend = emulator.getBackend();
        int sockfd = backend.reg_read(66).intValue();
        UnidbgPointer buf = UnidbgPointer.register(emulator, 67);
        int len = backend.reg_read(68).intValue();
        int flags = backend.reg_read(69).intValue();
        UnidbgPointer src_addr = UnidbgPointer.register(emulator, 70);
        UnidbgPointer addrlen = UnidbgPointer.register(emulator, 71);
        if (log.isDebugEnabled()) {
            log.debug("recvfrom sockfd=" + sockfd + ", buf=" + buf + ", flags=" + flags + ", src_addr=" + src_addr + ", addrlen=" + addrlen);
        }
        if ((file = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.recvfrom(backend, buf, len, flags, src_addr, addrlen);
    }

    private int sendto(Backend backend, Emulator<?> emulator) {
        int sockfd = backend.reg_read(66).intValue();
        UnidbgPointer buf = UnidbgPointer.register(emulator, 67);
        int len = backend.reg_read(68).intValue();
        int flags = backend.reg_read(69).intValue();
        UnidbgPointer dest_addr = UnidbgPointer.register(emulator, 70);
        int addrlen = backend.reg_read(71).intValue();
        return this.sendto(emulator, sockfd, buf, len, flags, dest_addr, addrlen);
    }

    private int connect(Backend backend, Emulator<?> emulator) {
        int sockfd = backend.reg_read(66).intValue();
        UnidbgPointer addr = UnidbgPointer.register(emulator, 67);
        int addrlen = backend.reg_read(68).intValue();
        return this.connect(emulator, sockfd, addr, addrlen);
    }

    private int accept(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        UnidbgPointer addr = context.getPointerArg(1);
        UnidbgPointer addrlen = context.getPointerArg(2);
        return this.accept(emulator, sockfd, addr, addrlen, 0);
    }

    private int accept4(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        UnidbgPointer addr = context.getPointerArg(1);
        UnidbgPointer addrlen = context.getPointerArg(2);
        int flags = context.getIntArg(3);
        return this.accept(emulator, sockfd, addr, addrlen, flags);
    }

    protected final int accept(Emulator<AndroidFileIO> emulator, int sockfd, Pointer addr, Pointer addrlen, int flags) {
        AndroidFileIO file;
        if (log.isDebugEnabled()) {
            log.debug("accept sockfd=" + sockfd + ", addr=" + addr + ", addrlen=" + addrlen + ", flags=" + flags);
        }
        if ((file = (AndroidFileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        AndroidFileIO newIO = file.accept(addr, addrlen);
        if (newIO == null) {
            return -1;
        }
        int fd = this.getMinFd();
        this.fdMap.put(fd, newIO);
        return fd;
    }

    private int listen(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        int backlog = context.getIntArg(1);
        return this.listen(emulator, sockfd, backlog);
    }

    private int bind(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        UnidbgPointer addr = context.getPointerArg(1);
        int addrlen = context.getIntArg(2);
        return this.bind(emulator, sockfd, addr, addrlen);
    }

    private int getsockname(Backend backend, Emulator<?> emulator) {
        FileIO file;
        int sockfd = backend.reg_read(66).intValue();
        UnidbgPointer addr = UnidbgPointer.register(emulator, 67);
        UnidbgPointer addrlen = UnidbgPointer.register(emulator, 68);
        if (log.isDebugEnabled()) {
            log.debug("getsockname sockfd=" + sockfd + ", addr=" + addr + ", addrlen=" + addrlen);
        }
        if ((file = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.getsockname(addr, addrlen);
    }

    private int getsockopt(Backend backend, Emulator<?> emulator) {
        FileIO file;
        int sockfd = backend.reg_read(66).intValue();
        int level = backend.reg_read(67).intValue();
        int optname = backend.reg_read(68).intValue();
        UnidbgPointer optval = UnidbgPointer.register(emulator, 69);
        UnidbgPointer optlen = UnidbgPointer.register(emulator, 70);
        if (log.isDebugEnabled()) {
            log.debug("getsockopt sockfd=" + sockfd + ", level=" + level + ", optname=" + optname + ", optval=" + optval + ", optlen=" + optlen + ", from=" + UnidbgPointer.register(emulator, 10));
        }
        if ((file = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.getsockopt(level, optname, optval, optlen);
    }

    private int setsockopt(Backend backend, Emulator<?> emulator) {
        FileIO file;
        int sockfd = backend.reg_read(66).intValue();
        int level = backend.reg_read(67).intValue();
        int optname = backend.reg_read(68).intValue();
        UnidbgPointer optval = UnidbgPointer.register(emulator, 69);
        int optlen = backend.reg_read(70).intValue();
        if (log.isDebugEnabled()) {
            log.debug("setsockopt sockfd=" + sockfd + ", level=" + level + ", optname=" + optname + ", optval=" + optval + ", optlen=" + optlen);
        }
        if ((file = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.setsockopt(level, optname, optval, optlen);
    }

    @Override
    public void addIOResolver(IOResolver<AndroidFileIO> resolver) {
        super.addIOResolver(resolver);
        if (resolver instanceof AndroidResolver) {
            this.sdk = ((AndroidResolver)resolver).getSdk();
        }
    }

    protected AndroidFileIO createLocalSocketIO(Emulator<?> emulator, int sdk) {
        return new LocalSocketIO(emulator, sdk);
    }

    private int socket(Backend backend, Emulator<?> emulator) {
        int domain = backend.reg_read(66).intValue();
        int type = backend.reg_read(67).intValue() & 0x7FFFF;
        int protocol = backend.reg_read(68).intValue();
        if (log.isDebugEnabled()) {
            log.debug("socket domain=" + domain + ", type=" + type + ", protocol=" + protocol);
        }
        if (protocol == 1) {
            throw new UnsupportedOperationException();
        }
        switch (domain) {
            case 0: {
                throw new UnsupportedOperationException();
            }
            case 1: {
                switch (type) {
                    case 1: {
                        int fd = this.getMinFd();
                        this.fdMap.put(fd, this.createLocalSocketIO(emulator, this.sdk));
                        return fd;
                    }
                    case 2: {
                        int fd = this.getMinFd();
                        this.fdMap.put(fd, new LocalAndroidUdpSocket(emulator));
                        return fd;
                    }
                }
                emulator.getMemory().setErrno(13);
                return -1;
            }
            case 2: 
            case 10: {
                switch (type) {
                    case 1: {
                        int fd = this.getMinFd();
                        this.fdMap.put(fd, new TcpSocket(emulator));
                        return fd;
                    }
                    case 2: {
                        int fd = this.getMinFd();
                        this.fdMap.put(fd, new UdpSocket(emulator));
                        return fd;
                    }
                    case 3: {
                        throw new UnsupportedOperationException();
                    }
                }
                break;
            }
            case 16: {
                switch (type) {
                    case 2: {
                        int fd = this.getMinFd();
                        this.fdMap.put(fd, new NetLinkSocket(emulator));
                        return fd;
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        log.info("socket domain=" + domain + ", type=" + type + ", protocol=" + protocol);
        emulator.getMemory().setErrno(97);
        return -1;
    }

    private int getgroups(Backend backend, Emulator<?> emulator) {
        int size = backend.reg_read(66).intValue();
        UnidbgPointer list = UnidbgPointer.register(emulator, 67);
        if (log.isDebugEnabled()) {
            log.debug("getgroups size=" + size + ", list=" + list);
        }
        return 0;
    }

    protected int uname(Emulator<?> emulator) {
        UnidbgPointer buf = UnidbgPointer.register(emulator, 66);
        if (log.isDebugEnabled()) {
            log.debug("uname buf=" + buf);
        }
        int SYS_NMLN = 65;
        Pointer sysname = buf.share(0L);
        sysname.setString(0L, "Linux");
        Pointer nodename = sysname.share(65L);
        nodename.setString(0L, "localhost");
        Pointer release = nodename.share(65L);
        release.setString(0L, "1.0.0-unidbg");
        Pointer version = release.share(65L);
        version.setString(0L, "#1 SMP PREEMPT Thu Apr 19 14:36:58 CST 2018");
        Pointer machine = version.share(65L);
        machine.setString(0L, "armv7l");
        Pointer domainname = machine.share(65L);
        domainname.setString(0L, "localdomain");
        return 0;
    }

    private void exit_group(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int status = context.getIntArg(0);
        if (log.isDebugEnabled()) {
            log.debug("exit with code: " + status, new Exception("exit_group status=" + status));
        } else {
            System.out.println("exit with code: " + status);
        }
        if (LogFactory.getLog(AbstractEmulator.class).isDebugEnabled()) {
            this.createBreaker(emulator).debug();
        }
        emulator.getBackend().emu_stop();
    }

    private int munmap(Backend backend, Emulator<?> emulator) {
        long timeInMillis = System.currentTimeMillis();
        long start = (long)backend.reg_read(66).intValue() & 0xFFFFFFFFL;
        int length = backend.reg_read(67).intValue();
        if (start % (long)emulator.getPageAlign() != 0L) {
            emulator.getMemory().setErrno(22);
            return -1;
        }
        emulator.getMemory().munmap(start, length);
        if (log.isDebugEnabled()) {
            log.debug("munmap start=0x" + Long.toHexString(start) + ", length=" + length + ", offset=" + (System.currentTimeMillis() - timeInMillis) + ", from=" + UnidbgPointer.register(emulator, 10));
        }
        return 0;
    }

    private int prctl(Backend backend, Emulator<?> emulator) {
        int option = backend.reg_read(66).intValue();
        long arg2 = (long)backend.reg_read(67).intValue() & 0xFFFFFFFFL;
        if (log.isDebugEnabled()) {
            log.debug("prctl option=0x" + Integer.toHexString(option) + ", arg2=0x" + Long.toHexString(arg2));
        }
        switch (option) {
            case 3: 
            case 4: {
                return 0;
            }
            case 15: {
                UnidbgPointer threadName = UnidbgPointer.register(emulator, 67);
                String name = ((Pointer)threadName).getString(0L);
                if (log.isDebugEnabled()) {
                    log.debug("prctl set thread name: " + name);
                }
                return 0;
            }
            case 16: {
                String name = Thread.currentThread().getName();
                if (name.length() > 15) {
                    name = name.substring(0, 15);
                }
                if (log.isDebugEnabled()) {
                    log.debug("prctl get thread name: " + name);
                }
                UnidbgPointer buffer = UnidbgPointer.register(emulator, 67);
                ((Pointer)buffer).setString(0L, name);
                return 0;
            }
            case 1398164801: {
                UnidbgPointer addr = UnidbgPointer.register(emulator, 68);
                int len = backend.reg_read(69).intValue();
                UnidbgPointer pointer = UnidbgPointer.register(emulator, 70);
                if (log.isDebugEnabled()) {
                    log.debug("prctl set vma addr=" + addr + ", len=" + len + ", pointer=" + pointer + ", name=" + ((Pointer)pointer).getString(0L));
                }
                return 0;
            }
            case 1499557217: {
                int pid = (int)arg2;
                if (log.isDebugEnabled()) {
                    log.debug("prctl set ptracer: " + pid);
                }
                return 0;
            }
        }
        throw new UnsupportedOperationException("option=" + option);
    }

    protected int clock_gettime(Backend backend, Emulator<?> emulator) {
        int clk_id = backend.reg_read(66).intValue();
        UnidbgPointer tp = UnidbgPointer.register(emulator, 67);
        long offset = clk_id == 0 ? System.currentTimeMillis() * 1000000L : System.nanoTime() - this.nanoTime;
        long tv_sec = offset / 1000000000L;
        long tv_nsec = offset % 1000000000L;
        System.out.println("clock_gettime clk_id=" + clk_id + ", tp=" + tp + ", offset=" + offset + ", tv_sec=" + tv_sec + ", tv_nsec=" + tv_nsec);
        switch (clk_id) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                ((Pointer)tp).setInt(0L, (int)tv_sec);
                ((Pointer)tp).setInt(4L, (int)tv_nsec);
                return 0;
            }
            case 3: {
                ((Pointer)tp).setInt(0L, 0);
                ((Pointer)tp).setInt(4L, 1);
                return 0;
            }
        }
        throw new UnsupportedOperationException("clk_id=" + clk_id);
    }

    private int fcntl(Backend backend, Emulator<?> emulator) {
        int fd = backend.reg_read(66).intValue();
        int cmd = backend.reg_read(67).intValue();
        int arg = backend.reg_read(68).intValue();
        return this.fcntl(emulator, fd, cmd, arg);
    }

    private int writev(Backend backend, Emulator<?> emulator) {
        FileIO file;
        int fd = backend.reg_read(66).intValue();
        UnidbgPointer iov = UnidbgPointer.register(emulator, 67);
        int iovcnt = backend.reg_read(68).intValue();
        if (log.isDebugEnabled()) {
            for (int i = 0; i < iovcnt; ++i) {
                Pointer iov_base = ((Pointer)iov).getPointer((long)i * 8L);
                int iov_len = ((Pointer)iov).getInt((long)i * 8L + 4L);
                byte[] data2 = iov_base.getByteArray(0L, iov_len);
                Inspector.inspect(data2, "writev fd=" + fd + ", iov=" + iov + ", iov_base=" + iov_base);
            }
        }
        if ((file = (FileIO)this.fdMap.get(fd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        int count = 0;
        for (int i = 0; i < iovcnt; ++i) {
            Pointer iov_base = ((Pointer)iov).getPointer((long)i * 8L);
            int iov_len = ((Pointer)iov).getInt((long)i * 8L + 4L);
            byte[] data3 = iov_base.getByteArray(0L, iov_len);
            count += file.write(data3);
        }
        return count;
    }

    private int brk(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        long address = (long)backend.reg_read(66).intValue() & 0xFFFFFFFFL;
        if (log.isDebugEnabled()) {
            log.debug("brk address=0x" + Long.toHexString(address));
        }
        return emulator.getMemory().brk(address);
    }

    private int mprotect(Backend backend, Emulator<?> emulator) {
        long address = (long)backend.reg_read(66).intValue() & 0xFFFFFFFFL;
        int length = backend.reg_read(67).intValue();
        int prot = backend.reg_read(68).intValue();
        long alignedAddress = address / 4096L * 4096L;
        long offset = address - alignedAddress;
        long alignedLength = ARM.alignSize((long)length + offset, emulator.getPageAlign());
        if (log.isDebugEnabled()) {
            log.debug("mprotect address=0x" + Long.toHexString(address) + ", alignedAddress=0x" + Long.toHexString(alignedAddress) + ", offset=" + offset + ", length=" + length + ", alignedLength=" + alignedLength + ", prot=0x" + Integer.toHexString(prot));
        }
        return emulator.getMemory().mprotect(alignedAddress, (int)alignedLength, prot);
    }

    private int mmap2(Backend backend, Emulator<?> emulator) {
        boolean warning;
        long start = (long)backend.reg_read(66).intValue() & 0xFFFFFFFFL;
        int length = backend.reg_read(67).intValue();
        int prot = backend.reg_read(68).intValue();
        int flags = backend.reg_read(69).intValue();
        int fd = backend.reg_read(70).intValue();
        int offset = backend.reg_read(71).intValue() << 12;
        boolean bl = warning = length >= 0x10000000;
        if (log.isDebugEnabled() || warning) {
            String msg = "mmap2 start=0x" + Long.toHexString(start) + ", length=" + length + ", prot=0x" + Integer.toHexString(prot) + ", flags=0x" + Integer.toHexString(flags) + ", fd=" + fd + ", offset=" + offset + ", from=" + UnidbgPointer.register(emulator, 10);
            if (warning) {
                log.warn(msg);
                if (log.isDebugEnabled()) {
                    emulator.attach().debug();
                }
            } else {
                log.debug(msg);
            }
        }
        return (int)emulator.getMemory().mmap2(start, length, prot, flags, fd, offset);
    }

    private int gettimeofday(Emulator<?> emulator) {
        UnidbgPointer tv = UnidbgPointer.register(emulator, 66);
        UnidbgPointer tz = UnidbgPointer.register(emulator, 67);
        return this.gettimeofday(emulator, tv, tz);
    }

    private int faccessat(Backend backend, Emulator<AndroidFileIO> emulator) {
        int ret;
        int dirfd = backend.reg_read(66).intValue();
        UnidbgPointer pathname_p = UnidbgPointer.register(emulator, 67);
        int oflags = backend.reg_read(68).intValue();
        int mode = backend.reg_read(69).intValue();
        String pathname = ((Pointer)pathname_p).getString(0L);
        String msg = "faccessat dirfd=" + dirfd + ", pathname=" + pathname + ", oflags=0x" + Integer.toHexString(oflags) + ", mode=0x" + Integer.toHexString(mode);
        if (log.isDebugEnabled()) {
            log.debug(msg);
        }
        if ((ret = this.faccessat(emulator, pathname)) == -1) {
            log.info(msg);
        }
        return ret;
    }

    private int faccessat(Emulator<AndroidFileIO> emulator, String pathname) {
        FileResult<AndroidFileIO> result = this.resolve(emulator, pathname, 0);
        if (result != null && result.isSuccess()) {
            return 0;
        }
        emulator.getMemory().setErrno(result != null ? result.errno : 13);
        return -1;
    }

    private int fstatat64(Backend backend, Emulator<AndroidFileIO> emulator) {
        int dirfd = backend.reg_read(66).intValue();
        UnidbgPointer pathname = UnidbgPointer.register(emulator, 67);
        UnidbgPointer statbuf = UnidbgPointer.register(emulator, 68);
        int flags = backend.reg_read(69).intValue();
        String path = FilenameUtils.normalize(((Pointer)pathname).getString(0L), true);
        if (log.isDebugEnabled()) {
            log.debug("fstatat64 dirfd=" + dirfd + ", pathname=" + path + ", statbuf=" + statbuf + ", flags=" + flags);
        }
        if (dirfd != -100 && !path.startsWith("/")) {
            throw new BackendException();
        }
        return this.stat64(emulator, path, statbuf);
    }

    private int openat(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int dirfd = context.getIntArg(0);
        UnidbgPointer pathname_p = context.getPointerArg(1);
        int oflags = context.getIntArg(2);
        int mode = context.getIntArg(3);
        String pathname = ((Pointer)pathname_p).getString(0L);
        String msg = "openat dirfd=" + dirfd + ", pathname=" + pathname + ", oflags=0x" + Integer.toHexString(oflags) + ", mode=" + Integer.toHexString(mode);
        if (log.isDebugEnabled()) {
            log.debug(msg);
        }
        if ("/data/misc/zoneinfo/current/tzdata".equals(pathname = FilenameUtils.normalize(pathname, true)) || "/dev/pmsg0".equals(pathname)) {
            emulator.getMemory().setErrno(2);
            return -2;
        }
        if (pathname.startsWith("/")) {
            int fd = this.open(emulator, pathname, oflags);
            if (fd == -1) {
                log.info(msg);
                return -emulator.getMemory().getLastErrno();
            }
            return fd;
        }
        if (dirfd != -100) {
            throw new BackendException();
        }
        int fd = this.open(emulator, pathname, oflags);
        if (fd == -1) {
            log.info(msg);
            return -emulator.getMemory().getLastErrno();
        }
        return fd;
    }

    private int open(Emulator<AndroidFileIO> emulator) {
        int fd;
        Object context = emulator.getContext();
        UnidbgPointer pathname_p = context.getPointerArg(0);
        int oflags = context.getIntArg(1);
        int mode = context.getIntArg(2);
        String pathname = ((Pointer)pathname_p).getString(0L);
        String msg = "open pathname=" + pathname + ", oflags=0x" + Integer.toHexString(oflags) + ", mode=" + Integer.toHexString(mode) + ", from=" + UnidbgPointer.register(emulator, 10);
        if (log.isDebugEnabled()) {
            log.debug(msg);
        }
        if ((fd = this.open(emulator, pathname, oflags)) == -1) {
            log.info(msg);
            return -emulator.getMemory().getLastErrno();
        }
        return fd;
    }

    private int ftruncate(Backend backend) {
        FileIO file;
        int fd = backend.reg_read(66).intValue();
        int length = backend.reg_read(67).intValue();
        if (log.isDebugEnabled()) {
            log.debug("ftruncate fd=" + fd + ", length=" + length);
        }
        if ((file = (FileIO)this.fdMap.get(fd)) == null) {
            throw new UnsupportedOperationException();
        }
        return file.ftruncate(length);
    }

    private int lseek(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        int fd = backend.reg_read(66).intValue();
        int offset = backend.reg_read(67).intValue();
        int whence = backend.reg_read(68).intValue();
        FileIO file = (FileIO)this.fdMap.get(fd);
        if (file == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        int pos = file.lseek(offset, whence);
        if (log.isDebugEnabled()) {
            log.debug("lseek fd=" + fd + ", offset=" + offset + ", whence=" + whence + ", pos=" + pos + ", from=" + UnidbgPointer.register(emulator, 10));
        }
        return pos;
    }

    private int close(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        int fd = backend.reg_read(66).intValue();
        if (log.isDebugEnabled()) {
            log.debug("close fd=" + fd);
        }
        return this.close(emulator, fd);
    }

    private int getdents64(Emulator<AndroidFileIO> emulator) {
        AndroidFileIO io;
        Object context = emulator.getContext();
        int fd = context.getIntArg(0);
        UnidbgPointer dirp = context.getPointerArg(1);
        int size = context.getIntArg(2);
        if (log.isDebugEnabled()) {
            log.debug("getdents64 fd=" + fd + ", dirp=" + dirp + ", size=" + size);
        }
        if ((io = (AndroidFileIO)this.fdMap.get(fd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        dirp.setSize(size);
        return io.getdents64(dirp, size);
    }

    private int fstat(Backend backend, Emulator<?> emulator) {
        int fd = backend.reg_read(66).intValue();
        UnidbgPointer stat = UnidbgPointer.register(emulator, 67);
        return this.fstat(emulator, fd, stat);
    }

    protected int fstat(Emulator<?> emulator, int fd, Pointer stat) {
        AndroidFileIO file = (AndroidFileIO)this.fdMap.get(fd);
        if (file == null) {
            if (log.isDebugEnabled()) {
                log.debug("fstat fd=" + fd + ", stat=" + stat + ", errno=" + 9);
            }
            emulator.getMemory().setErrno(9);
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug("fstat file=" + file + ", stat=" + stat + ", from=" + emulator.getContext().getLRPointer());
        }
        return file.fstat(emulator, new Stat32(stat));
    }

    private int ioctl(Emulator<?> emulator) {
        FileIO file;
        Backend backend = emulator.getBackend();
        int fd = backend.reg_read(66).intValue();
        long request = (long)backend.reg_read(67).intValue() & 0xFFFFFFFFL;
        long argp = (long)backend.reg_read(68).intValue() & 0xFFFFFFFFL;
        if (log.isDebugEnabled()) {
            log.debug("ioctl fd=" + fd + ", request=0x" + Long.toHexString(request) + ", argp=0x" + Long.toHexString(argp));
        }
        if ((file = (FileIO)this.fdMap.get(fd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        int ret = file.ioctl(emulator, request, argp);
        if (ret == -1) {
            emulator.getMemory().setErrno(25);
        }
        return ret;
    }

    private int write(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        int fd = backend.reg_read(66).intValue();
        UnidbgPointer buffer = UnidbgPointer.register(emulator, 67);
        int count = backend.reg_read(68).intValue();
        return this.write(emulator, fd, buffer, count);
    }

    private int read(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        int fd = backend.reg_read(66).intValue();
        UnidbgPointer buffer = UnidbgPointer.register(emulator, 67);
        int count = backend.reg_read(68).intValue();
        return this.read(emulator, fd, buffer, count);
    }

    private int pread64(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int fd = context.getIntArg(0);
        UnidbgPointer buffer = context.getPointerArg(1);
        int count = context.getIntArg(2);
        long offset = (long)context.getIntByReg(70) | (long)context.getIntByReg(71) << 32;
        return this.pread(emulator, fd, buffer, count, offset);
    }

    private int dup2(Backend backend, Emulator<?> emulator) {
        FileIO old;
        int oldfd = backend.reg_read(66).intValue();
        int newfd = backend.reg_read(67).intValue();
        if (log.isDebugEnabled()) {
            log.debug("dup2 oldfd=" + oldfd + ", newfd=" + newfd);
        }
        if ((old = (FileIO)this.fdMap.get(oldfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        if (oldfd == newfd) {
            return newfd;
        }
        AndroidFileIO _new = (AndroidFileIO)this.fdMap.remove(newfd);
        if (_new != null) {
            _new.close();
        }
        _new = (AndroidFileIO)old.dup2();
        this.fdMap.put(newfd, _new);
        return newfd;
    }

    private int dup3(Emulator<?> emulator) {
        FileIO old;
        Object context = emulator.getContext();
        int oldfd = context.getIntArg(0);
        int newfd = context.getIntArg(1);
        int flags = context.getIntArg(2);
        if (log.isDebugEnabled()) {
            log.debug("dup3 oldfd=" + oldfd + ", newfd=" + newfd + ", flags=0x" + Integer.toHexString(flags));
        }
        if ((old = (FileIO)this.fdMap.get(oldfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        if (oldfd == newfd) {
            return newfd;
        }
        AndroidFileIO _new = (AndroidFileIO)this.fdMap.remove(newfd);
        if (_new != null) {
            _new.close();
        }
        _new = (AndroidFileIO)old.dup2();
        this.fdMap.put(newfd, _new);
        return newfd;
    }

    @Override
    protected AndroidFileIO createByteArrayFileIO(String pathname, int oflags, byte[] data2) {
        return new ByteArrayFileIO(oflags, pathname, data2);
    }

    @Override
    protected AndroidFileIO createDriverFileIO(Emulator<?> emulator, int oflags, String pathname) {
        return DriverFileIO.create(emulator, oflags, pathname);
    }
}

