/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux;

import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.LongJumpException;
import com.github.unidbg.StopEmulatorException;
import com.github.unidbg.Svc;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.context.Arm64RegisterContext;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.file.FileResult;
import com.github.unidbg.file.IOResolver;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.linux.AndroidSyscallHandler;
import com.github.unidbg.linux.android.AndroidResolver;
import com.github.unidbg.linux.file.ByteArrayFileIO;
import com.github.unidbg.linux.file.DriverFileIO;
import com.github.unidbg.linux.file.LocalAndroidUdpSocket;
import com.github.unidbg.linux.file.LocalSocketIO;
import com.github.unidbg.linux.file.NetLinkSocket;
import com.github.unidbg.linux.file.TcpSocket;
import com.github.unidbg.linux.file.UdpSocket;
import com.github.unidbg.linux.struct.RLimit64;
import com.github.unidbg.linux.struct.Stat64;
import com.github.unidbg.linux.thread.MarshmallowThread;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.thread.PopContextException;
import com.github.unidbg.thread.Task;
import com.github.unidbg.thread.ThreadContextSwitchException;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ARM64SyscallHandler
extends AndroidSyscallHandler {
    private static final Log log = LogFactory.getLog(ARM64SyscallHandler.class);
    private final SvcMemory svcMemory;
    private static final int RLIMIT_STACK = 3;
    private static final int CLONE_VM = 256;
    private static final int CLONE_FS = 512;
    private static final int CLONE_FILES = 1024;
    private static final int CLONE_SIGHAND = 2048;
    private static final int CLONE_PTRACE = 8192;
    private static final int CLONE_VFORK = 16384;
    private static final int CLONE_PARENT = 32768;
    private static final int CLONE_THREAD = 65536;
    private static final int CLONE_NEWNS = 131072;
    private static final int CLONE_SYSVSEM = 262144;
    private static final int CLONE_SETTLS = 524288;
    private static final int CLONE_PARENT_SETTID = 0x100000;
    private static final int CLONE_CHILD_CLEARTID = 0x200000;
    private static final int CLONE_DETACHED = 0x400000;
    private static final int CLONE_UNTRACED = 0x800000;
    private static final int CLONE_CHILD_SETTID = 0x1000000;
    private static final int CLONE_STOPPED = 0x2000000;
    private static final short POLLIN = 1;
    private static final short POLLOUT = 4;
    private int sdk;
    private static final int PR_SET_NAME = 15;
    private static final int PR_SET_NO_NEW_PRIVS = 38;
    private static final int PR_SET_THP_DISABLE = 41;
    private static final int BIONIC_PR_SET_VMA = 1398164801;
    private static final int PR_SET_PTRACER = 1499557217;
    private static final int CLOCK_REALTIME = 0;
    private static final int CLOCK_MONOTONIC = 1;
    private static final int CLOCK_MONOTONIC_RAW = 4;
    private static final int CLOCK_MONOTONIC_COARSE = 6;
    private static final int CLOCK_BOOTTIME = 7;
    private final long nanoTime = System.nanoTime();
    private static final int MMAP2_SHIFT = 12;

    public ARM64SyscallHandler(SvcMemory svcMemory) {
        this.svcMemory = svcMemory;
    }

    @Override
    public void hook(Backend backend, int intno, int swi, Object user) {
        Emulator emulator = (Emulator)user;
        UnidbgPointer pc = UnidbgPointer.register(emulator, 260);
        if (intno == 7) {
            this.createBreaker(emulator).brk(pc, pc == null ? swi : pc.getInt(0L) >> 5 & 0xFFFF);
            return;
        }
        if (intno == 1) {
            this.createBreaker(emulator).debug();
            return;
        }
        if (intno != 2) {
            throw new BackendException("intno=" + intno);
        }
        int NR = backend.reg_read(207).intValue();
        String syscall = null;
        Throwable exception = null;
        try {
            if (swi == 0 && NR == 0 && backend.reg_read(215).intValue() == 34952) {
                int number = backend.reg_read(211).intValue();
                Svc svc = this.svcMemory.getSvc(number);
                if (svc != null) {
                    svc.handlePostCallback(emulator);
                    return;
                }
                backend.emu_stop();
                throw new IllegalStateException("svc number: " + swi);
            }
            if (swi == 0 && NR == 0 && backend.reg_read(215).intValue() == 34918) {
                int number = backend.reg_read(211).intValue();
                Svc svc = this.svcMemory.getSvc(number);
                if (svc != null) {
                    svc.handlePreCallback(emulator);
                    return;
                }
                backend.emu_stop();
                throw new IllegalStateException("svc number: " + swi);
            }
            if (swi != 0) {
                if (swi == 65535) {
                    throw new PopContextException();
                }
                if (swi == 65534) {
                    throw new ThreadContextSwitchException();
                }
                Svc svc = this.svcMemory.getSvc(swi);
                if (svc != null) {
                    backend.reg_write(199, svc.handle(emulator));
                    return;
                }
                backend.emu_stop();
                throw new BackendException("svc number: " + swi);
            }
            if (log.isTraceEnabled()) {
                ARM.showRegs64(emulator, null);
            }
            if (this.handleSyscall(emulator, NR)) {
                return;
            }
            switch (NR) {
                case 17: {
                    backend.reg_write(199, this.getcwd(emulator));
                    return;
                }
                case 19: {
                    backend.reg_write(199, this.eventfd2(emulator));
                    return;
                }
                case 64: {
                    backend.reg_write(199, this.write(emulator));
                    return;
                }
                case 221: {
                    backend.reg_write(199, this.execve(emulator));
                    return;
                }
                case 62: {
                    backend.reg_write(199, this.lseek(emulator));
                    return;
                }
                case 172: {
                    backend.reg_write(199, emulator.getPid());
                    return;
                }
                case 178: {
                    Task task = (Task)emulator.get(Task.TASK_KEY);
                    backend.reg_write(199, task == null ? 0 : task.getId());
                    return;
                }
                case 129: {
                    backend.reg_write(199, this.kill(emulator));
                    return;
                }
                case 29: {
                    backend.reg_write(199, this.ioctl(emulator));
                    return;
                }
                case 34: {
                    backend.reg_write(199, this.mkdirat(emulator));
                    return;
                }
                case 35: {
                    backend.reg_write(199, this.unlinkat(emulator));
                    return;
                }
                case 38: {
                    backend.reg_write(199, this.renameat(emulator));
                    return;
                }
                case 47: {
                    backend.reg_write(199, this.fallocate(emulator));
                    return;
                }
                case 53: {
                    backend.reg_write(199, this.fchmodat(emulator));
                    return;
                }
                case 54: {
                    backend.reg_write(199, this.fchownat(emulator));
                    return;
                }
                case 56: {
                    backend.reg_write(199, this.openat(emulator));
                    return;
                }
                case 57: {
                    backend.reg_write(199, this.close(backend, emulator));
                    return;
                }
                case 59: {
                    backend.reg_write(199, this.pipe2(emulator));
                    return;
                }
                case 63: {
                    backend.reg_write(199, this.read(backend, emulator));
                    return;
                }
                case 24: {
                    backend.reg_write(199, this.dup3(emulator));
                    return;
                }
                case 43: {
                    Object context = emulator.getContext();
                    UnidbgPointer pathPointer = context.getPointerArg(0);
                    UnidbgPointer buf = context.getPointerArg(1);
                    String path = ((Pointer)pathPointer).getString(0L);
                    backend.reg_write(199, this.statfs64(emulator, path, buf));
                    return;
                }
                case 134: {
                    backend.reg_write(199, this.sigaction(emulator));
                    return;
                }
                case 72: {
                    backend.reg_write(199, this.pselect6(emulator));
                    return;
                }
                case 78: {
                    backend.reg_write(199, this.readlinkat(emulator));
                    return;
                }
                case 80: {
                    backend.reg_write(199, this.fstat(backend, emulator));
                    return;
                }
                case 83: {
                    backend.reg_write(199, this.fdatasync(emulator));
                    return;
                }
                case 96: {
                    backend.reg_write(199, this.set_tid_address(emulator));
                    return;
                }
                case 98: {
                    backend.reg_write(199, this.futex(emulator));
                    return;
                }
                case 220: {
                    backend.reg_write(199, this.clone(emulator));
                    return;
                }
                case 160: {
                    backend.reg_write(199, this.uname(emulator));
                    return;
                }
                case 132: {
                    backend.reg_write(199, this.sigaltstack(emulator));
                    return;
                }
                case 135: {
                    backend.reg_write(199, this.sigprocmask(emulator));
                    return;
                }
                case 32: {
                    backend.reg_write(199, this.flock(emulator));
                    return;
                }
                case 66: {
                    backend.reg_write(199, this.writev(emulator));
                    return;
                }
                case 101: {
                    backend.reg_write(199, this.nanosleep(emulator));
                    return;
                }
                case 119: {
                    backend.reg_write(199, this.sched_setscheduler(emulator));
                    return;
                }
                case 122: {
                    backend.reg_write(199, this.sched_setaffinity(emulator));
                    return;
                }
                case 123: {
                    backend.reg_write(199, this.sched_getaffinity(emulator));
                    return;
                }
                case 124: {
                    backend.reg_write(199, this.sched_yield(emulator));
                    return;
                }
                case 136: {
                    backend.reg_write(199, this.rt_sigpending(emulator));
                    return;
                }
                case 137: {
                    backend.reg_write(199, this.rt_sigtimedwait(emulator));
                    return;
                }
                case 138: {
                    backend.reg_write(199, this.rt_sigqueue(emulator));
                    return;
                }
                case 140: {
                    backend.reg_write(199, this.setpriority(emulator));
                    return;
                }
                case 167: {
                    backend.reg_write(199, this.prctl(emulator));
                    return;
                }
                case 169: {
                    backend.reg_write(199, this.gettimeofday(emulator));
                    return;
                }
                case 73: {
                    backend.reg_write(199, this.ppoll(emulator));
                    return;
                }
                case 173: {
                    backend.reg_write(199, this.getppid(emulator));
                    return;
                }
                case 174: 
                case 175: {
                    backend.reg_write(199, 0);
                    return;
                }
                case 200: {
                    backend.reg_write(199, this.bind(emulator));
                    return;
                }
                case 201: {
                    backend.reg_write(199, this.listen(emulator));
                    return;
                }
                case 214: {
                    backend.reg_write(199, this.brk(backend, emulator));
                    return;
                }
                case 215: {
                    backend.reg_write(199, this.munmap(backend, emulator));
                    return;
                }
                case 216: {
                    backend.reg_write(199, this.mremap(emulator));
                    return;
                }
                case 61: {
                    backend.reg_write(199, this.getdents64(emulator));
                    return;
                }
                case 233: {
                    syscall = "madvise";
                    backend.reg_write(199, 0);
                    return;
                }
                case 25: {
                    backend.reg_write(199, this.fcntl(emulator));
                    return;
                }
                case 222: {
                    backend.reg_write(199, this.mmap(backend, emulator));
                    return;
                }
                case 226: {
                    backend.reg_write(199, this.mprotect(backend, emulator));
                    return;
                }
                case 227: {
                    backend.reg_write(199, this.msync(emulator));
                    return;
                }
                case 93: {
                    this.exit(emulator);
                    return;
                }
                case 94: {
                    this.exit_group(emulator);
                    return;
                }
                case 113: {
                    backend.reg_write(199, this.clock_gettime(emulator));
                    return;
                }
                case 117: {
                    backend.reg_write(199, this.ptrace(emulator));
                    return;
                }
                case 120: {
                    backend.reg_write(199, this.sched_getscheduler(emulator));
                    return;
                }
                case 121: {
                    backend.reg_write(199, this.sched_getparam(emulator));
                    return;
                }
                case 131: {
                    backend.reg_write(199, this.tgkill(emulator));
                    return;
                }
                case 141: {
                    backend.reg_write(199, this.getpriority(emulator));
                    return;
                }
                case 163: {
                    backend.reg_write(199, this.getrlimit64(emulator));
                    return;
                }
                case 198: {
                    backend.reg_write(199, this.socket(emulator));
                    return;
                }
                case 203: {
                    backend.reg_write(199, this.connect(emulator));
                    return;
                }
                case 204: {
                    backend.reg_write(199, this.getsockname(emulator));
                    return;
                }
                case 242: {
                    backend.reg_write(199, this.accept4(emulator));
                    return;
                }
                case 205: {
                    backend.reg_write(199, this.getpeername(emulator));
                    return;
                }
                case 206: {
                    backend.reg_write(199, this.sendto(emulator));
                    return;
                }
                case 207: {
                    backend.reg_write(199, this.recvfrom(emulator));
                    return;
                }
                case 208: {
                    backend.reg_write(199, this.setsockopt(emulator));
                    return;
                }
                case 209: {
                    backend.reg_write(199, this.getsockopt(emulator));
                    return;
                }
                case 278: {
                    backend.reg_write(199, this.gerrandom(emulator));
                    return;
                }
                case 79: {
                    backend.reg_write(199, this.fstatat64(emulator));
                    return;
                }
                case 48: {
                    backend.reg_write(199, this.faccessat(emulator));
                    return;
                }
            }
        }
        catch (StopEmulatorException e) {
            backend.emu_stop();
            return;
        }
        catch (LongJumpException e) {
            backend.emu_stop();
            throw e;
        }
        catch (Throwable e) {
            backend.emu_stop();
            exception = e;
        }
        if (exception == null && this.handleUnknownSyscall(emulator, NR)) {
            return;
        }
        log.warn("handleInterrupt intno=" + intno + ", NR=" + NR + ", svcNumber=0x" + Integer.toHexString(swi) + ", PC=" + pc + ", LR=" + UnidbgPointer.register(emulator, 2) + ", syscall=" + syscall, exception);
        if (log.isDebugEnabled()) {
            emulator.attach().debug();
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
    }

    private long getrlimit64(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int resource = context.getIntArg(0);
        UnidbgPointer ptr = context.getPointerArg(1);
        if (resource == 3) {
            long size;
            RLimit64 rlimit64 = new RLimit64(ptr);
            rlimit64.rlim_cur = size = 256L * (long)emulator.getPageAlign();
            rlimit64.rlim_max = size;
            rlimit64.pack();
            return 0L;
        }
        throw new UnsupportedOperationException("getrlimit64 resource=" + resource + ", rlimit64=" + ptr);
    }

    private long msync(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        UnidbgPointer addr = context.getPointerArg(0);
        int len = context.getIntArg(1);
        int flags = context.getIntArg(2);
        if (log.isDebugEnabled()) {
            log.debug("msync addr=" + addr + ", len=" + len + ", flags=0x" + Integer.toHexString(flags));
        }
        return 0L;
    }

    private long fdatasync(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int fd = context.getIntArg(0);
        if (log.isDebugEnabled()) {
            log.debug("fdatasync fd=" + fd);
        }
        return 0L;
    }

    private long gerrandom(Emulator<?> emulator) {
        Object context = emulator.getContext();
        UnidbgPointer buf = context.getPointerArg(0);
        int bufSize = context.getIntArg(1);
        int flags = context.getIntArg(2);
        return this.getrandom(buf, bufSize, flags);
    }

    private long clone(Emulator<?> emulator) {
        Arm64RegisterContext context = (Arm64RegisterContext)emulator.getContext();
        UnidbgPointer child_stack = context.getPointerArg(1);
        if (child_stack == null && context.getPointerArg(2) == null) {
            return this.fork(emulator);
        }
        long fn = context.getXLong(5);
        long arg = context.getXLong(6);
        if (child_stack != null && ((Pointer)child_stack).getLong(0L) == fn && ((Pointer)child_stack).getLong(8L) == arg) {
            return this.bionic_clone(emulator);
        }
        return this.pthread_clone(emulator);
    }

    private int pthread_clone(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int flags = context.getIntArg(0);
        UnidbgPointer child_stack = context.getPointerArg(1);
        ArrayList<String> list = new ArrayList<String>();
        if ((flags & 0x100) != 0) {
            list.add("CLONE_VM");
        }
        if ((flags & 0x200) != 0) {
            list.add("CLONE_FS");
        }
        if ((flags & 0x400) != 0) {
            list.add("CLONE_FILES");
        }
        if ((flags & 0x800) != 0) {
            list.add("CLONE_SIGHAND");
        }
        if ((flags & 0x2000) != 0) {
            list.add("CLONE_PTRACE");
        }
        if ((flags & 0x4000) != 0) {
            list.add("CLONE_VFORK");
        }
        if ((flags & 0x8000) != 0) {
            list.add("CLONE_PARENT");
        }
        if ((flags & 0x10000) != 0) {
            list.add("CLONE_THREAD");
        }
        if ((flags & 0x20000) != 0) {
            list.add("CLONE_NEWNS");
        }
        if ((flags & 0x40000) != 0) {
            list.add("CLONE_SYSVSEM");
        }
        if ((flags & 0x80000) != 0) {
            list.add("CLONE_SETTLS");
        }
        if ((flags & 0x100000) != 0) {
            list.add("CLONE_PARENT_SETTID");
        }
        if ((flags & 0x200000) != 0) {
            list.add("CLONE_CHILD_CLEARTID");
        }
        if ((flags & 0x400000) != 0) {
            list.add("CLONE_DETACHED");
        }
        if ((flags & 0x800000) != 0) {
            list.add("CLONE_UNTRACED");
        }
        if ((flags & 0x1000000) != 0) {
            list.add("CLONE_CHILD_SETTID");
        }
        if ((flags & 0x2000000) != 0) {
            list.add("CLONE_STOPPED");
        }
        int threadId = this.incrementThreadId(emulator);
        UnidbgPointer fn = child_stack.getPointer(0L);
        child_stack = child_stack.share(8L, 0L);
        UnidbgPointer arg = child_stack.getPointer(0L);
        child_stack = child_stack.share(8L, 0L);
        if (this.threadDispatcherEnabled) {
            throw new UnsupportedOperationException();
        }
        log.info("pthread_clone child_stack=" + child_stack + ", thread_id=" + threadId + ", fn=" + fn + ", arg=" + arg + ", flags=" + list);
        Log log = LogFactory.getLog(AbstractEmulator.class);
        if (log.isDebugEnabled()) {
            emulator.attach().debug();
        }
        return threadId;
    }

    protected long fork(Emulator<?> emulator) {
        log.info("fork");
        emulator.getMemory().setErrno(38);
        return -1L;
    }

    private int bionic_clone(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int flags = context.getIntArg(0);
        UnidbgPointer child_stack = context.getPointerArg(1);
        UnidbgPointer pid = context.getPointerArg(2);
        UnidbgPointer tls = context.getPointerArg(3);
        UnidbgPointer ctid = context.getPointerArg(4);
        UnidbgPointer fn = context.getPointerArg(5);
        UnidbgPointer arg = context.getPointerArg(6);
        ArrayList<String> list = new ArrayList<String>();
        if ((flags & 0x100) != 0) {
            list.add("CLONE_VM");
        }
        if ((flags & 0x200) != 0) {
            list.add("CLONE_FS");
        }
        if ((flags & 0x400) != 0) {
            list.add("CLONE_FILES");
        }
        if ((flags & 0x800) != 0) {
            list.add("CLONE_SIGHAND");
        }
        if ((flags & 0x2000) != 0) {
            list.add("CLONE_PTRACE");
        }
        if ((flags & 0x4000) != 0) {
            list.add("CLONE_VFORK");
        }
        if ((flags & 0x8000) != 0) {
            list.add("CLONE_PARENT");
        }
        if ((flags & 0x10000) != 0) {
            list.add("CLONE_THREAD");
        }
        if ((flags & 0x20000) != 0) {
            list.add("CLONE_NEWNS");
        }
        if ((flags & 0x40000) != 0) {
            list.add("CLONE_SYSVSEM");
        }
        if ((flags & 0x80000) != 0) {
            list.add("CLONE_SETTLS");
        }
        if ((flags & 0x100000) != 0) {
            list.add("CLONE_PARENT_SETTID");
        }
        if ((flags & 0x200000) != 0) {
            list.add("CLONE_CHILD_CLEARTID");
        }
        if ((flags & 0x400000) != 0) {
            list.add("CLONE_DETACHED");
        }
        if ((flags & 0x800000) != 0) {
            list.add("CLONE_UNTRACED");
        }
        if ((flags & 0x1000000) != 0) {
            list.add("CLONE_CHILD_SETTID");
        }
        if ((flags & 0x2000000) != 0) {
            list.add("CLONE_STOPPED");
        }
        if (log.isDebugEnabled()) {
            log.debug("bionic_clone child_stack=" + child_stack + ", pid=" + pid + ", tls=" + tls + ", ctid=" + ctid + ", fn=" + fn + ", arg=" + arg + ", flags=" + list);
        }
        int threadId = this.incrementThreadId(emulator);
        if (this.threadDispatcherEnabled) {
            if (this.verbose) {
                System.out.printf("bionic_clone fn=%s%n", fn);
            }
            emulator.getThreadDispatcher().addThread(new MarshmallowThread(emulator, fn, arg, ctid, threadId));
        }
        ((Pointer)ctid).setInt(0L, threadId);
        return threadId;
    }

    private int flock(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int fd = context.getIntArg(0);
        int operation = context.getIntArg(1);
        if (log.isDebugEnabled()) {
            log.debug("flock fd=" + fd + ", operation=" + operation);
        }
        return 0;
    }

    private int execve(Emulator<?> emulator) {
        Pointer pointer;
        Object context = emulator.getContext();
        UnidbgPointer filename = context.getPointerArg(0);
        Pointer argv = context.getPointerArg(1);
        Pointer envp = context.getPointerArg(2);
        assert (filename != null);
        ArrayList<String> args = new ArrayList<String>();
        while ((pointer = ((Pointer)argv).getPointer(0L)) != null) {
            args.add(pointer.getString(0L));
            argv = argv.share(8L);
        }
        ArrayList<String> env = new ArrayList<String>();
        while ((pointer = ((Pointer)envp).getPointer(0L)) != null) {
            env.add(pointer.getString(0L));
            envp = envp.share(8L);
        }
        log.info("execve filename=" + ((Pointer)filename).getString(0L) + ", args=" + args + ", env=" + env);
        emulator.getMemory().setErrno(13);
        return -1;
    }

    private int bind(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        UnidbgPointer addr = context.getPointerArg(1);
        int addrlen = context.getIntArg(2);
        return this.bind(emulator, sockfd, addr, addrlen);
    }

    private int listen(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        int backlog = context.getIntArg(1);
        return this.listen(emulator, sockfd, backlog);
    }

    protected int stat64(Emulator<AndroidFileIO> emulator, String pathname, Pointer statbuf) {
        FileResult<AndroidFileIO> result = this.resolve(emulator, pathname, 0);
        if (result != null && result.isSuccess()) {
            return ((AndroidFileIO)result.io).fstat(emulator, new Stat64(statbuf));
        }
        if (this.verbose) {
            log.info("stat64 pathname=" + pathname);
        }
        emulator.getMemory().setErrno(result != null ? result.errno : 2);
        return -1;
    }

    private int getpeername(Emulator<?> emulator) {
        FileIO io;
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        UnidbgPointer addr = context.getPointerArg(1);
        UnidbgPointer addrlen = context.getPointerArg(2);
        if (log.isDebugEnabled()) {
            log.debug("getpeername sockfd=" + sockfd + ", addr=" + addr + ", addrlen=" + addrlen);
        }
        if ((io = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return io.getpeername(addr, addrlen);
    }

    private int ppoll(Emulator<?> emulator) {
        Object context = emulator.getContext();
        UnidbgPointer fds = context.getPointerArg(0);
        int nfds = context.getIntArg(1);
        UnidbgPointer tmo_p = context.getPointerArg(2);
        UnidbgPointer sigmask = context.getPointerArg(3);
        int count = 0;
        for (int i = 0; i < nfds; ++i) {
            Pointer pollfd = fds.share((long)i * 8L);
            int fd = pollfd.getInt(0L);
            short events = pollfd.getShort(4L);
            if (log.isDebugEnabled()) {
                log.debug("ppoll fds=" + fds + ", nfds=" + nfds + ", tmo_p=" + tmo_p + ", sigmask=" + sigmask + ", fd=" + fd + ", events=" + events);
            }
            if (fd < 0) {
                pollfd.setShort(6L, (short)0);
                continue;
            }
            short revents = 0;
            if ((events & 4) != 0) {
                revents = 4;
            } else if ((events & 1) != 0) {
                revents = 1;
            }
            pollfd.setShort(6L, revents);
            ++count;
        }
        return count;
    }

    private int sigprocmask(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int how = context.getIntArg(0);
        UnidbgPointer set = context.getPointerArg(1);
        UnidbgPointer oldset = context.getPointerArg(2);
        return this.sigprocmask(emulator, how, set, oldset);
    }

    private int sigaction(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int signum = context.getIntArg(0);
        UnidbgPointer act = context.getPointerArg(1);
        UnidbgPointer oldact = context.getPointerArg(2);
        return this.sigaction(emulator, signum, act, oldact);
    }

    private int pselect6(Emulator<?> emulator) {
        int count;
        Object context = emulator.getContext();
        int nfds = context.getIntArg(0);
        UnidbgPointer readfds = context.getPointerArg(1);
        UnidbgPointer writefds = context.getPointerArg(2);
        UnidbgPointer exceptfds = context.getPointerArg(3);
        UnidbgPointer timeout = context.getPointerArg(4);
        int size = (nfds - 1) / 8 + 1;
        if (log.isDebugEnabled()) {
            byte[] data2;
            log.debug("pselect6 nfds=" + nfds + ", readfds=" + readfds + ", writefds=" + writefds + ", exceptfds=" + exceptfds + ", timeout=" + timeout + ", LR=" + context.getLRPointer());
            if (readfds != null) {
                data2 = ((Pointer)readfds).getByteArray(0L, size);
                Inspector.inspect(data2, "readfds");
            }
            if (writefds != null) {
                data2 = ((Pointer)writefds).getByteArray(0L, size);
                Inspector.inspect(data2, "writefds");
            }
        }
        if (exceptfds != null) {
            emulator.getMemory().setErrno(12);
            return -1;
        }
        if (writefds != null && (count = this.select(nfds, writefds, readfds, false)) > 0) {
            return count;
        }
        if (readfds != null) {
            count = this.select(nfds, readfds, writefds, true);
            if (count == 0) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
            return count;
        }
        throw new AbstractMethodError("pselect6 nfds=" + nfds + ", readfds=null, writefds=" + writefds + ", exceptfds=null, timeout=" + timeout + ", LR=" + context.getLRPointer());
    }

    private int recvfrom(Emulator<?> emulator) {
        FileIO file;
        Backend backend = emulator.getBackend();
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        UnidbgPointer buf = context.getPointerArg(1);
        int len = context.getIntArg(2);
        int flags = context.getIntArg(3);
        UnidbgPointer src_addr = context.getPointerArg(4);
        UnidbgPointer addrlen = context.getPointerArg(5);
        if (log.isDebugEnabled()) {
            log.debug("recvfrom sockfd=" + sockfd + ", buf=" + buf + ", flags=" + flags + ", src_addr=" + src_addr + ", addrlen=" + addrlen);
        }
        if ((file = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.recvfrom(backend, buf, len, flags, src_addr, addrlen);
    }

    private int sendto(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        UnidbgPointer buf = context.getPointerArg(1);
        int len = context.getIntArg(2);
        int flags = context.getIntArg(3);
        UnidbgPointer dest_addr = context.getPointerArg(4);
        int addrlen = context.getIntArg(5);
        return this.sendto(emulator, sockfd, buf, len, flags, dest_addr, addrlen);
    }

    private int connect(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        UnidbgPointer addr = context.getPointerArg(1);
        int addrlen = context.getIntArg(2);
        return this.connect(emulator, sockfd, addr, addrlen);
    }

    private int getsockname(Emulator<?> emulator) {
        FileIO file;
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        UnidbgPointer addr = context.getPointerArg(1);
        UnidbgPointer addrlen = context.getPointerArg(2);
        if (log.isDebugEnabled()) {
            log.debug("getsockname sockfd=" + sockfd + ", addr=" + addr + ", addrlen=" + addrlen);
        }
        if ((file = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.getsockname(addr, addrlen);
    }

    private int accept4(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        UnidbgPointer addr = context.getPointerArg(1);
        UnidbgPointer addrlen = context.getPointerArg(2);
        int flags = context.getIntArg(3);
        return this.accept(emulator, sockfd, addr, addrlen, flags);
    }

    protected final int accept(Emulator<AndroidFileIO> emulator, int sockfd, Pointer addr, Pointer addrlen, int flags) {
        AndroidFileIO file;
        if (log.isDebugEnabled()) {
            log.debug("accept sockfd=" + sockfd + ", addr=" + addr + ", addrlen=" + addrlen + ", flags=" + flags);
        }
        if ((file = (AndroidFileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        AndroidFileIO newIO = file.accept(addr, addrlen);
        if (newIO == null) {
            return -1;
        }
        int fd = this.getMinFd();
        this.fdMap.put(fd, newIO);
        return fd;
    }

    private int getsockopt(Emulator<?> emulator) {
        FileIO file;
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        int level = context.getIntArg(1);
        int optname = context.getIntArg(2);
        UnidbgPointer optval = context.getPointerArg(3);
        UnidbgPointer optlen = context.getPointerArg(4);
        if (log.isDebugEnabled()) {
            log.debug("getsockopt sockfd=" + sockfd + ", level=" + level + ", optname=" + optname + ", optval=" + optval + ", optlen=" + optlen);
        }
        if ((file = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.getsockopt(level, optname, optval, optlen);
    }

    private int setsockopt(Emulator<?> emulator) {
        FileIO file;
        Object context = emulator.getContext();
        int sockfd = context.getIntArg(0);
        int level = context.getIntArg(1);
        int optname = context.getIntArg(2);
        UnidbgPointer optval = context.getPointerArg(3);
        int optlen = context.getIntArg(4);
        if (log.isDebugEnabled()) {
            log.debug("setsockopt sockfd=" + sockfd + ", level=" + level + ", optname=" + optname + ", optval=" + optval + ", optlen=" + optlen);
        }
        if ((file = (FileIO)this.fdMap.get(sockfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        return file.setsockopt(level, optname, optval, optlen);
    }

    @Override
    public void addIOResolver(IOResolver<AndroidFileIO> resolver) {
        super.addIOResolver(resolver);
        if (resolver instanceof AndroidResolver) {
            this.sdk = ((AndroidResolver)resolver).getSdk();
        }
    }

    protected AndroidFileIO createLocalSocketIO(Emulator<?> emulator, int sdk) {
        return new LocalSocketIO(emulator, sdk);
    }

    private int socket(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int domain = context.getIntArg(0);
        int type = context.getIntArg(1) & 0x7FFFF;
        int protocol = context.getIntArg(2);
        if (log.isDebugEnabled()) {
            log.debug("socket domain=" + domain + ", type=" + type + ", protocol=" + protocol);
        }
        if (protocol == 1) {
            throw new UnsupportedOperationException();
        }
        switch (domain) {
            case 0: {
                throw new UnsupportedOperationException();
            }
            case 1: {
                switch (type) {
                    case 1: {
                        int fd = this.getMinFd();
                        this.fdMap.put(fd, this.createLocalSocketIO(emulator, this.sdk));
                        return fd;
                    }
                    case 2: {
                        int fd = this.getMinFd();
                        this.fdMap.put(fd, new LocalAndroidUdpSocket(emulator));
                        return fd;
                    }
                }
                emulator.getMemory().setErrno(13);
                return -1;
            }
            case 2: 
            case 10: {
                switch (type) {
                    case 1: {
                        int fd = this.getMinFd();
                        this.fdMap.put(fd, new TcpSocket(emulator));
                        return fd;
                    }
                    case 2: {
                        int fd = this.getMinFd();
                        this.fdMap.put(fd, new UdpSocket(emulator));
                        return fd;
                    }
                    case 3: {
                        throw new UnsupportedOperationException();
                    }
                }
                break;
            }
            case 16: {
                switch (type) {
                    case 2: {
                        int fd = this.getMinFd();
                        this.fdMap.put(fd, new NetLinkSocket(emulator));
                        return fd;
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        log.info("socket domain=" + domain + ", type=" + type + ", protocol=" + protocol);
        emulator.getMemory().setErrno(97);
        return -1;
    }

    protected int uname(Emulator<?> emulator) {
        Object context = emulator.getContext();
        UnidbgPointer buf = context.getPointerArg(0);
        if (log.isDebugEnabled()) {
            log.debug("uname buf=" + buf);
        }
        int SYS_NMLN = 65;
        Pointer sysName = buf.share(0L);
        sysName.setString(0L, "Linux");
        Pointer nodeName = sysName.share(65L);
        nodeName.setString(0L, "localhost");
        Pointer release = nodeName.share(65L);
        release.setString(0L, "1.0.0-unidbg");
        Pointer version = release.share(65L);
        version.setString(0L, "#1 SMP PREEMPT Thu Apr 19 14:36:58 CST 2018");
        Pointer machine = version.share(65L);
        machine.setString(0L, "armv8l");
        Pointer domainName = machine.share(65L);
        domainName.setString(0L, "localdomain");
        return 0;
    }

    private int getppid(Emulator<AndroidFileIO> emulator) {
        if (log.isDebugEnabled()) {
            log.debug("getppid");
        }
        return emulator.getPid();
    }

    private void exit_group(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int status = context.getIntArg(0);
        if (log.isDebugEnabled()) {
            log.debug("exit with code: " + status, new Exception("exit_group status=" + status));
        } else {
            System.out.println("exit with code: " + status);
        }
        if (LogFactory.getLog(AbstractEmulator.class).isDebugEnabled()) {
            this.createBreaker(emulator).debug();
        }
        emulator.getBackend().emu_stop();
    }

    private int munmap(Backend backend, Emulator<?> emulator) {
        long timeInMillis = System.currentTimeMillis();
        long start = backend.reg_read(199).longValue();
        int length = backend.reg_read(200).intValue();
        emulator.getMemory().munmap(start, length);
        if (log.isDebugEnabled()) {
            log.debug("munmap start=0x" + Long.toHexString(start) + ", length=" + length + ", offset=" + (System.currentTimeMillis() - timeInMillis));
        }
        return 0;
    }

    private long mremap(Emulator<?> emulator) {
        boolean fixed;
        Arm64RegisterContext context = (Arm64RegisterContext)emulator.getContext();
        UnidbgPointer old_address = context.getXPointer(0);
        int old_size = context.getXInt(1);
        int new_size = context.getXInt(2);
        int flags = context.getXInt(3);
        UnidbgPointer new_address = context.getXPointer(4);
        if (log.isDebugEnabled()) {
            log.debug("mremap old_address=" + old_address + ", old_size=" + old_size + ", new_size=" + new_size + ", flags=" + flags + ", new_address=" + new_address);
        }
        if (old_size == 0) {
            throw new BackendException("old_size is zero");
        }
        boolean bl = fixed = (flags & 2) != 0;
        if ((flags & 1) == 0) {
            throw new BackendException("flags=" + flags);
        }
        Memory memory = emulator.getMemory();
        byte[] data2 = old_address.getByteArray(0L, old_size);
        int prot = memory.munmap(old_address.toUIntPeer(), old_size);
        long address = fixed ? memory.mmap2(new_address.toUIntPeer(), new_size, prot, 48, 0, 0) : memory.mmap2(0L, new_size, prot, 32, 0, 0);
        UnidbgPointer pointer = UnidbgPointer.pointer(emulator, address);
        assert (pointer != null);
        pointer.write(0L, data2, 0, data2.length);
        return pointer.toUIntPeer();
    }

    private int prctl(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int option = context.getIntArg(0);
        long arg2 = context.getLongArg(1);
        if (log.isDebugEnabled()) {
            log.debug("prctl option=0x" + Integer.toHexString(option) + ", arg2=0x" + Long.toHexString(arg2));
        }
        switch (option) {
            case 15: {
                UnidbgPointer threadName = context.getPointerArg(1);
                if (log.isDebugEnabled()) {
                    log.debug("prctl set thread name: " + ((Pointer)threadName).getString(0L));
                }
                return 0;
            }
            case 1398164801: {
                UnidbgPointer addr = context.getPointerArg(2);
                int len = context.getIntArg(3);
                UnidbgPointer pointer = context.getPointerArg(4);
                if (log.isDebugEnabled()) {
                    log.debug("prctl set vma addr=" + addr + ", len=" + len + ", pointer=" + pointer + ", name=" + ((Pointer)pointer).getString(0L));
                }
                return 0;
            }
            case 1499557217: {
                int pid = (int)arg2;
                if (log.isDebugEnabled()) {
                    log.debug("prctl set ptracer: " + pid);
                }
                return 0;
            }
            case 38: 
            case 41: {
                return 0;
            }
        }
        throw new UnsupportedOperationException("option=" + option);
    }

    protected int clock_gettime(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int clk_id = context.getIntArg(0) & 7;
        UnidbgPointer tp = context.getPointerArg(1);
        long offset = clk_id == 0 ? this.currentTimeMillis() * 1000000L : System.nanoTime() - this.nanoTime;
        long tv_sec = offset / 1000000000L;
        long tv_nsec = offset % 1000000000L;
        switch (clk_id) {
            case 0: 
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                ((Pointer)tp).setLong(0L, tv_sec);
                ((Pointer)tp).setLong(8L, tv_nsec);
                return 0;
            }
            case 3: {
                ((Pointer)tp).setLong(0L, 0L);
                ((Pointer)tp).setLong(8L, new Random().nextInt(3476191));
                return 0;
            }
        }
        if (log.isDebugEnabled()) {
            emulator.attach().debug();
        }
        throw new UnsupportedOperationException("clk_id=" + clk_id);
    }

    protected long ptrace(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int request = context.getIntArg(0);
        int pid = context.getIntArg(1);
        UnidbgPointer addr = context.getPointerArg(2);
        UnidbgPointer data2 = context.getPointerArg(3);
        log.info("ptrace request=0x" + Integer.toHexString(request) + ", pid=" + pid + ", addr=" + addr + ", data=" + data2);
        return 0L;
    }

    private int fcntl(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int fd = context.getIntArg(0);
        int cmd = context.getIntArg(1);
        int arg = context.getIntArg(2);
        return this.fcntl(emulator, fd, cmd, arg);
    }

    private int writev(Emulator<?> emulator) {
        FileIO file;
        Object context = emulator.getContext();
        int fd = context.getIntArg(0);
        UnidbgPointer iov = context.getPointerArg(1);
        int iovcnt = context.getIntArg(2);
        if (log.isDebugEnabled()) {
            for (int i = 0; i < iovcnt; ++i) {
                Pointer iov_base = ((Pointer)iov).getPointer((long)i * 16L);
                long iov_len = ((Pointer)iov).getLong((long)i * 16L + 8L);
                byte[] data2 = iov_base.getByteArray(0L, (int)iov_len);
                Inspector.inspect(data2, "writev fd=" + fd + ", iov=" + iov + ", iov_base=" + iov_base);
            }
        }
        if ((file = (FileIO)this.fdMap.get(fd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        int count = 0;
        for (int i = 0; i < iovcnt; ++i) {
            Pointer iov_base = ((Pointer)iov).getPointer((long)i * 16L);
            long iov_len = ((Pointer)iov).getLong((long)i * 16L + 8L);
            byte[] data3 = iov_base.getByteArray(0L, (int)iov_len);
            count += file.write(data3);
        }
        return count;
    }

    private long brk(Backend backend, Emulator<?> emulator) {
        long address = backend.reg_read(199).longValue();
        if (log.isDebugEnabled()) {
            log.debug("brk address=0x" + Long.toHexString(address));
        }
        return emulator.getMemory().brk(address);
    }

    private int mprotect(Backend backend, Emulator<?> emulator) {
        long address = backend.reg_read(199).longValue();
        int length = backend.reg_read(200).intValue();
        int prot = backend.reg_read(201).intValue();
        long pageAlign = emulator.getPageAlign();
        long alignedAddress = address / pageAlign * pageAlign;
        long offset = address - alignedAddress;
        long alignedLength = ARM.alignSize((long)length + offset, emulator.getPageAlign());
        if (log.isDebugEnabled()) {
            log.debug("mprotect address=0x" + Long.toHexString(address) + ", alignedAddress=0x" + Long.toHexString(alignedAddress) + ", offset=" + offset + ", length=" + length + ", alignedLength=" + alignedLength + ", prot=0x" + Integer.toHexString(prot));
        }
        return emulator.getMemory().mprotect(alignedAddress, (int)alignedLength, prot);
    }

    private long mmap(Backend backend, Emulator<?> emulator) {
        boolean warning;
        long start = backend.reg_read(199).longValue();
        int length = backend.reg_read(200).intValue();
        int prot = backend.reg_read(201).intValue();
        int flags = backend.reg_read(202).intValue();
        int fd = backend.reg_read(203).intValue();
        int offset = backend.reg_read(204).intValue() << 12;
        boolean bl = warning = length > 0x10000000;
        if (log.isDebugEnabled() || warning) {
            String msg = "mmap start=0x" + Long.toHexString(start) + ", length=" + length + ", prot=0x" + Integer.toHexString(prot) + ", flags=0x" + Integer.toHexString(flags) + ", fd=" + fd + ", offset=" + offset;
            if (warning) {
                log.warn(msg);
                if (log.isTraceEnabled()) {
                    emulator.attach().debug();
                }
            } else {
                log.debug(msg);
            }
        }
        return emulator.getMemory().mmap2(start, length, prot, flags, fd, offset);
    }

    private int gettimeofday(Emulator<?> emulator) {
        UnidbgPointer tv = UnidbgPointer.register(emulator, 199);
        UnidbgPointer tz = UnidbgPointer.register(emulator, 200);
        return this.gettimeofday64(tv, tz);
    }

    private int faccessat(Emulator<AndroidFileIO> emulator) {
        int ret;
        Object context = emulator.getContext();
        int dirfd = context.getIntArg(0);
        UnidbgPointer pathname_p = context.getPointerArg(1);
        int oflags = context.getIntArg(2);
        int mode = context.getIntArg(3);
        String pathname = ((Pointer)pathname_p).getString(0L);
        if (log.isDebugEnabled()) {
            log.debug("faccessat dirfd=" + dirfd + ", pathname=" + pathname + ", oflags=0x" + Integer.toHexString(oflags) + ", mode=0x" + Integer.toHexString(mode));
        }
        if ((ret = this.faccessat(emulator, pathname)) == -1 && this.verbose) {
            log.info("faccessat failed dirfd=" + dirfd + ", pathname=" + pathname + ", oflags=0x" + Integer.toHexString(oflags) + ", mode=0x" + Integer.toHexString(mode));
        }
        return ret;
    }

    private int faccessat(Emulator<AndroidFileIO> emulator, String pathname) {
        FileResult<AndroidFileIO> result = this.resolve(emulator, pathname, 0);
        if (result != null && result.isSuccess()) {
            return 0;
        }
        emulator.getMemory().setErrno(result != null ? result.errno : 13);
        return -1;
    }

    private int fstatat64(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int dirfd = context.getIntArg(0);
        UnidbgPointer pathname = context.getPointerArg(1);
        UnidbgPointer statbuf = context.getPointerArg(2);
        int flags = context.getIntArg(3);
        String path = FilenameUtils.normalize(((Pointer)pathname).getString(0L), true);
        if (log.isDebugEnabled()) {
            log.debug("fstatat64 dirfd=" + dirfd + ", pathname=" + path + ", statbuf=" + statbuf + ", flags=" + flags);
        }
        if (dirfd == -100 && "".equals(path)) {
            return this.stat64(emulator, ".", statbuf);
        }
        if (path.startsWith("/")) {
            return this.stat64(emulator, path, statbuf);
        }
        if (dirfd != -100) {
            throw new BackendException("dirfd=" + dirfd);
        }
        log.warn("fstatat64 dirfd=" + dirfd + ", pathname=" + path + ", statbuf=" + statbuf + ", flags=" + flags);
        if (log.isDebugEnabled()) {
            emulator.attach().debug();
        }
        emulator.getMemory().setErrno(13);
        return -1;
    }

    private int openat(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int dirfd = context.getIntArg(0);
        UnidbgPointer pathname_p = context.getPointerArg(1);
        int oflags = context.getIntArg(2);
        int mode = context.getIntArg(3);
        String pathname = ((Pointer)pathname_p).getString(0L);
        String msg = "openat dirfd=" + dirfd + ", pathname=" + pathname + ", oflags=0x" + Integer.toHexString(oflags) + ", mode=" + Integer.toHexString(mode);
        if (log.isDebugEnabled()) {
            log.debug(msg);
        }
        if ("/data/misc/zoneinfo/current/tzdata".equals(pathname = FilenameUtils.normalize(pathname, true)) || "/dev/pmsg0".equals(pathname)) {
            emulator.getMemory().setErrno(2);
            return -2;
        }
        if (pathname.startsWith("/")) {
            int fd = this.open(emulator, pathname, oflags);
            if (fd == -1) {
                if (this.verbose) {
                    log.info(msg);
                }
                return -emulator.getMemory().getLastErrno();
            }
            return fd;
        }
        if (dirfd != -100) {
            throw new BackendException();
        }
        int fd = this.open(emulator, pathname, oflags);
        if (fd == -1) {
            if (log.isTraceEnabled()) {
                emulator.attach().debug();
            }
            if (this.verbose) {
                log.info(msg);
            }
            return -emulator.getMemory().getLastErrno();
        }
        return fd;
    }

    private int lseek(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int fd = context.getIntArg(0);
        int offset = context.getIntArg(1);
        int whence = context.getIntArg(2);
        FileIO file = (FileIO)this.fdMap.get(fd);
        if (file == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        int pos = file.lseek(offset, whence);
        if (log.isDebugEnabled()) {
            log.debug("lseek fd=" + fd + ", offset=" + offset + ", whence=" + whence + ", pos=" + pos);
        }
        return pos;
    }

    private int close(Backend backend, Emulator<?> emulator) {
        int fd = backend.reg_read(199).intValue();
        if (log.isDebugEnabled()) {
            log.debug("close fd=" + fd);
        }
        return this.close(emulator, fd);
    }

    private int getdents64(Emulator<AndroidFileIO> emulator) {
        AndroidFileIO io;
        Object context = emulator.getContext();
        int fd = context.getIntArg(0);
        UnidbgPointer dirp = context.getPointerArg(1);
        int size = context.getIntArg(2);
        if (log.isDebugEnabled()) {
            log.debug("getdents64 fd=" + fd + ", dirp=" + dirp + ", size=" + size);
        }
        if ((io = (AndroidFileIO)this.fdMap.get(fd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        dirp.setSize(size);
        return io.getdents64(dirp, size);
    }

    private int readlinkat(Emulator<AndroidFileIO> emulator) {
        Object context = emulator.getContext();
        int dirfd = context.getIntArg(0);
        UnidbgPointer pathname = context.getPointerArg(1);
        UnidbgPointer buf = context.getPointerArg(2);
        int bufSize = context.getIntArg(3);
        String path = ((Pointer)pathname).getString(0L);
        if (dirfd != -100) {
            throw new BackendException();
        }
        return this.readlink(emulator, path, buf, bufSize);
    }

    private int fstat(Backend backend, Emulator<?> emulator) {
        int fd = backend.reg_read(199).intValue();
        UnidbgPointer stat = UnidbgPointer.register(emulator, 200);
        return this.fstat(emulator, fd, stat);
    }

    protected int fstat(Emulator<?> emulator, int fd, Pointer stat) {
        AndroidFileIO file = (AndroidFileIO)this.fdMap.get(fd);
        if (file == null) {
            if (log.isDebugEnabled()) {
                log.debug("fstat fd=" + fd + ", stat=" + stat + ", errno=" + 9);
            }
            emulator.getMemory().setErrno(9);
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug("fstat file=" + file + ", stat=" + stat + ", from=" + emulator.getContext().getLRPointer());
        }
        return file.fstat(emulator, new Stat64(stat));
    }

    private int ioctl(Emulator<?> emulator) {
        FileIO file;
        Object context = emulator.getContext();
        int fd = context.getIntArg(0);
        long request = context.getLongArg(1);
        long argp = context.getLongArg(2);
        if (log.isDebugEnabled()) {
            log.debug("ioctl fd=" + fd + ", request=0x" + Long.toHexString(request) + ", argp=0x" + Long.toHexString(argp));
        }
        if ((file = (FileIO)this.fdMap.get(fd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        int ret = file.ioctl(emulator, request, argp);
        if (ret == -1) {
            emulator.getMemory().setErrno(25);
        }
        return ret;
    }

    private int write(Emulator<?> emulator) {
        Object context = emulator.getContext();
        int fd = context.getIntArg(0);
        UnidbgPointer buffer = context.getPointerArg(1);
        int count = context.getIntArg(2);
        return this.write(emulator, fd, buffer, count);
    }

    private int read(Backend backend, Emulator<?> emulator) {
        int fd = backend.reg_read(199).intValue();
        UnidbgPointer buffer = UnidbgPointer.register(emulator, 200);
        int count = backend.reg_read(201).intValue();
        return this.read(emulator, fd, buffer, count);
    }

    private int dup3(Emulator<?> emulator) {
        FileIO old;
        Object context = emulator.getContext();
        int oldfd = context.getIntArg(0);
        int newfd = context.getIntArg(1);
        int flags = context.getIntArg(2);
        if (log.isDebugEnabled()) {
            log.debug("dup3 oldfd=" + oldfd + ", newfd=" + newfd + ", flags=0x" + Integer.toHexString(flags));
        }
        if ((old = (FileIO)this.fdMap.get(oldfd)) == null) {
            emulator.getMemory().setErrno(9);
            return -1;
        }
        if (oldfd == newfd) {
            return newfd;
        }
        AndroidFileIO _new = (AndroidFileIO)this.fdMap.remove(newfd);
        if (_new != null) {
            _new.close();
        }
        _new = (AndroidFileIO)old.dup2();
        this.fdMap.put(newfd, _new);
        return newfd;
    }

    @Override
    protected AndroidFileIO createByteArrayFileIO(String pathname, int oflags, byte[] data2) {
        return new ByteArrayFileIO(oflags, pathname, data2);
    }

    @Override
    protected AndroidFileIO createDriverFileIO(Emulator<?> emulator, int oflags, String pathname) {
        return DriverFileIO.create(emulator, oflags, pathname);
    }
}

