/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.AndroidEmulator;
import com.github.unidbg.Family;
import com.github.unidbg.arm.AbstractARMEmulator;
import com.github.unidbg.arm.backend.BackendFactory;
import com.github.unidbg.file.FileSystem;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.file.linux.LinuxFileSystem;
import com.github.unidbg.linux.ARM32SyscallHandler;
import com.github.unidbg.linux.AndroidElfLoader;
import com.github.unidbg.linux.android.AndroidARMUnwinder;
import com.github.unidbg.linux.android.ArmLD;
import com.github.unidbg.linux.android.URLibraryFile;
import com.github.unidbg.linux.android.dvm.DalvikVM;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.spi.Dlfcn;
import com.github.unidbg.spi.LibraryFile;
import com.github.unidbg.unix.UnixSyscallHandler;
import com.github.unidbg.unwind.Unwinder;
import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;

public class AndroidARMEmulator
extends AbstractARMEmulator<AndroidFileIO>
implements AndroidEmulator {
    private VM vm;

    protected AndroidARMEmulator(String processName, File rootDir, Collection<BackendFactory> backendFactories) {
        super(processName, rootDir, Family.Android32, backendFactories, new String[0]);
    }

    @Override
    protected FileSystem<AndroidFileIO> createFileSystem(File rootDir) {
        return new LinuxFileSystem(this, rootDir);
    }

    @Override
    protected Memory createMemory(UnixSyscallHandler<AndroidFileIO> syscallHandler, String[] envs) {
        return new AndroidElfLoader(this, syscallHandler);
    }

    @Override
    protected Dlfcn createDyld(SvcMemory svcMemory) {
        return new ArmLD(this.backend, svcMemory);
    }

    @Override
    protected UnixSyscallHandler<AndroidFileIO> createSyscallHandler(SvcMemory svcMemory) {
        return new ARM32SyscallHandler(svcMemory);
    }

    private VM createDalvikVMInternal(File apkFile) {
        return new DalvikVM(this, apkFile);
    }

    @Override
    protected final void setupTraps() {
        super.setupTraps();
        int __kuser_memory_barrier = -516948194;
        this.memory.pointer(0xFFFF0FA0L).setInt(0L, __kuser_memory_barrier);
        ByteBuffer buffer = ByteBuffer.allocate(32);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(-176164769);
        buffer.putInt(-510509153);
        buffer.putInt(-531419136);
        buffer.putInt(25313169);
        buffer.putInt(0x3330001);
        buffer.putInt(0xAFFFFFA);
        buffer.putInt(-495779840);
        buffer.putInt(-352321553);
        byte[] __kuser_cmpxchg = buffer.array();
        this.memory.pointer(0xFFFF0FC0L).write(__kuser_cmpxchg);
    }

    @Override
    public LibraryFile createURLibraryFile(URL url, String libName) {
        return new URLibraryFile(url, libName, -1, false);
    }

    @Override
    protected boolean isPaddingArgument() {
        return true;
    }

    @Override
    public VM createDalvikVM() {
        return this.createDalvikVM((File)null);
    }

    @Override
    public final VM createDalvikVM(File apkFile) {
        if (this.vm != null) {
            throw new IllegalStateException("vm is already created");
        }
        this.vm = this.createDalvikVMInternal(apkFile);
        return this.vm;
    }

    @Override
    public VM createDalvikVM(Class<?> callingClass) {
        return this.createDalvikVM(new File(callingClass.getProtectionDomain().getCodeSource().getLocation().getPath()));
    }

    @Override
    public final VM getDalvikVM() {
        return this.vm;
    }

    @Override
    public Unwinder getUnwinder() {
        return new AndroidARMUnwinder(this);
    }
}

