/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.AndroidEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.LibraryResolver;
import com.github.unidbg.file.FileResult;
import com.github.unidbg.file.FileSystem;
import com.github.unidbg.file.IOResolver;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.hook.InlineHook;
import com.github.unidbg.linux.android.URLibraryFile;
import com.github.unidbg.linux.file.ByteArrayFileIO;
import com.github.unidbg.linux.file.DirectoryFileIO;
import com.github.unidbg.linux.file.LogCatFileIO;
import com.github.unidbg.linux.file.SimpleFileIO;
import com.github.unidbg.linux.thread.ThreadJoin19;
import com.github.unidbg.linux.thread.ThreadJoin23;
import com.github.unidbg.spi.LibraryFile;
import com.github.unidbg.spi.SyscallHandler;
import com.github.unidbg.unix.ThreadJoinVisitor;
import com.github.unidbg.utils.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class AndroidResolver
implements LibraryResolver,
IOResolver<AndroidFileIO> {
    private final int sdk;
    private final List<String> needed;

    public AndroidResolver(int sdk, String ... needed) {
        this.sdk = sdk;
        this.needed = needed == null ? null : Arrays.asList(needed);
    }

    public void patchThread(Emulator<?> emulator, InlineHook inlineHook, ThreadJoinVisitor visitor) {
        switch (this.sdk) {
            case 19: {
                ThreadJoin19.patch(emulator, inlineHook, visitor);
                break;
            }
            case 23: {
                ThreadJoin23.patch(emulator, inlineHook, visitor);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public int getSdk() {
        return this.sdk;
    }

    @Override
    public LibraryFile resolveLibrary(Emulator<?> emulator, String libraryName) {
        if (this.needed == null) {
            return null;
        }
        if (!this.needed.isEmpty() && !this.needed.contains(libraryName)) {
            return null;
        }
        return AndroidResolver.resolveLibrary(emulator, libraryName, this.sdk, this.getClass());
    }

    static LibraryFile resolveLibrary(Emulator<?> emulator, String libraryName, int sdk) {
        return AndroidResolver.resolveLibrary(emulator, libraryName, sdk, AndroidResolver.class);
    }

    protected static LibraryFile resolveLibrary(Emulator<?> emulator, String libraryName, int sdk, Class<?> resClass) {
        String lib = emulator.is32Bit() ? "lib" : "lib64";
        String name = "/android/sdk" + sdk + "/" + lib + "/" + libraryName.replace('+', 'p');
        URL url = resClass.getResource(name);
        if (url != null) {
            return new URLibraryFile(url, libraryName, sdk, emulator.is64Bit());
        }
        return null;
    }

    @Override
    public FileResult<AndroidFileIO> resolve(Emulator<AndroidFileIO> emulator, String path, int oflags) {
        FileSystem<AndroidFileIO> fileSystem = emulator.getFileSystem();
        File rootDir = fileSystem.getRootDir();
        if (path.startsWith("/dev/log/")) {
            try {
                File log = new File(rootDir, path);
                File logDir = log.getParentFile();
                if (!logDir.exists() && !logDir.mkdirs()) {
                    throw new IOException("mkdirs failed: " + logDir);
                }
                if (!log.exists() && !log.createNewFile()) {
                    throw new IOException("create new file failed: " + log);
                }
                return FileResult.success(new LogCatFileIO(emulator, oflags, log, path));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (".".equals(path)) {
            return FileResult.success(this.createFileIO(fileSystem.createWorkDir(), path, oflags));
        }
        String androidResource = FilenameUtils.normalize("/android/sdk" + this.sdk + "/" + path, true);
        URL url = this.getClass().getResource(androidResource);
        if (url != null) {
            return FileResult.fallback(this.createFileIO(url, path, oflags));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AndroidFileIO createFileIO(URL url, String pathname, int oflags) {
        File file = ResourceUtils.toFile(url);
        if (file != null) {
            return this.createFileIO(file, pathname, oflags);
        }
        try {
            JarEntry entry;
            JarFile jarFile;
            block15: {
                URLConnection connection = url.openConnection();
                InputStream inputStream = connection.getInputStream();
                if (!(connection instanceof JarURLConnection)) throw new IllegalStateException(connection.getClass().getName());
                JarURLConnection jarURLConnection = (JarURLConnection)connection;
                jarFile = jarURLConnection.getJarFile();
                entry = jarURLConnection.getJarEntry();
                if (!entry.isDirectory()) {
                    byte[] data2 = IOUtils.toByteArray(inputStream);
                    ByteArrayFileIO byteArrayFileIO = new ByteArrayFileIO(oflags, pathname, data2);
                    return byteArrayFileIO;
                }
                break block15;
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            Enumeration<JarEntry> entryEnumeration = jarFile.entries();
            ArrayList<DirectoryFileIO.DirectoryEntry> list = new ArrayList<DirectoryFileIO.DirectoryEntry>();
            while (true) {
                if (!entryEnumeration.hasMoreElements()) {
                    DirectoryFileIO directoryFileIO = new DirectoryFileIO(oflags, pathname, list.toArray(new DirectoryFileIO.DirectoryEntry[0]));
                    return directoryFileIO;
                }
                JarEntry check = entryEnumeration.nextElement();
                if (entry.getName().equals(check.getName()) || !check.getName().startsWith(entry.getName())) continue;
                boolean isDir = check.isDirectory();
                String sub = check.getName().substring(entry.getName().length());
                if (isDir) {
                    sub = sub.substring(0, sub.length() - 1);
                }
                if (sub.contains("/")) continue;
                list.add(new DirectoryFileIO.DirectoryEntry(true, sub));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(pathname, e);
        }
    }

    private AndroidFileIO createFileIO(File file, String pathname, int oflags) {
        if (file.canRead()) {
            return file.isDirectory() ? new DirectoryFileIO(oflags, pathname, new DirectoryFileIO.DirectoryEntry[0]) : new SimpleFileIO(oflags, file, pathname);
        }
        return null;
    }

    @Override
    public void onSetToLoader(Emulator<?> emulator) {
        AndroidEmulator androidEmulator = (AndroidEmulator)emulator;
        SyscallHandler<AndroidFileIO> syscallHandler = androidEmulator.getSyscallHandler();
        syscallHandler.addIOResolver(this);
    }
}

