/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.Svc;
import com.github.unidbg.Symbol;
import com.github.unidbg.arm.ArmHook;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.HookStatus;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.linux.LinuxModule;
import com.github.unidbg.linux.struct.dl_phdr_info32;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.MemoryBlock;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.pointer.UnidbgStructure;
import com.github.unidbg.spi.Dlfcn;
import com.github.unidbg.spi.InitFunction;
import com.github.unidbg.unix.struct.DlInfo32;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import net.fornwall.jelf.ElfDynamicStructure;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArmLD
extends Dlfcn {
    private static final Log log = LogFactory.getLog(ArmLD.class);
    private final Backend backend;

    ArmLD(Backend backend, SvcMemory svcMemory) {
        super(svcMemory);
        this.backend = backend;
    }

    @Override
    public long hook(final SvcMemory svcMemory, String libraryName, String symbolName, long old) {
        if ("libdl.so".equals(libraryName)) {
            if (log.isDebugEnabled()) {
                log.debug("link " + symbolName + ", old=0x" + Long.toHexString(old));
            }
            switch (symbolName) {
                case "dl_iterate_phdr": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){
                        private MemoryBlock block;

                        @Override
                        public UnidbgPointer onRegister(SvcMemory svcMemory2, int svcNumber) {
                            try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm, KeystoneMode.Arm);){
                                KeystoneEncoded encoded = keystone.assemble(Arrays.asList("push {r4-r7, lr}", "svc #0x" + Integer.toHexString(svcNumber), "pop {r7}", "cmp r7, #0", "beq 0x34", "pop {r0-r2}", "blx r7", "cmp r0, #0", "beq 0x8", "pop {r7}", "cmp r7, #0", "popne {r4-r6}", "bne 0x24", "mov r7, #0", "mov r5, #0x" + Integer.toHexString(34952), "mov r4, #0x" + Integer.toHexString(svcNumber), "svc #0", "pop {r4-r7, pc}"));
                                byte[] code = encoded.getMachineCode();
                                UnidbgPointer pointer = svcMemory2.allocate(code.length, "dl_iterate_phdr");
                                pointer.write(0L, code, 0, code.length);
                                if (log.isDebugEnabled()) {
                                    log.debug("dl_iterate_phdr: pointer=" + pointer);
                                }
                                UnidbgPointer unidbgPointer = pointer;
                                return unidbgPointer;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public long handle(Emulator<?> emulator) {
                            if (this.block != null) {
                                throw new IllegalStateException();
                            }
                            Object context = emulator.getContext();
                            UnidbgPointer cb = context.getPointerArg(0);
                            UnidbgPointer data2 = context.getPointerArg(1);
                            Collection<Module> modules = emulator.getMemory().getLoadedModules();
                            ArrayList<LinuxModule> list = new ArrayList<LinuxModule>();
                            for (Module module : modules) {
                                LinuxModule lm = (LinuxModule)module;
                                if (lm.elfFile == null) continue;
                                list.add(lm);
                            }
                            Collections.reverse(list);
                            int size = UnidbgStructure.calculateSize(dl_phdr_info32.class);
                            this.block = emulator.getMemory().malloc(size * list.size(), true);
                            UnidbgPointer ptr = this.block.getPointer();
                            Backend backend = emulator.getBackend();
                            UnidbgPointer sp = UnidbgPointer.register(emulator, 12);
                            if (log.isDebugEnabled()) {
                                log.debug("dl_iterate_phdr cb=" + cb + ", data=" + data2 + ", size=" + list.size() + ", sp=" + sp);
                            }
                            try {
                                sp = sp.share(-4L, 0L);
                                sp.setInt(0L, 0);
                                for (LinuxModule module : list) {
                                    dl_phdr_info32 info = new dl_phdr_info32(ptr);
                                    UnidbgPointer dlpi_addr = UnidbgPointer.pointer(emulator, module.virtualBase);
                                    assert (dlpi_addr != null);
                                    info.dlpi_addr = (int)dlpi_addr.toUIntPeer();
                                    ElfDynamicStructure dynamicStructure = module.dynamicStructure;
                                    info.dlpi_name = dynamicStructure != null && dynamicStructure.soName > 0 && dynamicStructure.dt_strtab_offset > 0L ? (int)UnidbgPointer.nativeValue(dlpi_addr.share(dynamicStructure.dt_strtab_offset + (long)dynamicStructure.soName)) : (int)UnidbgPointer.nativeValue(module.createPathMemory(svcMemory));
                                    info.dlpi_phdr = (int)UnidbgPointer.nativeValue(dlpi_addr.share(module.elfFile.ph_offset));
                                    info.dlpi_phnum = module.elfFile.num_ph;
                                    info.pack();
                                    sp = sp.share(-4L, 0L);
                                    sp.setPointer(0L, data2);
                                    sp = sp.share(-4L, 0L);
                                    sp.setInt(0L, size);
                                    sp = sp.share(-4L, 0L);
                                    sp.setPointer(0L, ptr);
                                    sp = sp.share(-4L, 0L);
                                    sp.setPointer(0L, cb);
                                    ptr = ptr.share(size, 0L);
                                }
                                long l = context.getLongArg(0);
                                return l;
                            }
                            finally {
                                backend.reg_write(12, sp.peer);
                            }
                        }

                        @Override
                        public void handlePostCallback(Emulator<?> emulator) {
                            super.handlePostCallback(emulator);
                            if (this.block == null) {
                                throw new IllegalStateException();
                            }
                            this.block.free();
                            this.block = null;
                        }
                    }).peer;
                }
                case "dlerror": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){

                        @Override
                        public long handle(Emulator<?> emulator) {
                            return ((ArmLD)ArmLD.this).error.peer;
                        }
                    }).peer;
                }
                case "dlclose": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){

                        @Override
                        public long handle(Emulator<?> emulator) {
                            Object context = emulator.getContext();
                            int handle = context.getIntArg(0);
                            if (log.isDebugEnabled()) {
                                log.debug("dlclose handle=0x" + Long.toHexString(handle));
                            }
                            return ArmLD.this.dlclose(emulator.getMemory(), handle);
                        }
                    }).peer;
                }
                case "dlopen": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){

                        @Override
                        public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
                            ByteBuffer buffer = ByteBuffer.allocate(28);
                            buffer.order(ByteOrder.LITTLE_ENDIAN);
                            buffer.putInt(-382910224);
                            buffer.putInt(ArmSvc.assembleSvc(svcNumber));
                            buffer.putInt(-459444220);
                            buffer.putInt(-480837632);
                            buffer.putInt(307224592);
                            buffer.putInt(288358167);
                            buffer.putInt(-390233871);
                            byte[] code = buffer.array();
                            UnidbgPointer pointer = svcMemory.allocate(code.length, "dlopen");
                            pointer.write(code);
                            return pointer;
                        }

                        @Override
                        public long handle(Emulator<?> emulator) {
                            String filename;
                            Object context = emulator.getContext();
                            UnidbgPointer fileNamePointer = context.getPointerArg(0);
                            int flags = context.getIntArg(1);
                            if (fileNamePointer == null) {
                                Module module = emulator.getMemory().findModuleByAddress(context.getLR());
                                if (module == null) {
                                    throw new UnsupportedOperationException();
                                }
                                filename = module.name;
                            } else {
                                filename = ((Pointer)fileNamePointer).getString(0L);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("dlopen filename=" + filename + ", flags=" + flags + ", LR=" + context.getLRPointer());
                            }
                            return ArmLD.this.dlopen(emulator.getMemory(), filename, emulator);
                        }
                    }).peer;
                }
                case "dladdr": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){

                        @Override
                        public long handle(Emulator<?> emulator) {
                            Module module;
                            Object context = emulator.getContext();
                            int addr = context.getIntArg(0);
                            UnidbgPointer info = context.getPointerArg(1);
                            if (log.isDebugEnabled()) {
                                log.debug("dladdr addr=0x" + Long.toHexString(addr) + ", info=" + info + ", LR=" + context.getLRPointer());
                            }
                            if ((module = emulator.getMemory().findModuleByAddress(addr)) == null) {
                                return 0L;
                            }
                            Symbol symbol = module.findClosestSymbolByAddress(addr, true);
                            DlInfo32 dlInfo = new DlInfo32(info);
                            dlInfo.dli_fname = (int)UnidbgPointer.nativeValue(module.createPathMemory(svcMemory));
                            dlInfo.dli_fbase = (int)module.base;
                            if (symbol != null) {
                                dlInfo.dli_sname = (int)UnidbgPointer.nativeValue(symbol.createNameMemory(svcMemory));
                                dlInfo.dli_saddr = (int)symbol.getAddress();
                            }
                            dlInfo.pack();
                            return 1L;
                        }
                    }).peer;
                }
                case "dlsym": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){

                        @Override
                        public long handle(Emulator<?> emulator) {
                            Object context = emulator.getContext();
                            int handle = context.getIntArg(0);
                            UnidbgPointer symbol = context.getPointerArg(1);
                            if (log.isDebugEnabled()) {
                                log.debug("dlsym handle=0x" + Long.toHexString(handle) + ", symbol=" + ((Pointer)symbol).getString(0L) + ", LR=" + context.getLRPointer());
                            }
                            return ArmLD.this.dlsym(emulator, (long)handle & 0xFFFFFFFFL, ((Pointer)symbol).getString(0L));
                        }
                    }).peer;
                }
                case "dl_unwind_find_exidx": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){

                        @Override
                        public long handle(Emulator<?> emulator) {
                            Object context = emulator.getContext();
                            UnidbgPointer pc = context.getPointerArg(0);
                            UnidbgPointer pcount = context.getPointerArg(1);
                            log.info("dl_unwind_find_exidx pc" + pc + ", pcount=" + pcount);
                            return 0L;
                        }
                    }).peer;
                }
                case "android_get_application_target_sdk_version": {
                    return svcMemory.registerSvc((Svc)new ArmHook(){

                        @Override
                        protected HookStatus hook(Emulator<?> emulator) {
                            return HookStatus.LR(emulator, 0L);
                        }
                    }).peer;
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long dlopen(Memory memory, String filename, Emulator<?> emulator) {
        UnidbgPointer pointer = UnidbgPointer.register(emulator, 12);
        try {
            Module module = memory.dlopen(filename, false);
            pointer = pointer.share(-4L, 0L);
            if (module == null) {
                pointer.setInt(0L, 0);
                pointer = pointer.share(-4L, 0L);
                pointer.setInt(0L, 0);
                if (!"libnetd_client.so".equals(filename)) {
                    log.info("dlopen failed: " + filename + ", LR=" + emulator.getContext().getLRPointer());
                } else if (log.isDebugEnabled()) {
                    log.debug("dlopen failed: " + filename);
                }
                this.error.setString(0L, "Resolve library " + filename + " failed");
                long l = 0L;
                return l;
            }
            pointer.setInt(0L, (int)module.base);
            pointer = pointer.share(-4L, 0L);
            pointer.setInt(0L, 0);
            LinuxModule m = (LinuxModule)module;
            if (m.getUnresolvedSymbol().isEmpty()) {
                for (InitFunction initFunction : m.initFunctionList) {
                    long address = initFunction.getAddress();
                    if (address == 0L) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("[" + m.name + "]PushInitFunction: 0x" + Long.toHexString(address));
                    }
                    pointer = pointer.share(-4L, 0L);
                    pointer.setInt(0L, (int)address);
                }
                m.initFunctionList.clear();
            }
            long l = module.base;
            return l;
        }
        finally {
            this.backend.reg_write(12, pointer.peer);
        }
    }

    private int dlclose(Memory memory, long handle) {
        if (memory.dlclose(handle)) {
            return 0;
        }
        this.error.setString(0L, "dlclose 0x" + Long.toHexString(handle) + " failed");
        return -1;
    }
}

