/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.android.dvm.ArmVarArg32;
import com.github.unidbg.linux.android.dvm.ArmVarArg64;
import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmMethod;
import com.github.unidbg.linux.android.dvm.VarArg;
import com.github.unidbg.pointer.UnidbgPointer;

public abstract class ArmVarArg
extends VarArg {
    protected final Emulator<?> emulator;
    private static final int REG_OFFSET = 3;

    static VarArg create(Emulator<?> emulator, BaseVM vm, DvmMethod method) {
        return emulator.is64Bit() ? new ArmVarArg64(emulator, vm, method) : new ArmVarArg32(emulator, vm, method);
    }

    protected ArmVarArg(Emulator<?> emulator, BaseVM vm, DvmMethod method) {
        super(vm, method);
        this.emulator = emulator;
    }

    protected final UnidbgPointer getArg(int index) {
        return this.emulator.getContext().getPointerArg(3 + index);
    }

    protected final int getInt(int index) {
        UnidbgPointer ptr = this.getArg(index);
        return ptr == null ? 0 : ptr.toIntPeer();
    }
}

