/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import java.lang.reflect.Array;

public class Shorty {
    private final int arrayDimensions;
    private final char type;
    private String binaryName;

    Shorty(int arrayDimensions, char type) {
        this.arrayDimensions = arrayDimensions;
        this.type = type;
    }

    final void setBinaryName(String binaryName) {
        this.binaryName = binaryName;
    }

    public char getType() {
        return this.arrayDimensions > 0 ? (char)'L' : (char)this.type;
    }

    private static Class<?> getPrimitiveType(char c) {
        switch (c) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
        }
        return null;
    }

    public Class<?> decodeType(ClassLoader classLoader) {
        Class<?> clazz;
        if (classLoader == null) {
            classLoader = Shorty.class.getClassLoader();
        }
        if ((clazz = Shorty.getPrimitiveType(this.getType())) != null) {
            return clazz;
        }
        int dimensions = this.arrayDimensions;
        if (dimensions > 0) {
            try {
                Class<?> clazz2 = clazz = this.binaryName == null ? Shorty.getPrimitiveType(this.type) : classLoader.loadClass(this.binaryName.replace('/', '.'));
                if (clazz == null) {
                    throw new IllegalStateException("type=" + this.type);
                }
                while (dimensions-- > 0) {
                    clazz = Array.newInstance(clazz, 1).getClass();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        if (this.binaryName == null) {
            throw new IllegalStateException("binaryName is null");
        }
        try {
            clazz = classLoader.loadClass(this.binaryName.replace('/', '.'));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.arrayDimensions; ++i) {
            sb.append('[');
        }
        sb.append(this.type);
        if (this.binaryName != null) {
            sb.append(this.binaryName).append(';');
        }
        return sb.toString();
    }
}

