/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmMethod;
import com.github.unidbg.linux.android.dvm.Shorty;
import com.github.unidbg.linux.android.dvm.VaList;
import com.github.unidbg.pointer.UnidbgPointer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class VaList32
extends VaList {
    private static final Log log = LogFactory.getLog(VaList32.class);

    VaList32(Emulator<?> emulator, BaseVM vm, UnidbgPointer va_list, DvmMethod method) {
        super(vm, method);
        UnidbgPointer pointer = va_list;
        block6: for (Shorty shorty : this.shorties) {
            switch (shorty.getType()) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'L': 
                case 'S': 
                case 'Z': {
                    this.args.add(pointer.getInt(0L));
                    pointer = pointer.share(4L, 0L);
                    continue block6;
                }
                case 'D': {
                    UnidbgPointer ptr = UnidbgPointer.pointer(emulator, pointer.toUIntPeer() + 7L & 0xFFFFFFF8L);
                    assert (ptr != null);
                    this.args.add(ptr.getDouble(0L));
                    pointer = ptr.share(8L, 0L);
                    continue block6;
                }
                case 'F': {
                    UnidbgPointer ptr = UnidbgPointer.pointer(emulator, pointer.toUIntPeer() + 7L & 0xFFFFFFF8L);
                    assert (ptr != null);
                    this.args.add(Float.valueOf((float)ptr.getDouble(0L)));
                    pointer = ptr.share(8L, 0L);
                    continue block6;
                }
                case 'J': {
                    UnidbgPointer ptr = UnidbgPointer.pointer(emulator, pointer.toUIntPeer() + 7L & 0xFFFFFFF8L);
                    assert (ptr != null);
                    this.args.add(ptr.getLong(0L));
                    pointer = ptr.share(8L, 0L);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("c=" + shorty.getType());
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("VaList64 args=" + method.args + ", shorty=" + Arrays.toString(this.shorties));
        }
    }
}

