/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmMethod;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.Shorty;
import java.util.ArrayList;
import java.util.List;

public abstract class VarArg {
    private final BaseVM vm;
    final List<Object> args;
    protected final DvmMethod method;
    protected Shorty[] shorties;

    protected VarArg(BaseVM vm, DvmMethod method) {
        this.vm = vm;
        this.shorties = method.decodeArgsShorty();
        this.method = method;
        this.args = new ArrayList<Object>(this.shorties.length);
    }

    public final <T extends DvmObject<?>> T getObjectArg(int index) {
        int hash = this.getIntArg(index);
        return this.vm.getObject(hash);
    }

    public final int getIntArg(int index) {
        return (Integer)this.args.get(index);
    }

    public final long getLongArg(int index) {
        return (Long)this.args.get(index);
    }

    public final float getFloatArg(int index) {
        return ((Float)this.args.get(index)).floatValue();
    }

    public final double getDoubleArg(int index) {
        return (Double)this.args.get(index);
    }

    final String formatArgs() {
        Shorty[] shorties = this.method.decodeArgsShorty();
        ArrayList<String> format = new ArrayList<String>(shorties.length);
        ArrayList<Comparable<Byte>> args = new ArrayList<Comparable<Byte>>(shorties.length);
        block11: for (int i = 0; i < shorties.length; ++i) {
            Shorty shorty = shorties[i];
            switch (shorty.getType()) {
                case 'B': {
                    format.add("%s");
                    args.add(Byte.valueOf((byte)this.getIntArg(i)));
                    continue block11;
                }
                case 'C': {
                    format.add("%c");
                    args.add(Character.valueOf((char)this.getIntArg(i)));
                    continue block11;
                }
                case 'I': {
                    format.add("0x%x");
                    args.add(Integer.valueOf(this.getIntArg(i)));
                    continue block11;
                }
                case 'S': {
                    format.add("%s");
                    args.add(Short.valueOf((short)this.getIntArg(i)));
                    continue block11;
                }
                case 'Z': {
                    format.add("%s");
                    args.add(Boolean.valueOf(BaseVM.valueOf(this.getIntArg(i))));
                    continue block11;
                }
                case 'F': {
                    format.add("%fF");
                    args.add(Float.valueOf(this.getFloatArg(i)));
                    continue block11;
                }
                case 'L': {
                    format.add("%s");
                    args.add((Comparable<Byte>)this.getObjectArg(i));
                    continue block11;
                }
                case 'D': {
                    format.add("%sD");
                    args.add(Double.valueOf(this.getDoubleArg(i)));
                    continue block11;
                }
                case 'J': {
                    format.add("0x%xL");
                    args.add(Long.valueOf(this.getLongArg(i)));
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("c=" + shorty.getType());
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        if (!format.isEmpty()) {
            sb.append((String)format.remove(0));
        }
        for (String str : format) {
            sb.append(", ").append(str);
        }
        return String.format(sb.toString(), args.toArray());
    }
}

