/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.api;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;

public class Bitmap
extends DvmObject<BufferedImage> {
    public Bitmap(VM vm, BufferedImage image) {
        super(vm.resolveClass("android/graphics/Bitmap", new DvmClass[0]), image);
    }

    public Pointer lockPixels(Emulator<?> emulator, BufferedImage image, ByteBuffer buffer) {
        UnidbgPointer pointer = this.allocateMemoryBlock(emulator, image.getWidth() * image.getHeight() * 4);
        ((Pointer)pointer).write(0L, buffer.array(), 0, buffer.capacity());
        return pointer;
    }

    public void unlockPixels() {
        this.freeMemoryBlock(null);
    }
}

