/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.linux.file.ByteArrayFileIO;
import com.github.unidbg.memory.MemRegion;
import com.github.unidbg.memory.MemoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapsFileIO
extends ByteArrayFileIO
implements FileIO {
    private static final Log log = LogFactory.getLog(MapsFileIO.class);

    public MapsFileIO(Emulator<?> emulator, int oflags, String path, Collection<Module> modules) {
        super(oflags, path, MapsFileIO.getMapsData(emulator, modules, null));
    }

    protected MapsFileIO(Emulator<?> emulator, int oflags, String path, Collection<Module> modules, String additionContent) {
        this(oflags, path, MapsFileIO.getMapsData(emulator, modules, additionContent));
    }

    protected MapsFileIO(int oflags, String path, byte[] bytes) {
        super(oflags, path, bytes);
    }

    protected static byte[] getMapsData(Emulator<?> emulator, Collection<Module> modules, String additionContent) {
        ArrayList<MemRegion> list = new ArrayList<MemRegion>(modules.size());
        for (Module module : modules) {
            list.addAll(module.getRegions());
        }
        Collections.sort(list);
        ArrayList<MapItem> items = new ArrayList<MapItem>();
        for (MemRegion memRegion : list) {
            items.add(new MapItem(memRegion.virtualAddress, memRegion.end, memRegion.perms, 0, "b3:19", memRegion.getName()));
        }
        long l = 256L * (long)emulator.getPageAlign();
        items.add(new MapItem(0xC0000000L - l, 0xC0000000L, 3, 0, "00:00", "[stack]"));
        ArrayList<MapItem> mapItems = new ArrayList<MapItem>();
        for (MemoryMap memoryMap : emulator.getMemory().getMemoryMap()) {
            boolean contains = false;
            for (MapItem item : items) {
                if (Math.max(memoryMap.base, item.start) > Math.min(memoryMap.base + memoryMap.size, item.end)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            mapItems.add(new MapItem(memoryMap.base, memoryMap.base + memoryMap.size, memoryMap.prot, 0, "00:00", "anonymous"));
        }
        items.addAll(mapItems);
        StringBuilder builder = new StringBuilder();
        for (MapItem item : items) {
            builder.append(item);
        }
        if (additionContent != null) {
            builder.append(additionContent).append('\n');
        }
        if (log.isDebugEnabled()) {
            log.debug("\n" + builder);
        }
        return builder.toString().getBytes();
    }

    @Override
    public int ioctl(Emulator<?> emulator, long request, long argp) {
        return 0;
    }

    private static class MapItem {
        private final long start;
        private final long end;
        private final int perms;
        private final int offset;
        private final String device;
        private final String label;

        public MapItem(long start, long end, int perms, int offset, String device, String label) {
            this.start = start;
            this.end = end;
            this.perms = perms;
            this.offset = offset;
            this.device = device;
            this.label = label;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("%08x-%08x", this.start, this.end)).append(' ');
            if ((this.perms & 1) != 0) {
                builder.append('r');
            } else {
                builder.append('-');
            }
            if ((this.perms & 2) != 0) {
                builder.append('w');
            } else {
                builder.append('-');
            }
            if ((this.perms & 4) != 0) {
                builder.append('x');
            } else {
                builder.append('-');
            }
            builder.append("p ");
            builder.append(String.format("%08x", this.offset));
            builder.append(" ").append(this.device).append(" 0");
            for (int i = 0; i < 10; ++i) {
                builder.append(' ');
            }
            builder.append(this.label);
            builder.append('\n');
            return builder.toString();
        }
    }
}

