/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.Emulator;
import com.github.unidbg.Utils;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.file.FileIO;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.file.linux.BaseAndroidFileIO;
import com.github.unidbg.file.linux.StatStructure;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleFileIO
extends BaseAndroidFileIO
implements NewFileIO {
    private static final Log log = LogFactory.getLog(SimpleFileIO.class);
    protected final File file;
    protected final String path;
    private RandomAccessFile _randomAccessFile;
    OutputStream debugStream;

    private synchronized RandomAccessFile checkOpenFile() {
        try {
            if (this._randomAccessFile == null) {
                FileUtils.forceMkdir(this.file.getParentFile());
                if (!this.file.exists() && !this.file.createNewFile()) {
                    throw new IOException("createNewFile failed: " + this.file);
                }
                this._randomAccessFile = new RandomAccessFile(this.file, "rws");
                this.onFileOpened(this._randomAccessFile);
            }
            return this._randomAccessFile;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public SimpleFileIO(int oflags, File file, String path) {
        super(oflags);
        this.file = file;
        this.path = path;
        if (file.isDirectory()) {
            throw new IllegalArgumentException("file is directory: " + file);
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("file not exists: " + file);
        }
    }

    void onFileOpened(RandomAccessFile randomAccessFile) throws IOException {
    }

    @Override
    public void close() {
        IOUtils.close(this._randomAccessFile);
        if (this.debugStream != null) {
            try {
                this.debugStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public int write(byte[] data2) {
        try {
            if (this.debugStream != null) {
                this.debugStream.write(data2);
                this.debugStream.flush();
            }
            if (log.isDebugEnabled() && data2.length < 12288) {
                Inspector.inspect(data2, "write");
            }
            RandomAccessFile randomAccessFile = this.checkOpenFile();
            if ((this.oflags & 0x400) != 0) {
                randomAccessFile.seek(randomAccessFile.length());
            }
            randomAccessFile.write(data2);
            return data2.length;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    void setDebugStream(OutputStream stream) {
        this.debugStream = new BufferedOutputStream(stream);
    }

    @Override
    public int read(Backend backend, Pointer pointer, int _count) {
        RandomAccessFile randomAccessFile = this.checkOpenFile();
        return Utils.readFile(randomAccessFile, pointer, _count);
    }

    @Override
    public int fstat(Emulator<?> emulator, StatStructure stat) {
        int st_mode = "stdout".equals(this.file.getName()) ? 10103 : (Files.isSymbolicLink(this.file.toPath()) ? 40960 : 32768);
        stat.st_dev = 1L;
        stat.st_mode = st_mode;
        stat.st_uid = 0;
        stat.st_gid = 0;
        stat.st_size = this.file.length();
        stat.st_blksize = emulator.getPageAlign();
        stat.st_ino = 1L;
        stat.st_blocks = (this.file.length() + (long)emulator.getPageAlign() - 1L) / (long)emulator.getPageAlign();
        stat.setLastModification(this.file.lastModified());
        stat.pack();
        return 0;
    }

    @Override
    protected byte[] getMmapData(long addr, int offset, int length) throws IOException {
        int count;
        RandomAccessFile randomAccessFile = this.checkOpenFile();
        randomAccessFile.seek(offset);
        int remaining = (int)(randomAccessFile.length() - randomAccessFile.getFilePointer());
        ByteArrayOutputStream baos = remaining <= 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(Math.min(length, remaining));
        byte[] buf = new byte[1024];
        while ((count = length - baos.size()) != 0) {
            int read;
            if (count > buf.length) {
                count = buf.length;
            }
            if ((read = randomAccessFile.read(buf, 0, count)) == -1) break;
            baos.write(buf, 0, read);
        }
        return baos.toByteArray();
    }

    public String toString() {
        return this.path;
    }

    @Override
    public int ioctl(Emulator<?> emulator, long request, long argp) {
        if ("stdout".equals(this.path) || "stderr".equals(this.path)) {
            return 0;
        }
        return super.ioctl(emulator, request, argp);
    }

    @Override
    public FileIO dup2() {
        SimpleFileIO dup = new SimpleFileIO(this.oflags, this.file, this.path);
        dup.debugStream = this.debugStream;
        dup.op = this.op;
        dup.oflags = this.oflags;
        return dup;
    }

    @Override
    public int lseek(int offset, int whence) {
        try {
            RandomAccessFile randomAccessFile = this.checkOpenFile();
            switch (whence) {
                case 0: {
                    randomAccessFile.seek(offset);
                    return (int)randomAccessFile.getFilePointer();
                }
                case 1: {
                    randomAccessFile.seek(randomAccessFile.getFilePointer() + (long)offset);
                    return (int)randomAccessFile.getFilePointer();
                }
                case 2: {
                    randomAccessFile.seek(randomAccessFile.length() + (long)offset);
                    return (int)randomAccessFile.getFilePointer();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return super.lseek(offset, whence);
    }

    @Override
    public int llseek(long offset, Pointer result, int whence) {
        try {
            RandomAccessFile randomAccessFile = this.checkOpenFile();
            switch (whence) {
                case 0: {
                    randomAccessFile.seek(offset);
                    result.setLong(0L, randomAccessFile.getFilePointer());
                    return 0;
                }
                case 2: {
                    randomAccessFile.seek(randomAccessFile.length() - offset);
                    result.setLong(0L, randomAccessFile.getFilePointer());
                    return 0;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return super.llseek(offset, result, whence);
    }

    @Override
    public int ftruncate(int length) {
        int n;
        block8: {
            FileChannel channel = new FileOutputStream(this.file, true).getChannel();
            try {
                channel.truncate(length);
                n = 0;
                if (channel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.debug("ftruncate failed", e);
                    return -1;
                }
            }
            channel.close();
        }
        return n;
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

