/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.struct;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.struct.IFReq32;
import com.github.unidbg.linux.struct.IFReq64;
import com.github.unidbg.pointer.UnidbgStructure;
import com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public abstract class IFReq
extends UnidbgStructure {
    static final int IFNAMSIZ = 16;
    public byte[] ifrn_name = new byte[16];

    public static IFReq createIFReq(Emulator<?> emulator, Pointer pointer) {
        return emulator.is64Bit() ? new IFReq64(pointer) : new IFReq32(pointer);
    }

    IFReq(Pointer p) {
        super(p);
    }

    public Pointer getAddrPointer() {
        return this.getPointer().share(16L);
    }

    public void setName(String name) {
        byte[] data2 = name.getBytes(StandardCharsets.UTF_8);
        if (data2.length >= 16) {
            throw new IllegalStateException("name=" + name);
        }
        this.ifrn_name = Arrays.copyOf(data2, 16);
    }
}

