/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.thread;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.thread.AndroidWaiter;
import com.github.unidbg.signal.SignalTask;
import com.github.unidbg.unix.struct.TimeSpec;
import com.sun.jna.Pointer;

public class NanoSleepWaiter
extends AndroidWaiter {
    private final Emulator<?> emulator;
    private final Pointer rem;
    private final long waitMillis;
    private final long startWaitTimeInMillis;
    private boolean onSignal;

    public NanoSleepWaiter(Emulator<?> emulator, Pointer rem, TimeSpec timeSpec) {
        this.emulator = emulator;
        this.rem = rem;
        this.waitMillis = timeSpec.toMillis();
        this.startWaitTimeInMillis = System.currentTimeMillis();
        if (this.waitMillis <= 0L) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void onSignal(SignalTask task) {
        super.onSignal(task);
        this.onSignal = true;
        if (this.rem != null) {
            TimeSpec timeSpec = TimeSpec.createTimeSpec(this.emulator, this.rem);
            long elapsed = System.currentTimeMillis() - this.startWaitTimeInMillis;
            timeSpec.setMillis(this.waitMillis - elapsed);
        }
    }

    @Override
    public void onContinueRun(Emulator<?> emulator) {
        super.onContinueRun(emulator);
        if (this.onSignal) {
            emulator.getBackend().reg_write(emulator.is32Bit() ? 66 : 199, -4);
        }
    }

    @Override
    public boolean canDispatch() {
        if (this.onSignal) {
            return true;
        }
        if (System.currentTimeMillis() - this.startWaitTimeInMillis >= this.waitMillis) {
            return true;
        }
        Thread.yield();
        return false;
    }
}

