/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.thread;

import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.signal.SigSet;
import com.github.unidbg.signal.SignalOps;
import com.github.unidbg.signal.SignalTask;
import com.github.unidbg.signal.UnixSigSet;
import com.github.unidbg.thread.MainTask;
import com.github.unidbg.thread.PopContextException;
import com.github.unidbg.thread.RunnableTask;
import com.github.unidbg.thread.Task;
import com.github.unidbg.thread.ThreadDispatcher;
import com.github.unidbg.thread.ThreadTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UniThreadDispatcher
implements ThreadDispatcher {
    private static final Log log = LogFactory.getLog(UniThreadDispatcher.class);
    private final List<Task> taskList = new ArrayList<Task>();
    private final AbstractEmulator<?> emulator;
    private final List<ThreadTask> threadTaskList = new ArrayList<ThreadTask>();
    private RunnableTask runningTask;
    private SigSet mainThreadSigMaskSet;
    private SigSet mainThreadSigPendingSet;

    public UniThreadDispatcher(AbstractEmulator<?> emulator) {
        this.emulator = emulator;
    }

    @Override
    public void addThread(ThreadTask task) {
        this.threadTaskList.add(task);
    }

    @Override
    public List<Task> getTaskList() {
        return this.taskList;
    }

    @Override
    public boolean sendSignal(int tid, int sig, SignalTask signalTask) {
        ArrayList<Task> list = new ArrayList<Task>();
        list.addAll(this.taskList);
        list.addAll(this.threadTaskList);
        boolean ret = false;
        for (Task task : list) {
            SignalOps signalOps = null;
            if (tid == 0 && task.isMainThread()) {
                signalOps = this;
            }
            if (tid == task.getId()) {
                signalOps = task;
            }
            if (signalOps == null) continue;
            SigSet sigSet = signalOps.getSigMaskSet();
            SigSet sigPendingSet = signalOps.getSigPendingSet();
            if (sigPendingSet == null) {
                sigPendingSet = new UnixSigSet(0L);
                signalOps.setSigPendingSet(sigPendingSet);
            }
            if (sigSet != null && sigSet.containsSigNumber(sig)) {
                sigPendingSet.addSigNumber(sig);
                return false;
            }
            if (signalTask != null) {
                task.addSignalTask(signalTask);
                if (log.isTraceEnabled()) {
                    this.emulator.attach().debug();
                }
            } else {
                sigPendingSet.addSigNumber(sig);
            }
            ret = true;
            break;
        }
        return ret;
    }

    @Override
    public RunnableTask getRunningTask() {
        return this.runningTask;
    }

    @Override
    public Number runMainForResult(MainTask main) {
        this.taskList.add(0, main);
        if (log.isDebugEnabled()) {
            log.debug("runMainForResult main=" + main);
        }
        Number ret = this.run(0L, null);
        Iterator<Task> iterator = this.taskList.iterator();
        while (iterator.hasNext()) {
            Task task = iterator.next();
            if (!task.isFinish()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Finish task=" + task);
            }
            task.destroy(this.emulator);
            iterator.remove();
            for (SignalTask signalTask : task.getSignalTaskList()) {
                signalTask.destroy(this.emulator);
                task.removeSignalTask(signalTask);
            }
        }
        return ret;
    }

    @Override
    public void runThreads(long timeout, TimeUnit unit) {
        if (timeout <= 0L || unit == null) {
            throw new IllegalArgumentException("Invalid timeout.");
        }
        this.run(timeout, unit);
    }

    private Number run(long timeout, TimeUnit unit) {
        try {
            long start = System.currentTimeMillis();
            while (true) {
                Number number;
                if (this.taskList.isEmpty()) {
                    throw new IllegalStateException();
                }
                Iterator<Task> iterator = this.taskList.iterator();
                while (iterator.hasNext()) {
                    Task task = iterator.next();
                    if (task.isFinish()) continue;
                    if (task.canDispatch()) {
                        block29: {
                            if (log.isDebugEnabled()) {
                                log.debug("Start dispatch task=" + task);
                            }
                            this.emulator.set(Task.TASK_KEY, task);
                            if (task.isContextSaved()) {
                                task.restoreContext(this.emulator);
                                for (SignalTask signalTask : task.getSignalTaskList()) {
                                    if (signalTask.canDispatch()) {
                                        if (log.isDebugEnabled()) {
                                            log.debug("Start run signalTask=" + signalTask);
                                        }
                                        SignalOps ops = task.isMainThread() ? this : task;
                                        try {
                                            this.runningTask = signalTask;
                                            Number ret = signalTask.callHandler(ops, this.emulator);
                                            if (log.isDebugEnabled()) {
                                                log.debug("End run signalTask=" + signalTask + ", ret=" + ret);
                                            }
                                            if (ret != null) {
                                                signalTask.setResult(this.emulator, ret);
                                                signalTask.destroy(this.emulator);
                                                task.removeSignalTask(signalTask);
                                                continue;
                                            }
                                            signalTask.saveContext(this.emulator);
                                        }
                                        catch (PopContextException e) {
                                            this.runningTask.popContext(this.emulator);
                                        }
                                        continue;
                                    }
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug("Skip call handler signalTask=" + signalTask);
                                }
                            }
                            this.runningTask = task;
                            Number ret = task.dispatch(this.emulator);
                            if (log.isDebugEnabled()) {
                                log.debug("End dispatch task=" + task + ", ret=" + ret);
                            }
                            if (ret == null) break block29;
                            task.setResult(this.emulator, ret);
                            task.destroy(this.emulator);
                            iterator.remove();
                            if (!task.isMainThread()) continue;
                            Number number2 = ret;
                            return number2;
                        }
                        try {
                            task.saveContext(this.emulator);
                        }
                        catch (PopContextException e) {
                            this.runningTask.popContext(this.emulator);
                        }
                        continue;
                    }
                    if (log.isTraceEnabled() && task.isContextSaved()) {
                        task.restoreContext(this.emulator);
                        log.trace("Skip dispatch task=" + task);
                        this.emulator.getUnwinder().unwind();
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Skip dispatch task=" + task);
                }
                Collections.reverse(this.threadTaskList);
                iterator = this.threadTaskList.iterator();
                while (iterator.hasNext()) {
                    this.taskList.add(0, iterator.next());
                    iterator.remove();
                }
                if (timeout > 0L && unit != null && System.currentTimeMillis() - start >= unit.toMillis(timeout)) {
                    number = null;
                    return number;
                }
                if (this.taskList.isEmpty()) {
                    number = null;
                    return number;
                }
                if (!log.isDebugEnabled()) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.runningTask = null;
            this.emulator.set(Task.TASK_KEY, null);
        }
    }

    @Override
    public int getTaskCount() {
        return this.taskList.size() + this.threadTaskList.size();
    }

    @Override
    public SigSet getSigMaskSet() {
        return this.mainThreadSigMaskSet;
    }

    @Override
    public void setSigMaskSet(SigSet sigMaskSet) {
        this.mainThreadSigMaskSet = sigMaskSet;
    }

    @Override
    public SigSet getSigPendingSet() {
        return this.mainThreadSigPendingSet;
    }

    @Override
    public void setSigPendingSet(SigSet sigPendingSet) {
        this.mainThreadSigPendingSet = sigPendingSet;
    }
}

