/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.unwind;

import com.github.unidbg.Emulator;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.unwind.Frame;
import com.github.unidbg.unwind.Unwinder;

public class SimpleARM64Unwinder
extends Unwinder {
    public SimpleARM64Unwinder(Emulator<?> emulator) {
        super(emulator);
    }

    @Override
    protected String getBaseFormat() {
        return "[0x%09x]";
    }

    @Override
    public Frame createFrame(UnidbgPointer ip, UnidbgPointer fp) {
        if (ip != null) {
            if (ip.peer == this.emulator.getReturnAddress()) {
                return new Frame(ip, null);
            }
            ip = ip.share(-4L, 0L);
            return new Frame(ip, fp);
        }
        return null;
    }

    private Frame initFrame(Emulator<?> emulator) {
        UnidbgPointer ip = UnidbgPointer.register(emulator, 2);
        UnidbgPointer fp = UnidbgPointer.register(emulator, 1);
        return this.createFrame(ip, fp);
    }

    @Override
    protected Frame unw_step(Emulator<?> emulator, Frame frame) {
        if (frame == null) {
            return this.initFrame(emulator);
        }
        if (frame.fp == null) {
            System.err.println("fp is null");
            return null;
        }
        UnidbgPointer ip = frame.fp.getPointer(8L);
        UnidbgPointer fp = frame.fp.getPointer(0L);
        return this.createFrame(ip, fp);
    }
}

