/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

class JarURL
implements AutoCloseable {
    final File jar;
    final String name;
    private final List<File> cleanupList;

    static JarURL create(URL url) {
        File jar;
        String path = url.getPath();
        int index = path.indexOf("!");
        if (index == -1) {
            throw new IllegalStateException(path);
        }
        String jarPath = path.substring(5, index);
        String name = path.substring(index + 2);
        try {
            jar = new File(URLDecoder.decode(jarPath, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("jarPath=" + jarPath);
        }
        ArrayList<File> cleanupList = new ArrayList<File>();
        while ((index = name.indexOf("!")) != -1) {
            String jarEntryName = name.substring(0, index);
            name = name.substring(index + 2);
            ZipEntry foundEntry = null;
            try (JarFile jarFile = new JarFile(jar);){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    String entryName = jarEntry.getName();
                    if (!jarEntryName.equals(entryName)) continue;
                    foundEntry = jarEntry;
                    break;
                }
                if (foundEntry == null || foundEntry.isDirectory()) {
                    throw new IllegalStateException("find failed: jar=" + jar + ", jarEntryName=" + jarEntryName + ", name=" + name + ", foundEntry=" + foundEntry);
                }
                jar = File.createTempFile(FilenameUtils.getName(jarEntryName), "");
                try (InputStream inputStream = jarFile.getInputStream(foundEntry);
                     FileOutputStream outputStream = new FileOutputStream(jar);){
                    IOUtils.copy(inputStream, (OutputStream)outputStream);
                }
                cleanupList.add(jar);
            }
            catch (IOException e) {
                throw new IllegalStateException(url.toString(), e);
            }
        }
        return new JarURL(jar, name, cleanupList);
    }

    private JarURL(File jar, String name, List<File> cleanupList) {
        this.jar = jar;
        this.name = name;
        this.cleanupList = cleanupList;
    }

    @Override
    public void close() {
        for (File file : this.cleanupList) {
            FileUtils.deleteQuietly(file);
        }
    }

    final JarEntry getJarEntry() {
        JarEntry jarEntry;
        JarEntry foundEntry = null;
        JarFile jarFile = new JarFile(this.jar);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry2 = entries.nextElement();
                String entryName = jarEntry2.getName();
                if (!this.name.equals(entryName) && !(this.name + "/").equals(entryName)) continue;
                foundEntry = jarEntry2;
                break;
            }
            if (foundEntry == null) {
                throw new IllegalStateException("find failed: jar=" + this.jar + ", name=" + this.name);
            }
            jarEntry = foundEntry;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("jar=" + this.jar, e);
            }
        }
        jarFile.close();
        return jarEntry;
    }
}

