/*
 * Decompiled with CFR 0.152.
 */
package com.ximalaya.com.ximalaya.ting.android.encryptservice;

import com.github.unidbg.AndroidEmulator;
import com.github.unidbg.Module;
import com.github.unidbg.arm.backend.DynarmicFactory;
import com.github.unidbg.arm.backend.HypervisorFactory;
import com.github.unidbg.arm.backend.KvmFactory;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.linux.android.AndroidEmulatorBuilder;
import com.github.unidbg.linux.android.AndroidResolver;
import com.github.unidbg.linux.android.dvm.AbstractJni;
import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DalvikModule;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.StringObject;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.VarArg;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.virtualmodule.android.AndroidModule;
import com.github.unidbg.virtualmodule.android.JniGraphics;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.UUID;

public class EncryptUtils
extends AbstractJni {
    public String ANDROID_ID;
    private final AndroidEmulator emulator;
    private final DvmClass cEncryptUtil;
    private final VM vm;
    private final HashMap<String, Object> sharedData = new HashMap();
    private final File binFile;
    private String deviceType;

    public EncryptUtils(String android_id, boolean debug, File soFile, File xcBin, String deviceType) {
        this.emulator = (AndroidEmulator)AndroidEmulatorBuilder.for64Bit().setProcessName("com.ximalaya.ting.android").addBackendFactory(new HypervisorFactory(true)).addBackendFactory(new DynarmicFactory(true)).addBackendFactory(new KvmFactory(true)).build();
        Memory memory = this.emulator.getMemory();
        memory.setLibraryResolver(new AndroidResolver(23, new String[0]));
        this.emulator.getSyscallHandler().setVerbose(debug);
        this.emulator.getSyscallHandler().setEnableThreadDispatcher(true);
        this.vm = this.emulator.createDalvikVM();
        this.vm.setVerbose(debug);
        this.vm.setJni(this);
        Module module = new JniGraphics(this.emulator, this.vm).register(memory);
        new AndroidModule(this.emulator, this.vm).register(memory);
        DalvikModule dm = this.vm.loadLibrary(soFile, true);
        dm.callJNI_OnLoad(this.emulator);
        this.cEncryptUtil = this.vm.resolveClass("com/ximalaya/ting/android/encryptservice/EncryptUtil", new DvmClass[0]);
        this.ANDROID_ID = android_id;
        this.binFile = xcBin;
        this.deviceType = deviceType;
    }

    @Override
    public boolean callStaticBooleanMethod(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        if ("com/ximalaya/ting/android/host/manager/configurecenter/ConfigureCenterUtil->shalledCheckDevice()Z".equals(signature)) {
            return true;
        }
        if ("android/text/TextUtils->isEmpty(Ljava/lang/CharSequence;)Z".equals(signature)) {
            StringObject data2 = (StringObject)varArg.getObjectArg(0);
            System.out.println("[Log] isEmpty(" + data2 + ")");
            return ((String)data2.getValue()).isEmpty();
        }
        return super.callStaticBooleanMethod(vm, dvmClass, signature, varArg);
    }

    @Override
    public int callStaticIntMethod(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        if ("android/os/Process->myPid()I".equals(signature)) {
            return this.emulator.getPid();
        }
        if ("android/os/Process->myUid()I".equals(signature)) {
            return this.emulator.getPid();
        }
        return super.callStaticIntMethod(vm, dvmClass, signature, varArg);
    }

    @Override
    public int callIntMethod(BaseVM vm, DvmObject<?> dvmObject, String signature, VarArg varArg) {
        if ("com/ximalaya/ting/android/encryptservice/EncryptUtil->checkPermission(Ljava/lang/String;II)I".equals(signature)) {
            StringObject p1 = (StringObject)varArg.getObjectArg(0);
            int p2 = varArg.getIntArg(1);
            int p3 = varArg.getIntArg(2);
            System.out.println("[Log] checkPermission(" + p1 + ", " + p2 + ", " + p3 + ")");
            return 1;
        }
        if ("java/io/DataInputStream->available()I".equals(signature)) {
            DataInputStream inputStream = (DataInputStream)dvmObject.getValue();
            try {
                return inputStream.available();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ("java/io/DataInputStream->skipBytes(I)I".equals(signature)) {
            DataInputStream inputStream = (DataInputStream)dvmObject.getValue();
            try {
                return inputStream.skipBytes(varArg.getIntArg(0));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ("java/io/DataInputStream->readInt()I".equals(signature)) {
            DataInputStream inputStream = (DataInputStream)dvmObject.getValue();
            try {
                return inputStream.readInt();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return super.callIntMethod(vm, dvmObject, signature, varArg);
    }

    @Override
    public DvmObject<?> callStaticObjectMethod(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        if ("com/ximalaya/ting/android/xmutil/BaseDeviceUtil->generateUUID(Landroid/content/Context;)Ljava/lang/String;".equals(signature)) {
            return new StringObject(vm, UUID.nameUUIDFromBytes(this.ANDROID_ID.getBytes()).toString());
        }
        if ("android/provider/Settings$Secure->getString(Landroid/content/ContentResolver;Ljava/lang/String;)Ljava/lang/String;".equals(signature)) {
            Object content = varArg.getObjectArg(0);
            StringObject data2 = (StringObject)varArg.getObjectArg(1);
            System.out.println("[Log] Setting(ContentResolver).getString(" + data2 + ")");
            if (((String)data2.getValue()).equals("android_id")) {
                return new StringObject(vm, this.ANDROID_ID);
            }
        }
        if ("com/ximalaya/ting/android/xmutil/BaseDeviceUtil->getIMEI(Landroid/content/Context;)Ljava/lang/String;".equals(signature)) {
            return new StringObject(vm, "");
        }
        if ("com/ximalaya/ting/android/xmutil/BaseDeviceUtil->getLocalMacAddress(Landroid/content/Context;)Ljava/lang/String;".equals(signature)) {
            return new StringObject(vm, "");
        }
        if ("com/ximalaya/ting/android/xmutil/BaseDeviceUtil->getDeviceType()Ljava/lang/String;".equals(signature)) {
            return new StringObject(vm, "0");
        }
        if ("java/lang/String->valueOf(J)Ljava/lang/String;".equals(signature)) {
            return new StringObject(vm, String.valueOf(varArg.getLongArg(0)));
        }
        return super.callStaticObjectMethod(vm, dvmClass, signature, varArg);
    }

    @Override
    public long callStaticLongMethod(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        if (signature.equals("java/lang/System->currentTimeMillis()J")) {
            return System.currentTimeMillis();
        }
        return super.callStaticLongMethod(vm, dvmClass, signature, varArg);
    }

    @Override
    public DvmObject<?> getStaticObjectField(BaseVM vm, DvmClass dvmClass, String signature) {
        if ("android/os/Build->SERIAL:Ljava/lang/String;".equals(signature)) {
            return new StringObject(vm, "unknown");
        }
        return super.getStaticObjectField(vm, dvmClass, signature);
    }

    @Override
    public DvmObject<?> newObject(BaseVM vm, DvmClass dvmClass, String signature, VarArg varArg) {
        if ("java/lang/StringBuilder-><init>(Ljava/lang/String;)V".equals(signature)) {
            System.out.println("[Log] creat a StringBuilder.");
            return vm.resolveClass("java/lang/StringBuilder", new DvmClass[0]).newObject(new StringBuilder(((DvmObject)varArg.getObjectArg(0)).getValue().toString()));
        }
        if ("java/io/DataInputStream-><init>(Ljava/io/InputStream;)V".equals(signature)) {
            return vm.resolveClass("java/io/DataInputStream", new DvmClass[0]).newObject(new DataInputStream((InputStream)((DvmObject)varArg.getObjectArg(0)).getValue()));
        }
        return super.newObject(vm, dvmClass, signature, varArg);
    }

    @Override
    public boolean callBooleanMethod(BaseVM vm, DvmObject<?> dvmObject, String signature, VarArg varArg) {
        if ("java/lang/String->equals(Ljava/lang/Object;)Z".equals(signature)) {
            StringObject data2 = (StringObject)varArg.getObjectArg(0);
            StringObject orgi = (StringObject)dvmObject;
            System.out.println("[Log] " + orgi + ".equals(" + data2 + ")");
            return ((String)data2.getValue()).equals(orgi.getValue());
        }
        return super.callBooleanMethod(vm, dvmObject, signature, varArg);
    }

    @Override
    public DvmObject<?> callObjectMethod(BaseVM vm, DvmObject<?> dvmObject, String signature, VarArg varArg) {
        StringObject key;
        if ("com/ximalaya/ting/android/encryptservice/EncryptUtil->getSharedPreferences(Ljava/lang/String;I)Landroid/content/SharedPreferences;".equals(signature)) {
            StringObject key2 = (StringObject)varArg.getObjectArg(0);
            int tag = varArg.getIntArg(1);
            System.out.println("[Log] getSharedPreference(" + key2 + ", " + tag + ")");
            return this.newInstance("android/content/SharedPreferences");
        }
        if ("android/content/SharedPreferences->getString(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;".equals(signature)) {
            key = (StringObject)varArg.getObjectArg(0);
            StringObject def = (StringObject)varArg.getObjectArg(1);
            System.out.println("[Log] SharedPreference.getString(" + key + ", " + def + ")");
            if (this.sharedData.containsKey(key.getValue())) {
                return new StringObject(vm, (String)this.sharedData.get(key.getValue()));
            }
            if ("DEVICE_TOKEN".equals(key.getValue())) {
                return def;
            }
            if ("X_U_I_D".equals(key.getValue())) {
                return def;
            }
        }
        if ("android/content/SharedPreferences->edit()Landroid/content/SharedPreferences$Editor;".equals(signature)) {
            return this.newInstance("android/content/SharedPreferences$Editor");
        }
        if ("android/content/SharedPreferences$Editor->putString(Ljava/lang/String;Ljava/lang/String;)Landroid/content/SharedPreferences$Editor;".equals(signature)) {
            key = (StringObject)varArg.getObjectArg(0);
            StringObject value = (StringObject)varArg.getObjectArg(1);
            System.out.println("[Log] SharedPreference.putString(" + key + ", " + value + ")");
            this.sharedData.put((String)key.getValue(), value.getValue());
            return dvmObject;
        }
        if ("com/ximalaya/ting/android/encryptservice/EncryptUtil->getContentResolver()Landroid/content/ContentResolver;".equals(signature)) {
            return this.newInstance("android/content/ContentResolver");
        }
        if ("java/lang/StringBuilder->append(Ljava/lang/String;)Ljava/lang/StringBuilder;".equals(signature)) {
            StringObject data2 = (StringObject)varArg.getObjectArg(0);
            if (((String)data2.getValue()).equals("3")) {
                ((StringBuilder)dvmObject.getValue()).append(this.deviceType);
            } else {
                ((StringBuilder)dvmObject.getValue()).append((String)data2.getValue());
            }
            System.out.println("[Log] append(" + data2 + ")");
            return dvmObject;
        }
        if ("java/lang/StringBuilder->toString()Ljava/lang/String;".equals(signature)) {
            String result = ((StringBuilder)dvmObject.getValue()).toString();
            System.out.println("[Log] toString('" + result + "')");
            return new StringObject(vm, result);
        }
        if ("com/ximalaya/ting/android/encryptservice/EncryptUtil->getAssets()Landroid/content/res/AssetManager;".equals(signature)) {
            return this.newInstance("android/content/res/AssetManager");
        }
        if ("android/content/res/AssetManager->open(Ljava/lang/String;)Ljava/io/InputStream;".equals(signature)) {
            StringObject resName = (StringObject)varArg.getObjectArg(0);
            System.out.println("[Log] AssetManager.open(" + resName + ")");
            if ("drawable/x_z.png".equals(resName.getValue())) {
                try {
                    InputStream inputStream = Files.newInputStream(this.binFile.toPath(), new OpenOption[0]);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    bufferedInputStream.mark(0);
                    return vm.resolveClass("java/io/InputStream", new DvmClass[0]).newObject(bufferedInputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return super.callObjectMethod(vm, dvmObject, signature, varArg);
    }

    @Override
    public void callVoidMethod(BaseVM vm, DvmObject<?> dvmObject, String signature, VarArg varArg) {
        if ("android/content/SharedPreferences$Editor->apply()V".equals(signature)) {
            return;
        }
        if ("java/io/DataInputStream->reset()V".equals(signature)) {
            DataInputStream inputStream = (DataInputStream)dvmObject.getValue();
            try {
                inputStream.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
                vm.throwException(vm.resolveClass("java.io.IOException", new DvmClass[0]).newObject(e));
            }
            return;
        }
        if ("java/io/DataInputStream->readFully([B)V".equals(signature)) {
            DataInputStream inputStream = (DataInputStream)dvmObject.getValue();
            byte[] data2 = (byte[])((DvmObject)varArg.getObjectArg(0)).getValue();
            try {
                inputStream.readFully(data2);
            }
            catch (IOException e) {
                e.printStackTrace();
                vm.throwException(vm.resolveClass("java.io.IOException", new DvmClass[0]).newObject(e));
            }
            return;
        }
        if ("java/io/DataInputStream->close()V".equals(signature)) {
            DataInputStream inputStream = (DataInputStream)dvmObject.getValue();
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                vm.throwException(vm.resolveClass("java.io.IOException", new DvmClass[0]).newObject(e));
            }
            return;
        }
        super.callVoidMethod(vm, dvmObject, signature, varArg);
    }

    @Override
    public int getStaticIntField(BaseVM vm, DvmClass dvmClass, String signature) {
        if ("android/os/Build$VERSION->SDK_INT:I".equals(signature)) {
            return 23;
        }
        return super.getStaticIntField(vm, dvmClass, signature);
    }

    public void destroy() throws IOException {
        this.emulator.close();
    }

    public void setXUID(String xuid) {
        this.sharedData.put("X_U_I_D", xuid);
    }

    public String getXD() {
        String methodSign = "ktlWxSBwbU(Landroid/content/Context;)Ljava/lang/String;";
        DvmObject<AndroidFileIO> EncryptUtilsObject = this.cEncryptUtil.newObject(new HashMap());
        DvmObject<?> ContentObject = this.newInstance("android/tencent/Context");
        StringObject obj = (StringObject)EncryptUtilsObject.callJniMethodObject(this.emulator, methodSign, EncryptUtilsObject, ContentObject);
        return (String)obj.getValue();
    }

    public DvmObject<?> newInstance(String className) {
        DvmClass clz = this.vm.resolveClass(className, new DvmClass[0]);
        return clz.newObject(new HashMap());
    }

    public static void main(String[] args) throws Exception {
        EncryptUtils encryptUtils = new EncryptUtils("4580e36b627a8d6c", true, new File("unidbg-android/src/test/resources/example_binaries/ximalaya/libencrypt.so"), new File("unidbg-android/src/test/resources/example_binaries/ximalaya/x_z.bin"), "0");
        System.out.println("XD = " + encryptUtils.getXD());
        encryptUtils.destroy();
    }
}

