/*
 * Decompiled with CFR 0.152.
 */
package de.fearlesstobi.demangler.ast;

import de.fearlesstobi.demangler.ast.BaseNode;
import de.fearlesstobi.demangler.ast.NodeType;
import de.fearlesstobi.demangler.ast.ParentNode;
import java.io.StringWriter;

public class CvType
extends ParentNode {
    private final int qualifier;

    public CvType(int qualifier, BaseNode child) {
        super(NodeType.CvQualifierType, child);
        this.qualifier = qualifier;
    }

    private void PrintQualifier(StringWriter writer) {
        if ((this.qualifier & 1) != 0) {
            writer.write(" const");
        }
        if ((this.qualifier & 2) != 0) {
            writer.write(" volatile");
        }
        if ((this.qualifier & 4) != 0) {
            writer.write(" restrict");
        }
    }

    @Override
    public void printLeft(StringWriter writer) {
        if (this.child != null) {
            this.child.printLeft(writer);
        }
        this.PrintQualifier(writer);
    }

    @Override
    public boolean hasRightPart() {
        return this.child != null && this.child.hasRightPart();
    }

    @Override
    public void printRight(StringWriter writer) {
        if (this.child != null) {
            this.child.printRight(writer);
        }
    }

    public class Cv {
        public static final int None = 0;
        public static final int Const = 1;
        public static final int Volatile = 2;
        public static final int Restricted = 4;
    }
}

