/*
 * Decompiled with CFR 0.152.
 */
package de.fearlesstobi.demangler.ast;

import de.fearlesstobi.demangler.ast.BaseNode;
import de.fearlesstobi.demangler.ast.NodeType;
import java.io.StringWriter;

public class FoldExpression
extends BaseNode {
    private final boolean isLeftFold;
    private final String operatorName;
    private final BaseNode expression;
    private final BaseNode initializer;

    public FoldExpression(boolean isLeftFold, String operatorName, BaseNode expression, BaseNode initializer) {
        super(NodeType.FunctionParameter);
        this.isLeftFold = isLeftFold;
        this.operatorName = operatorName;
        this.expression = expression;
        this.initializer = initializer;
    }

    @Override
    public void printLeft(StringWriter writer) {
        writer.write("(");
        if (this.isLeftFold && this.initializer != null) {
            this.initializer.print(writer);
            writer.write(" ");
            writer.write(this.operatorName);
            writer.write(" ");
        }
        writer.write(this.isLeftFold ? "... " : " ");
        writer.write(this.operatorName);
        writer.write(!this.isLeftFold ? " ..." : " ");
        this.expression.print(writer);
        if (!this.isLeftFold && this.initializer != null) {
            this.initializer.print(writer);
            writer.write(" ");
            writer.write(this.operatorName);
            writer.write(" ");
        }
        writer.write(")");
    }
}

