/*
 * Decompiled with CFR 0.152.
 */
package de.fearlesstobi.demangler.ast;

import de.fearlesstobi.demangler.ast.BaseNode;
import de.fearlesstobi.demangler.ast.NodeType;
import de.fearlesstobi.demangler.ast.SimpleReferenceType;
import java.io.StringWriter;

public class FunctionType
extends BaseNode {
    private final BaseNode returnType;
    private final BaseNode params;
    private final BaseNode cvQualifier;
    private final SimpleReferenceType referenceQualifier;
    private final BaseNode exceptionSpec;

    public FunctionType(BaseNode returnType, BaseNode params, BaseNode cvQualifier, SimpleReferenceType referenceQualifier, BaseNode exceptionSpec) {
        super(NodeType.FunctionType);
        this.returnType = returnType;
        this.params = params;
        this.cvQualifier = cvQualifier;
        this.referenceQualifier = referenceQualifier;
        this.exceptionSpec = exceptionSpec;
    }

    @Override
    public void printLeft(StringWriter writer) {
        this.returnType.printLeft(writer);
        writer.write(" ");
    }

    @Override
    public void printRight(StringWriter writer) {
        writer.write("(");
        this.params.print(writer);
        writer.write(")");
        this.returnType.printRight(writer);
        this.cvQualifier.print(writer);
        if (this.referenceQualifier.qualifier != 0) {
            writer.write(" ");
            this.referenceQualifier.PrintQualifier(writer);
        }
        if (this.exceptionSpec != null) {
            writer.write(" ");
            this.exceptionSpec.print(writer);
        }
    }

    @Override
    public boolean hasRightPart() {
        return true;
    }

    @Override
    public boolean hasFunctions() {
        return true;
    }
}

