/*
 * Decompiled with CFR 0.152.
 */
package moe.fuqiuluo.unidbg.vm;

import com.github.unidbg.AndroidEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.EmulatorBuilder;
import com.github.unidbg.arm.backend.DynarmicFactory;
import com.github.unidbg.arm.backend.Unicorn2Factory;
import com.github.unidbg.linux.android.AndroidEmulatorBuilder;
import com.github.unidbg.linux.android.dvm.DalvikModule;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.spi.SyscallHandler;
import com.github.unidbg.virtualmodule.android.AndroidModule;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import top.mrxiaom.qsign.QSignService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J'\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u001a\"\u00020\u0017\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lmoe/fuqiuluo/unidbg/vm/AndroidVM;", "Ljava/io/Closeable;", "packageName", "", "dynarmic", "", "unicorn", "(Ljava/lang/String;ZZ)V", "emulator", "Lcom/github/unidbg/AndroidEmulator;", "getEmulator$qsign", "()Lcom/github/unidbg/AndroidEmulator;", "memory", "Lcom/github/unidbg/memory/Memory;", "getMemory", "()Lcom/github/unidbg/memory/Memory;", "vm", "Lcom/github/unidbg/linux/android/dvm/VM;", "getVm$qsign", "()Lcom/github/unidbg/linux/android/dvm/VM;", "close", "", "findClass", "Lcom/github/unidbg/linux/android/dvm/DvmClass;", "name", "interfaces", "", "(Ljava/lang/String;[Lcom/github/unidbg/linux/android/dvm/DvmClass;)Lcom/github/unidbg/linux/android/dvm/DvmClass;", "loadLibrary", "Lcom/github/unidbg/linux/android/dvm/DalvikModule;", "soFile", "Ljava/io/File;", "qsign"})
public class AndroidVM
implements Closeable {
    @NotNull
    private final AndroidEmulator emulator;
    @NotNull
    private final Memory memory;
    @NotNull
    private final VM vm;

    /*
     * WARNING - void declaration
     */
    public AndroidVM(@NotNull String packageName, boolean dynarmic, boolean unicorn) {
        void $this$emulator_u24lambda_u240;
        EmulatorBuilder emulatorBuilder;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        EmulatorBuilder emulatorBuilder2 = emulatorBuilder = AndroidEmulatorBuilder.for64Bit().setProcessName(packageName);
        AndroidVM androidVM = this;
        boolean bl = false;
        if (dynarmic) {
            $this$emulator_u24lambda_u240.addBackendFactory(new DynarmicFactory(true));
        }
        if (unicorn) {
            $this$emulator_u24lambda_u240.addBackendFactory(new Unicorn2Factory(true));
        }
        Object t = emulatorBuilder.build();
        Intrinsics.checkNotNull(t);
        androidVM.emulator = (AndroidEmulator)t;
        Memory memory = this.emulator.getMemory();
        Intrinsics.checkNotNull((Object)memory);
        this.memory = memory;
        VM vM = this.emulator.createDalvikVM();
        Intrinsics.checkNotNull((Object)vM);
        this.vm = vM;
        this.vm.setVerbose(QSignService.Factory.Companion.getCONFIG().getUnidbg().getDebug());
        SyscallHandler syscall = this.emulator.getSyscallHandler();
        syscall.setVerbose(QSignService.Factory.Companion.getCONFIG().getUnidbg().getDebug());
        syscall.setEnableThreadDispatcher(true);
        new AndroidModule((Emulator)this.emulator, this.vm).register(this.memory);
    }

    @NotNull
    public final AndroidEmulator getEmulator$qsign() {
        return this.emulator;
    }

    @NotNull
    protected final Memory getMemory() {
        return this.memory;
    }

    @NotNull
    public final VM getVm$qsign() {
        return this.vm;
    }

    @NotNull
    public final DalvikModule loadLibrary(@NotNull File soFile) {
        Intrinsics.checkNotNullParameter((Object)soFile, (String)"soFile");
        DalvikModule dm = this.vm.loadLibrary(soFile, false);
        dm.callJNI_OnLoad(this.emulator);
        Intrinsics.checkNotNullExpressionValue((Object)dm, (String)"dm");
        return dm;
    }

    @NotNull
    public final DvmClass findClass(@NotNull String name, DvmClass ... interfaces) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)interfaces, (String)"interfaces");
        DvmClass dvmClass = this.vm.resolveClass(name, Arrays.copyOf(interfaces, interfaces.length));
        Intrinsics.checkNotNullExpressionValue((Object)dvmClass, (String)"vm.resolveClass(name, *interfaces)");
        return dvmClass;
    }

    @Override
    public void close() {
        this.emulator.close();
    }
}

