/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import net.dongliu.apk.parser.ApkFile;
import net.dongliu.apk.parser.ByteArrayApkFile;
import net.dongliu.apk.parser.bean.ApkMeta;

public class ApkParsers {
    private static boolean useBouncyCastle;

    public static boolean useBouncyCastle() {
        return useBouncyCastle;
    }

    public static void useBouncyCastle(boolean useBouncyCastle) {
        ApkParsers.useBouncyCastle = useBouncyCastle;
    }

    public static ApkMeta getMetaInfo(String apkFilePath) throws IOException {
        try (ApkFile apkFile = new ApkFile(apkFilePath);){
            ApkMeta apkMeta = apkFile.getApkMeta();
            return apkMeta;
        }
    }

    public static ApkMeta getMetaInfo(File file) throws IOException {
        try (ApkFile apkFile = new ApkFile(file);){
            ApkMeta apkMeta = apkFile.getApkMeta();
            return apkMeta;
        }
    }

    public static ApkMeta getMetaInfo(byte[] apkData) throws IOException {
        try (ByteArrayApkFile apkFile = new ByteArrayApkFile(apkData);){
            ApkMeta apkMeta = apkFile.getApkMeta();
            return apkMeta;
        }
    }

    public static ApkMeta getMetaInfo(String apkFilePath, Locale locale) throws IOException {
        try (ApkFile apkFile = new ApkFile(apkFilePath);){
            apkFile.setPreferredLocale(locale);
            ApkMeta apkMeta = apkFile.getApkMeta();
            return apkMeta;
        }
    }

    public static ApkMeta getMetaInfo(File file, Locale locale) throws IOException {
        try (ApkFile apkFile = new ApkFile(file);){
            apkFile.setPreferredLocale(locale);
            ApkMeta apkMeta = apkFile.getApkMeta();
            return apkMeta;
        }
    }

    public static ApkMeta getMetaInfo(byte[] apkData, Locale locale) throws IOException {
        try (ByteArrayApkFile apkFile = new ByteArrayApkFile(apkData);){
            apkFile.setPreferredLocale(locale);
            ApkMeta apkMeta = apkFile.getApkMeta();
            return apkMeta;
        }
    }

    public static String getManifestXml(String apkFilePath) throws IOException {
        try (ApkFile apkFile = new ApkFile(apkFilePath);){
            String string = apkFile.getManifestXml();
            return string;
        }
    }

    public static String getManifestXml(File file) throws IOException {
        try (ApkFile apkFile = new ApkFile(file);){
            String string = apkFile.getManifestXml();
            return string;
        }
    }

    public static String getManifestXml(byte[] apkData) throws IOException {
        try (ByteArrayApkFile apkFile = new ByteArrayApkFile(apkData);){
            String string = apkFile.getManifestXml();
            return string;
        }
    }

    public static String getManifestXml(String apkFilePath, Locale locale) throws IOException {
        try (ApkFile apkFile = new ApkFile(apkFilePath);){
            apkFile.setPreferredLocale(locale);
            String string = apkFile.getManifestXml();
            return string;
        }
    }

    public static String getManifestXml(File file, Locale locale) throws IOException {
        try (ApkFile apkFile = new ApkFile(file);){
            apkFile.setPreferredLocale(locale);
            String string = apkFile.getManifestXml();
            return string;
        }
    }

    public static String getManifestXml(byte[] apkData, Locale locale) throws IOException {
        try (ByteArrayApkFile apkFile = new ByteArrayApkFile(apkData);){
            apkFile.setPreferredLocale(locale);
            String string = apkFile.getManifestXml();
            return string;
        }
    }
}

