package com.naivete.framework.admin.boot.config;

import com.naivete.framework.admin.boot.model.AuthInfoDO;
import com.naivete.framework.admin.boot.model.FunctionDO;
import com.naivete.framework.admin.boot.model.RoleDO;
import com.naivete.framework.admin.boot.model.UserDO;
import com.naivete.framework.admin.boot.service.AuthInfoService;
import com.naivete.framework.common.dao.Result;
import org.apache.shiro.authc.*;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.util.HashSet;
import java.util.Set;

/**
 * realm实现类,用于实现具体的验证和授权方法
 *
 * @author Bean
 */
public class ShiroRealm extends AuthorizingRealm {

    // 打印日志
    private static Logger logger = LoggerFactory.getLogger(ShiroRealm.class);

    @Resource
    private AuthInfoService adminAuthInfoService;

    /**
     * 方面用于加密 参数：AuthenticationToken是从表单穿过来封装好的对象
     */
    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        logger.info("doGetAuthenticationInfo:" + token);

        // 将AuthenticationToken强转为AuthenticationToken对象
        UsernamePasswordToken userToken = (UsernamePasswordToken) token;

        // 获得从表单传过来的用户名，密码
        String username = userToken.getUsername();
        String password = new String(userToken.getPassword());

        Result<UserDO> loginResult = adminAuthInfoService.login(username, password);

        // 如果用户不存在，抛此异常
        if (!loginResult.isSuccess()) {
            throw new UnknownAccountException(loginResult.getErrorMessage());
        }

        // 认证成功
        return new SimpleAuthenticationInfo(loginResult.getData(), password, username);
    }

    // 用于授权
    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        logger.info("ShiroRealm的doGetAuthorizationInfo授权方法执行");

        // 从PrincipalCollection中获得用户信息
        String username = (String) principals.getPrimaryPrincipal();
        logger.info("ShiroRealm  AuthorizationInfo:" + username);

        Result<AuthInfoDO> authResult = adminAuthInfoService.queryAuthInfoByUserCode(username);
        AuthInfoDO authInfo = authResult.getData();

        // 根据用户名来查询数据库赋予用户角色,权限（查数据库）
        Set<String> roles = new HashSet<>();
        for (RoleDO role : authInfo.getRoleList()) {
            roles.add(role.getRoleCode());
        }
        Set<String> permissions = new HashSet<>();
        for (FunctionDO function : authInfo.getFunctionList()) {
            roles.add(function.getCode());
        }

        // 添加角色，权限
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo(roles);
        info.setStringPermissions(permissions);
        return info;
    }

}
