package com.naivete.framework.admin.boot.controller;

import com.naivete.framework.admin.boot.constants.FunctionTypeConstants;
import com.naivete.framework.admin.boot.model.*;
import com.naivete.framework.admin.boot.service.FunctionService;
import com.naivete.framework.admin.boot.service.UserService;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * IndexController
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/11 1:25
 **/
@RestController("adminIndexController")
@RequestMapping("/index")
public class IndexController {

    // 日志
    private final static Logger logger = LoggerFactory.getLogger(IndexController.class);

    @Resource
    private FunctionService adminFunctionService;
    @Resource
    private UserService adminUserService;

    /**
     * 初始化菜单
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:27
     **/
    @RequestMapping(value = "/initMenu", method = RequestMethod.GET)
    public Object initMenu(HttpServletRequest request) {
        ResultList<FunctionDO> result = new ResultList<>();
        try {
            String userCode = (String) request.getSession().getAttribute("userCode");
            ResultList<FunctionDO> resultList = adminFunctionService.queryListByUserCode(userCode);
            List<FunctionDO> functionList = (List<FunctionDO>) resultList.getDatalist();
            List<FunctionDO> list = new ArrayList<>();
            for (FunctionDO function : functionList) {
                if (!function.getType().equals(FunctionTypeConstants.BUTTON.name())) {
                    list.add(function);
                }
            }
            result.setDatalist(list);
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("加载菜单异常：" + e.getMessage());
            logger.error(result.getErrorMessage());
        }
        return result;
    }

    /**
     * 初始化个人信息
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:27
     **/
    @RequestMapping(value = "/initUser", method = RequestMethod.POST)
    public Object initUser(HttpServletRequest request) {
        Result<UserDO> result = new Result<>();
        try {
            String userCode = (String) request.getSession().getAttribute("userCode");
            Result<UserDO> queryResult = adminUserService.queryByUserCode(userCode);
            if (queryResult.isSuccess() && null != queryResult.getData()) {
                UserDO user = queryResult.getData();
                user.setId(null);
                user.setPassword(null);
                result.setData(user);
            }
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("初始化个人信息异常：" + e.getMessage());
            logger.error(result.getErrorMessage());
        }
        return result;
    }

}
