package com.naivete.framework.admin.boot.controller;

import com.naivete.framework.admin.boot.constants.FunctionTypeConstants;
import com.naivete.framework.admin.boot.model.*;
import com.naivete.framework.admin.boot.service.FunctionService;
import com.naivete.framework.common.constant.MargicNumberConstants;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * 菜单管理Controller
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/11 1:25
 **/
@RestController("adminMenuController")
@RequestMapping("/menu")
public class MenuController {

    // 日志
    private final static Logger logger = LoggerFactory.getLogger(MenuController.class);

    @Resource
    private FunctionService adminFunctionService;

    /**
     * 加载功能树，菜单管理与角色管理页面公用功能树
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:26
     **/
    @RequestMapping(value = "/getMenuTree", method = RequestMethod.GET)
    public Object getMenuTree(HttpServletRequest request) {
        List<MenuTree> tree = new ArrayList<>();
        /** 查询选中的角色所拥有的功能 **/
        List<String> funs = getFunByRole(request);
        /** 查询所有的功能 **/
        ResultList<FunctionDO> functionResult = adminFunctionService.queryAll();
        if (!functionResult.isSuccess() || CollectionUtils.isEmpty(functionResult.getDatalist())) {
            return tree;
        }
        /** 组装功能树 **/
        List<FunctionDO> list = (List<FunctionDO>) functionResult.getDatalist();
        for (FunctionDO function : list) {
            MenuTree menuTree = new MenuTree();
            menuTree.setText(function.getName());
            menuTree.initState(Boolean.TRUE, funs.contains(function.getCode()) ? Boolean.TRUE : Boolean.FALSE);
            menuTree.setId(function.getCode());
            menuTree.setIcon(function.getType().equals(FunctionTypeConstants.FOLDER.name()) ? null : "none");
            menuTree.initData(function.getCode(), function.getName(), function.getParentCode(), function.getParentName(), function.getUrl(), function.getType(), function.getRemark(), function.getLevel(), function.getIcon());
            menuTree.setChildren(new ArrayList<>());
            tree.add(menuTree);
        }
        return buildTree(tree, "0");
    }

    /**
     * 根据角色编码查询功能列表
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:26
     **/
    private List<String> getFunByRole(HttpServletRequest request) {
        String roleCode = request.getParameter("roleCode");
        List<String> list = new ArrayList<>();
        if (StringUtils.isBlank(roleCode)) {
            return list;
        }
        ResultList<FunctionDO> directChildFun = adminFunctionService.queryListByRoleCode(roleCode);
        List<FunctionDO> datalist = (List<FunctionDO>) directChildFun.getDatalist();
        for (FunctionDO item : datalist) {
            if (item.getCode() != null) {
                list.add(item.getCode());
            }
        }
        return list;
    }

    /**
     * 递归构建菜单树
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:26
     **/
    public List<MenuTree> buildTree(List<MenuTree> list, String parentCode) {
        List<MenuTree> menus = new ArrayList<>();
        for (MenuTree menu : list) {
            if (menu.getDataParentCode().equals(parentCode)) {
                List<MenuTree> menuLists = buildTree(list, menu.getDataCode());
                menu.setChildren(menuLists);
                menus.add(menu);
            }
        }
        return menus;
    }

    /**
     * 为新功能分配一个编码
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:26
     **/
    @RequestMapping(value = "/assginCode", method = RequestMethod.GET)
    public Object assginCode(HttpServletRequest request) {
        String parentCode = request.getParameter("parentCode");
        ResultList<FunctionDO> directChildFun = adminFunctionService.queryChildFun(parentCode);
        List<FunctionDO> datalist = (List<FunctionDO>) directChildFun.getDatalist();
        List<String> list = new ArrayList<>();
        for (FunctionDO item : datalist) {
            if (item.getCode() != null) {
                list.add(item.getCode());
            }
        }
        List<String> tmp = new ArrayList<>();
        for (int i = 1; i <= MargicNumberConstants.n99; i++) {
            if (i < MargicNumberConstants.n10) {
                if ("0".equals(parentCode)) {
                    tmp.add("0" + i);
                } else {
                    tmp.add(parentCode + "0" + i);
                }
            } else {
                if ("0".equals(parentCode)) {
                    tmp.add(i + "");
                } else {
                    tmp.add(parentCode + i + "");
                }
            }
        }
        for (String item : tmp) {
            if (!list.contains(item)) {
                Result<String> result = new Result<>();
                result.setData(item);
                return result;
            }
        }
        return null;
    }

    /**
     * 加载子功能
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:26
     **/
    @RequestMapping(value = "/lodSubFun", method = RequestMethod.GET)
    public Object lodSubFun(HttpServletRequest request) {
        String parentCode = request.getParameter("parentCode");
        ResultList<FunctionDO> directChildFun = adminFunctionService.queryChildFun(parentCode);
        List<FunctionDO> list = (List<FunctionDO>) directChildFun.getDatalist();
        for (FunctionDO function : list) {
            function.setType(FunctionTypeConstants.getEnum(FunctionTypeConstants.class, function.getType()).getCname());
        }
        return list;
    }

    /**
     * 保存
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:27
     **/
    @RequestMapping(value = "/saveFun", method = RequestMethod.POST)
    public Object saveFun(HttpServletRequest request, FunctionDO fun) {
        Result<Void> result = new Result<>();
        if (null == fun) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("保存数据空！");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isBlank(fun.getName())) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("功能名称空！");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isBlank(fun.getCode())) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("功能编码空！");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isBlank(fun.getType())) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("功能类型空！");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isBlank(fun.getLevel())) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("功能等级空！");
            logger.error(result.getErrorMessage());
            return result;
        }
        // 最多三层菜单
        if (Integer.parseInt(fun.getLevel()) > MargicNumberConstants.n3 &&
                !fun.getType().equals(FunctionTypeConstants.BUTTON.name())) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("最多三层菜单！");
            logger.error(result.getErrorMessage());
            return result;
        }
        // 查询所有的功能
        ResultList<FunctionDO> functionResult = adminFunctionService.queryAll();
        List<FunctionDO> list = (List<FunctionDO>) functionResult.getDatalist();
        Boolean isAdd = Boolean.TRUE;
        for (FunctionDO function : list) {
            if (function.getCode().equals(fun.getCode())) {
                isAdd = Boolean.FALSE;
                break;
            }
        }
        // 如果是文件夹，去掉url
        if (fun.getType().equals(FunctionTypeConstants.FOLDER.name())) {
            fun.setUrl("");
        }
        if (isAdd) {
            result = adminFunctionService.addOne(fun);
        } else {
            result = adminFunctionService.modifyOne(fun);
        }
        return result;
    }

    /**
     * 根据编码删除功能
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:27
     **/
    @RequestMapping(value = "/deleteFun", method = RequestMethod.GET)
    public Object deleteFun(HttpServletRequest request) {
        String code = request.getParameter("code");
        if (StringUtils.isBlank(code)) {
            return new Result<Void>();
        }
        return adminFunctionService.removeFun(code);
    }

}
