package com.naivete.framework.admin.boot.controller;

import com.naivete.framework.admin.boot.constants.DefaultRoleConstants;
import com.naivete.framework.admin.boot.model.RoleDO;
import com.naivete.framework.admin.boot.service.RoleService;
import com.naivete.framework.common.constant.MargicNumberConstants;
import com.naivete.framework.common.dao.Query;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import com.naivete.framework.common.util.PageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Date;

/**
 * 角色管理Controller
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/11 1:41
 **/
@Controller("adminRoleController")
@RequestMapping("/role")
public class RoleController {

    // 日志
    private final static Logger logger = LoggerFactory.getLogger(RoleController.class);

    // 角色服务
    @Resource
    private RoleService adminRoleService;

    /**
     * 查询角色列表
     * 支持名称模糊查询
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/24 23:58
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST)
    public @ResponseBody
    Object list(@RequestBody Query<RoleDO> query) {
        // 查询列表数据
        ResultList<RoleDO> resultList = adminRoleService.queryList(query);
        // 返回数据
        return PageUtils.resultJSON(resultList);
    }

    /**
     * 保存角色权限映射
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:41
     **/
    @ResponseBody
    @RequestMapping(value = "/saveRoleMapping", method = RequestMethod.POST)
    public Object saveRoleMapping(String[] funs, String role) {
        Result<Void> result = new Result<>();
        /** 角色编码不能为空 **/
        if (StringUtils.isEmpty(role)) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("保存角色权限映射信息失败，角色编码为空！");
            logger.error(result.getErrorMessage());
            return result;
        }
        result = adminRoleService.saveRoleMapping(funs, role);
        if (!result.isSuccess()) {
            logger.error("保存角色权限映射信息失败：" + result.getErrorMessage());
        }
        return result;
    }

    /**
     * 生成一个新角色，返回角色编码
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:26
     **/
    @ResponseBody
    @RequestMapping(value = "/assginCode", method = RequestMethod.GET)
    public Result<String> assginCode(HttpServletRequest request) {
        Result<String> result = new Result<>();
        try {
            /** 查询角色编码最大的一条角色信息 **/
            Result<RoleDO> roleResult = adminRoleService.queryMostBigRoleCode();
            if (!roleResult.isSuccess() || null == roleResult.getData()) {
                result.setErrorMessage("没有查询到编码最大的角色！");
                result.setSuccess(Boolean.FALSE);
                logger.error("生成角色编码失败：" + result.getErrorMessage());
                return result;
            }
            String roleCode = roleResult.getData().getRoleCode();
            /** 生成新编码 **/
            // 去掉R
            roleCode = roleCode.replace("R", "").trim();
            // 强转int并加1
            roleCode = String.valueOf(Integer.parseInt(roleCode) + 1);
            // 补齐5位并加上R
            roleCode = ("00000" + roleCode);
            roleCode = "R" + roleCode.substring(roleCode.length() - MargicNumberConstants.n5, roleCode.length());
            /** 保存新角色信息 **/
            // 获取操作人信息
            String currentUserCode = (String) request.getSession().getAttribute("userCode");
            RoleDO role = new RoleDO();
            role.setRoleName(DefaultRoleConstants.DEFAULT.name());
            role.setRemark(DefaultRoleConstants.DEFAULT.getCname());
            role.setRoleCode(roleCode);
            role.setCreateDate(new Date());
            role.setCreateUser(currentUserCode);
            Result<Void> addResult = adminRoleService.addOne(role);
            if (!addResult.isSuccess()) {
                result.setSuccess(Boolean.FALSE);
                result.setErrorMessage(addResult.getErrorMessage());
                logger.error(result.getErrorMessage());
                return result;
            }
            result.setData(roleCode);
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("生成角色编码异常！");
            logger.error(result.getErrorMessage() + e);
        }
        return result;
    }

    /**
     * 删除角色
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/25 23:24
     */
    @ResponseBody
    @RequestMapping(value = "/deleteRole", method = RequestMethod.GET)
    public Result<Void> deleteRole(String roleCode) {
        return adminRoleService.removeRoleByRoleCode(roleCode);
    }


    /**
     * 保存角色
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:27
     **/
    @ResponseBody
    @RequestMapping(value = "/saveRole", method = RequestMethod.POST)
    public Result<Void> saveRole(HttpServletRequest request, RoleDO role) {
        Result<Void> result = new Result<>();
        /** 参数校验 **/
        if (null == role) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("保存角色失败，角色信息空！");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isEmpty(role.getRoleName())) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("保存角色失败，角色名空！");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isEmpty(role.getRoleCode())) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("保存角色失败，角色编码空！");
            logger.error(result.getErrorMessage());
            return result;
        }
        try {
            /** 保存数据 **/
            // 获取操作人信息
            String currentUserCode = (String) request.getSession().getAttribute("userCode");
            role.setModifyDate(new Date());
            role.setModifyUser(currentUserCode);
            result = adminRoleService.modify(role);
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("保存角色异常：" + e.getMessage());
            logger.error(result.getErrorMessage());
            return result;
        }
        return result;
    }


}
