package com.naivete.framework.admin.boot.dao;

import com.naivete.framework.admin.boot.model.FunctionRoleMappingDO;
import com.naivete.framework.common.dao.BaseDAO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 功能角色映射表DAO，包含增删差改，只对单表操作
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/10 22:56
 **/
@Mapper
public interface FunctionRoleMappingDAO extends BaseDAO<FunctionRoleMappingDO> {

    /**
     * 根据角色编码集合查询功能编码
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 22:56
     **/
    List<String> selectListByRoleCode(List<String> roleCodes);


    /**
     * 根据角色编码删除映射
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 22:56
     **/
    Integer deleteByRole(String roleCode);

    /**
     * 根据功能编码删除映射
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 22:57
     **/
    Integer deleteByFun(String funCode);

}
