package com.naivete.framework.admin.boot.dao;

import com.naivete.framework.admin.boot.model.RoleDO;
import com.naivete.framework.common.dao.BaseDAO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 角色表DAO，包含增删差改，只对单表操作
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/10 22:57
 **/
@Mapper
public interface RoleDAO extends BaseDAO<RoleDO> {

    /**
     * 根据角色编码集合查询角色集合
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 22:57
     **/
    List<RoleDO> selectListByRoleCode(List<String> roleCodes);

    /**
     * 查询角色编码最大的一条角色信息
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/25 22:46
     */
    RoleDO selectMostBigRoleCode();

    /**
     * 根据角色编码删除角色
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/25 23:37
     */
    Integer deleteByRoleCode(String roleCode);

    /**
     * 查询所有角色
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/25 23:24
     */
    List<RoleDO> selectAll();

}
