package com.naivete.framework.admin.boot.dao;

import com.naivete.framework.admin.boot.model.UserDO;
import com.naivete.framework.common.dao.BaseDAO;
import org.apache.ibatis.annotations.Mapper;

/**
 * 用户表DAO，包含增删差改，只对单表操作
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/10 22:57
 **/
@Mapper
public interface UserDAO extends BaseDAO<UserDO> {

    /**
     * 根据编码查询用户信息
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 22:58
     **/
    UserDO selectOneByUserCode(String userCode);

    /**
     * 登录验证
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 22:58
     **/
    UserDO selectOneByLogin(UserDO user);

    /**
     * 启用或禁用用户
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 22:58
     **/
    Integer forbiddenOrStartUser(UserDO user);

}
