package com.naivete.framework.admin.boot.service;

import com.naivete.framework.admin.boot.model.RoleDO;
import com.naivete.framework.common.dao.Query;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;

/**
 * 角色服务接口
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/10 23:12
 **/
public interface RoleService {

    /**
     * 分页查询角色列表
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:12
     **/
    ResultList<RoleDO> queryList(Query<RoleDO> query);

    /**
     * 根据用户编码查询角色
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:12
     **/
    ResultList<RoleDO> queryListByUserCode(String userCode);

    /**
     * 查询所有角色
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:12
     **/
    ResultList<RoleDO> queryAll();

    /**
     * 保存角色权限映射
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:12
     **/
    Result<Void> saveRoleMapping(String[] funs, String role);

    /**
     * 添加单条角色信息
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/25 22:35
     */
    Result<Void> addOne(RoleDO role);

    /**
     * 查询角色编码最大的一条角色信息
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/25 22:38
     */
    Result<RoleDO> queryMostBigRoleCode();

    /**
     * 根据角色编码删除角色信息
     * 1、角色表
     * 2、角色功能映射表
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/25 23:27
     */
    Result<Void> removeRoleByRoleCode(String roleCode);

    /**
     * 更新角色信息
     * 只允许更新名称和备注
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/26 0:55
     */
    Result<Void> modify(RoleDO role);

}
