/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.admin.boot.config;

import at.pollux.thymeleaf.shiro.dialect.ShiroDialect;
import com.naivete.framework.admin.boot.config.AdminBootProperteis;
import com.naivete.framework.admin.boot.config.ShiroRealm;
import com.naivete.framework.admin.boot.config.annotation.EnableAdminBootConfiguration;
import java.util.LinkedHashMap;
import javax.annotation.Resource;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(annotation={EnableAdminBootConfiguration.class})
@EnableConfigurationProperties(value={AdminBootProperteis.class})
@MapperScan(value={"com.naivete.framework.admin.boot.dao"})
@ComponentScan(value={"com.naivete.framework.admin.boot.controller", "com.naivete.framework.admin.boot.service"})
public class AdminBootAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(AdminBootAutoConfiguration.class);
    @Resource
    private AdminBootProperteis adminBootProperteis;

    @Bean(name={"shiroFilter"})
    public ShiroFilterFactoryBean shiroFilter(SecurityManager securityManager) {
        String[] anons;
        logger.info("init shiroFilter begin");
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        shiroFilterFactoryBean.setLoginUrl("/toLogin");
        shiroFilterFactoryBean.setSuccessUrl("/index");
        shiroFilterFactoryBean.setUnauthorizedUrl("/unauthorized");
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        filterChainDefinitionMap.put("/login", "anon");
        filterChainDefinitionMap.put("/logout", "anon");
        filterChainDefinitionMap.put("/admin-boot/**", "anon");
        for (String anon : anons = this.adminBootProperteis.getAnons()) {
            logger.info("anon={}", (Object)anon);
            filterChainDefinitionMap.put(anon, "anon");
        }
        filterChainDefinitionMap.put("/**", "authc");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        logger.info("init shiroFilter end");
        return shiroFilterFactoryBean;
    }

    @Bean(name={"cacheManager"})
    public CacheManager cacheManager() {
        return new MemoryConstrainedCacheManager();
    }

    @Bean(name={"shiroRealm"})
    public AuthorizingRealm shiroRealm(CacheManager cacheManager) {
        ShiroRealm shiroRealm = new ShiroRealm();
        shiroRealm.setCacheManager(cacheManager);
        return shiroRealm;
    }

    @Bean(name={"rememberMeCookie"})
    public SimpleCookie rememberMeCookie() {
        logger.info("maxAge={}", (Object)this.adminBootProperteis.getMaxAge());
        SimpleCookie simpleCookie = new SimpleCookie("rememberMe");
        simpleCookie.setMaxAge(this.adminBootProperteis.getMaxAge().intValue());
        return simpleCookie;
    }

    @Bean(name={"rememberMeManager"})
    public CookieRememberMeManager rememberMeManager(SimpleCookie rememberMeCookie) {
        logger.info("cipherKey={}", (Object)this.adminBootProperteis.getCipherKey());
        CookieRememberMeManager cookieRememberMeManager = new CookieRememberMeManager();
        cookieRememberMeManager.setCookie((Cookie)rememberMeCookie);
        cookieRememberMeManager.setCipherKey(Base64.decode((String)this.adminBootProperteis.getCipherKey()));
        return cookieRememberMeManager;
    }

    @Bean(name={"securityManager"})
    public SecurityManager securityManager(CookieRememberMeManager rememberMeManager, AuthorizingRealm shiroRealm) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)shiroRealm);
        securityManager.setRememberMeManager((RememberMeManager)rememberMeManager);
        return securityManager;
    }

    @Bean(name={"shiroDialect"})
    public ShiroDialect shiroDialect() {
        return new ShiroDialect();
    }
}

