/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.admin.boot.config;

import com.naivete.framework.admin.boot.model.AuthInfoDO;
import com.naivete.framework.admin.boot.model.FunctionDO;
import com.naivete.framework.admin.boot.model.RoleDO;
import com.naivete.framework.admin.boot.model.UserDO;
import com.naivete.framework.admin.boot.service.AuthInfoService;
import com.naivete.framework.common.dao.Result;
import java.util.HashSet;
import javax.annotation.Resource;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroRealm
extends AuthorizingRealm {
    private static Logger logger = LoggerFactory.getLogger(ShiroRealm.class);
    @Resource
    private AuthInfoService adminAuthInfoService;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        logger.info("doGetAuthenticationInfo:" + token);
        UsernamePasswordToken userToken = (UsernamePasswordToken)token;
        String username = userToken.getUsername();
        String password = new String(userToken.getPassword());
        Result<UserDO> loginResult = this.adminAuthInfoService.login(username, password);
        if (!loginResult.isSuccess()) {
            throw new UnknownAccountException(loginResult.getErrorMessage());
        }
        return new SimpleAuthenticationInfo(loginResult.getData(), (Object)password, username);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        logger.info("ShiroRealm\u7684doGetAuthorizationInfo\u6388\u6743\u65b9\u6cd5\u6267\u884c");
        String username = (String)principals.getPrimaryPrincipal();
        logger.info("ShiroRealm  AuthorizationInfo:" + username);
        Result<AuthInfoDO> authResult = this.adminAuthInfoService.queryAuthInfoByUserCode(username);
        AuthInfoDO authInfo = (AuthInfoDO)authResult.getData();
        HashSet<String> roles = new HashSet<String>();
        for (RoleDO roleDO : authInfo.getRoleList()) {
            roles.add(roleDO.getRoleCode());
        }
        HashSet permissions = new HashSet();
        for (FunctionDO function : authInfo.getFunctionList()) {
            roles.add(function.getCode());
        }
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo(roles);
        simpleAuthorizationInfo.setStringPermissions(permissions);
        return simpleAuthorizationInfo;
    }
}

