/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.admin.boot.controller;

import com.naivete.framework.admin.boot.constants.FunctionTypeConstants;
import com.naivete.framework.admin.boot.model.FunctionDO;
import com.naivete.framework.admin.boot.model.UserDO;
import com.naivete.framework.admin.boot.service.FunctionService;
import com.naivete.framework.admin.boot.service.UserService;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminIndexController")
@RequestMapping(value={"/index"})
public class IndexController {
    private static final Logger logger = LoggerFactory.getLogger(IndexController.class);
    @Resource
    private FunctionService adminFunctionService;
    @Resource
    private UserService adminUserService;

    @RequestMapping(value={"/initMenu"}, method={RequestMethod.GET})
    public Object initMenu(HttpServletRequest request) {
        ResultList result = new ResultList();
        try {
            String userCode = (String)request.getSession().getAttribute("userCode");
            ResultList<FunctionDO> resultList = this.adminFunctionService.queryListByUserCode(userCode);
            List functionList = (List)resultList.getDatalist();
            ArrayList<FunctionDO> list = new ArrayList<FunctionDO>();
            for (FunctionDO function : functionList) {
                if (function.getType().equals(FunctionTypeConstants.BUTTON.name())) continue;
                list.add(function);
            }
            result.setDatalist(list);
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u52a0\u8f7d\u83dc\u5355\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error(result.getErrorMessage());
        }
        return result;
    }

    @RequestMapping(value={"/initUser"}, method={RequestMethod.POST})
    public Object initUser(HttpServletRequest request) {
        Result result = new Result();
        try {
            String userCode = (String)request.getSession().getAttribute("userCode");
            Result<UserDO> queryResult = this.adminUserService.queryByUserCode(userCode);
            if (queryResult.isSuccess() && null != queryResult.getData()) {
                UserDO user = (UserDO)queryResult.getData();
                user.setId(null);
                user.setPassword(null);
                result.setData((Object)user);
            }
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u521d\u59cb\u5316\u4e2a\u4eba\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error(result.getErrorMessage());
        }
        return result;
    }
}

