/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.admin.boot.controller;

import com.naivete.framework.admin.boot.constants.FunctionTypeConstants;
import com.naivete.framework.admin.boot.model.FunctionDO;
import com.naivete.framework.admin.boot.model.MenuTree;
import com.naivete.framework.admin.boot.service.FunctionService;
import com.naivete.framework.common.constant.MargicNumberConstants;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminMenuController")
@RequestMapping(value={"/menu"})
public class MenuController {
    private static final Logger logger = LoggerFactory.getLogger(MenuController.class);
    @Resource
    private FunctionService adminFunctionService;

    @RequestMapping(value={"/getMenuTree"}, method={RequestMethod.GET})
    public Object getMenuTree(HttpServletRequest request) {
        ArrayList<MenuTree> tree = new ArrayList<MenuTree>();
        List<String> funs = this.getFunByRole(request);
        ResultList<FunctionDO> functionResult = this.adminFunctionService.queryAll();
        if (!functionResult.isSuccess() || CollectionUtils.isEmpty((Collection)functionResult.getDatalist())) {
            return tree;
        }
        List list = (List)functionResult.getDatalist();
        for (FunctionDO function : list) {
            MenuTree menuTree = new MenuTree();
            menuTree.setText(function.getName());
            menuTree.initState(Boolean.TRUE, funs.contains(function.getCode()) ? Boolean.TRUE : Boolean.FALSE);
            menuTree.setId(function.getCode());
            menuTree.setIcon(function.getType().equals(FunctionTypeConstants.FOLDER.name()) ? null : "none");
            menuTree.initData(function.getCode(), function.getName(), function.getParentCode(), function.getParentName(), function.getUrl(), function.getType(), function.getRemark(), function.getLevel(), function.getIcon());
            menuTree.setChildren(new ArrayList<MenuTree>());
            tree.add(menuTree);
        }
        return this.buildTree(tree, "0");
    }

    private List<String> getFunByRole(HttpServletRequest request) {
        String roleCode = request.getParameter("roleCode");
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)roleCode)) {
            return list;
        }
        ResultList<FunctionDO> directChildFun = this.adminFunctionService.queryListByRoleCode(roleCode);
        List datalist = (List)directChildFun.getDatalist();
        for (FunctionDO item : datalist) {
            if (item.getCode() == null) continue;
            list.add(item.getCode());
        }
        return list;
    }

    public List<MenuTree> buildTree(List<MenuTree> list, String parentCode) {
        ArrayList<MenuTree> menus = new ArrayList<MenuTree>();
        for (MenuTree menu : list) {
            if (!menu.getDataParentCode().equals(parentCode)) continue;
            List<MenuTree> menuLists = this.buildTree(list, menu.getDataCode());
            menu.setChildren(menuLists);
            menus.add(menu);
        }
        return menus;
    }

    @RequestMapping(value={"/assginCode"}, method={RequestMethod.GET})
    public Object assginCode(HttpServletRequest request) {
        String parentCode = request.getParameter("parentCode");
        ResultList<FunctionDO> directChildFun = this.adminFunctionService.queryChildFun(parentCode);
        List datalist = (List)directChildFun.getDatalist();
        ArrayList<String> list = new ArrayList<String>();
        for (FunctionDO item : datalist) {
            if (item.getCode() == null) continue;
            list.add(item.getCode());
        }
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i = 1; i <= MargicNumberConstants.n99; ++i) {
            if (i < MargicNumberConstants.n10) {
                if ("0".equals(parentCode)) {
                    tmp.add("0" + i);
                    continue;
                }
                tmp.add(parentCode + "0" + i);
                continue;
            }
            if ("0".equals(parentCode)) {
                tmp.add(i + "");
                continue;
            }
            tmp.add(parentCode + i + "");
        }
        for (String item : tmp) {
            if (list.contains(item)) continue;
            Result result = new Result();
            result.setData((Object)item);
            return result;
        }
        return null;
    }

    @RequestMapping(value={"/lodSubFun"}, method={RequestMethod.GET})
    public Object lodSubFun(HttpServletRequest request) {
        String parentCode = request.getParameter("parentCode");
        ResultList<FunctionDO> directChildFun = this.adminFunctionService.queryChildFun(parentCode);
        List list = (List)directChildFun.getDatalist();
        for (FunctionDO function : list) {
            function.setType(FunctionTypeConstants.getEnum(FunctionTypeConstants.class, (String)function.getType()).getCname());
        }
        return list;
    }

    @RequestMapping(value={"/saveFun"}, method={RequestMethod.POST})
    public Object saveFun(HttpServletRequest request, FunctionDO fun) {
        Result<Void> result = new Result<Void>();
        if (null == fun) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u4fdd\u5b58\u6570\u636e\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isBlank((CharSequence)fun.getName())) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u529f\u80fd\u540d\u79f0\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isBlank((CharSequence)fun.getCode())) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u529f\u80fd\u7f16\u7801\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isBlank((CharSequence)fun.getType())) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u529f\u80fd\u7c7b\u578b\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isBlank((CharSequence)fun.getLevel())) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u529f\u80fd\u7b49\u7ea7\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (Integer.parseInt(fun.getLevel()) > MargicNumberConstants.n3 && !fun.getType().equals(FunctionTypeConstants.BUTTON.name())) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u6700\u591a\u4e09\u5c42\u83dc\u5355\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        ResultList<FunctionDO> functionResult = this.adminFunctionService.queryAll();
        List list = (List)functionResult.getDatalist();
        Boolean isAdd = Boolean.TRUE;
        for (FunctionDO function : list) {
            if (!function.getCode().equals(fun.getCode())) continue;
            isAdd = Boolean.FALSE;
            break;
        }
        if (fun.getType().equals(FunctionTypeConstants.FOLDER.name())) {
            fun.setUrl("");
        }
        result = isAdd != false ? this.adminFunctionService.addOne(fun) : this.adminFunctionService.modifyOne(fun);
        return result;
    }

    @RequestMapping(value={"/deleteFun"}, method={RequestMethod.GET})
    public Object deleteFun(HttpServletRequest request) {
        String code = request.getParameter("code");
        if (StringUtils.isBlank((CharSequence)code)) {
            return new Result();
        }
        return this.adminFunctionService.removeFun(code);
    }
}

