/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.admin.boot.service.impl;

import com.naivete.framework.admin.boot.dao.FunctionDAO;
import com.naivete.framework.admin.boot.dao.FunctionRoleMappingDAO;
import com.naivete.framework.admin.boot.dao.RoleDAO;
import com.naivete.framework.admin.boot.dao.UserRoleMappingDAO;
import com.naivete.framework.admin.boot.model.FunctionDO;
import com.naivete.framework.admin.boot.model.RoleDO;
import com.naivete.framework.admin.boot.service.FunctionService;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

@Service(value="adminFunctionService")
public class FunctionServiceImpl
implements FunctionService {
    private static Logger logger = LoggerFactory.getLogger(FunctionServiceImpl.class);
    @Resource
    private RoleDAO roleDAO;
    @Resource
    private UserRoleMappingDAO userRoleMappingDAO;
    @Resource
    private FunctionDAO functionDAO;
    @Resource
    private FunctionRoleMappingDAO functionRoleMappingDAO;
    @Resource
    private TransactionTemplate transactionTemplate;

    @Override
    public ResultList<FunctionDO> queryListByUserCode(String userCode) {
        ResultList result = new ResultList();
        if (StringUtils.isBlank((CharSequence)userCode)) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u6743\u9650\u5931\u8d25\uff0c\u7528\u6237\u7f16\u7801\u4e3a\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        try {
            List<String> roleCodes = this.userRoleMappingDAO.selectListByUserCode(userCode);
            if (CollectionUtils.isEmpty(roleCodes)) {
                return result;
            }
            List<RoleDO> roleList = this.roleDAO.selectListByRoleCode(roleCodes);
            if (CollectionUtils.isEmpty(roleList)) {
                return result;
            }
            List<String> functionCodes = this.functionRoleMappingDAO.selectListByRoleCode(roleCodes);
            if (CollectionUtils.isEmpty(functionCodes)) {
                return result;
            }
            List<FunctionDO> functionList = this.functionDAO.selectListByFunctionCode(functionCodes);
            if (CollectionUtils.isEmpty(roleList)) {
                return result;
            }
            result.setDatalist(functionList);
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u6743\u9650\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        return result;
    }

    @Override
    public ResultList<FunctionDO> queryAll() {
        ResultList result = new ResultList();
        try {
            List<FunctionDO> functionList = this.functionDAO.selectAll();
            result.setDatalist(functionList);
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u6240\u6709\u529f\u80fd\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        return result;
    }

    @Override
    public ResultList<FunctionDO> queryChildFun(String parentCode) {
        ResultList result = new ResultList();
        try {
            List<FunctionDO> functionList = this.functionDAO.selectAllChild(parentCode);
            result.setDatalist(functionList);
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u6240\u6709\u5b50\u529f\u80fd\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        return result;
    }

    @Override
    public Result<Void> addOne(FunctionDO function) {
        return (Result)this.transactionTemplate.execute(status -> {
            Result result = new Result();
            try {
                int num = this.functionDAO.insert(function);
                if (num != 1) {
                    result.setSuccess(Boolean.FALSE.booleanValue());
                    result.setErrorMessage("\u65b0\u589e\u529f\u80fd\u5931\u8d25\uff0c\u53d7\u5f71\u54cd\u884c\u4e0d\u4e3a1\uff01");
                    status.setRollbackOnly();
                    logger.error(result.getErrorMessage());
                }
            }
            catch (Exception e) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage("\u65b0\u589e\u529f\u80fd\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                status.setRollbackOnly();
                logger.error(result.getErrorMessage());
            }
            return result;
        });
    }

    @Override
    public Result<Void> modifyOne(FunctionDO function) {
        Result result = new Result();
        try {
            int num = this.functionDAO.update(function);
            if (num != 1) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage("\u4fee\u6539\u529f\u80fd\u5931\u8d25\uff0c\u53d7\u5f71\u54cd\u884c\u4e0d\u4e3a1\uff01");
                logger.error(result.getErrorMessage());
            }
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u4fee\u6539\u529f\u80fd\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        return result;
    }

    @Override
    public ResultList<FunctionDO> queryListByRoleCode(String roleCode) {
        ResultList result = new ResultList();
        if (StringUtils.isBlank((CharSequence)roleCode)) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u6743\u9650\u5931\u8d25\uff0c\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        try {
            ArrayList<String> roleCodes = new ArrayList<String>();
            roleCodes.add(roleCode);
            List<String> functionCodes = this.functionRoleMappingDAO.selectListByRoleCode(roleCodes);
            if (CollectionUtils.isEmpty(functionCodes)) {
                return result;
            }
            List<FunctionDO> functionList = this.functionDAO.selectListByFunctionCode(functionCodes);
            result.setDatalist(functionList);
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u6743\u9650\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        return result;
    }

    @Override
    public Result<Void> removeFun(String code) {
        return (Result)this.transactionTemplate.execute(status -> {
            Result result = new Result();
            try {
                this.functionDAO.deleteByCode(code);
                this.functionRoleMappingDAO.deleteByFun(code);
            }
            catch (Exception e) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage("\u5220\u9664\u529f\u80fd\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                status.setRollbackOnly();
                logger.error(result.getErrorMessage());
            }
            return result;
        });
    }
}

