/*
 * Decompiled with CFR 0.152.
 */
package com.naivete.framework.admin.boot.service.impl;

import com.naivete.framework.admin.boot.constants.UserActiveStatusConstants;
import com.naivete.framework.admin.boot.dao.UserDAO;
import com.naivete.framework.admin.boot.dao.UserRoleMappingDAO;
import com.naivete.framework.admin.boot.model.UserDO;
import com.naivete.framework.admin.boot.model.UserRoleMappingDO;
import com.naivete.framework.admin.boot.service.UserService;
import com.naivete.framework.common.dao.Query;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service(value="adminUserService")
public class UserServiceImpl
implements UserService {
    private static Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    @Resource
    private UserDAO userDAO;
    @Resource
    private UserRoleMappingDAO userRoleMappingDAO;
    @Resource
    private TransactionTemplate transactionTemplate;

    @Override
    public ResultList<UserDO> queryList(Query<UserDO> query) {
        ResultList result = new ResultList();
        if (null == query || null == query.getData()) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff0c\u53c2\u6570\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        try {
            result.setTotal(this.userDAO.selectListCount(query));
            result.setDatalist((Collection)this.userDAO.selectList(query));
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u67e5\u8be2\u7528\u6237\u5f02\u5e38," + e.getMessage());
            logger.error(result.getErrorMessage());
            return result;
        }
        return result;
    }

    @Override
    public Result<Void> forbiddenOrStartUser(UserDO user) {
        Result result = new Result();
        if (null == user) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u53c2\u6570\u5f02\u5e38\uff0c\u7528\u6237\u4fe1\u606f\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (StringUtils.isBlank((CharSequence)user.getUserCode())) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u53c2\u6570\u5f02\u5e38\uff0c\u7528\u6237\u7f16\u7801\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        if (null == UserActiveStatusConstants.getEnum(UserActiveStatusConstants.class, (String)user.getIsActive())) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u53c2\u6570\u5f02\u5e38\uff0c\u542f\u7528\u72b6\u6001\u5f02\u5e38\uff1a" + user.getIsActive());
            logger.error(result.getErrorMessage());
            return result;
        }
        try {
            user.setIsActive(user.getIsActive().equals(UserActiveStatusConstants.Y.name()) ? UserActiveStatusConstants.N.name() : UserActiveStatusConstants.Y.name());
            int num = this.userDAO.forbiddenOrStartUser(user);
            if (num != 1) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage("\u542f\u7528\u6216\u7981\u7528\u7528\u6237\u5931\u8d25\uff0c\u4fee\u6539\u8bb0\u5f55\u4e0d\u7b49\u4e8e1\uff01");
                logger.error(result.getErrorMessage());
                return result;
            }
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u542f\u7528\u6216\u7981\u7528\u7528\u6237\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error(result.getErrorMessage());
        }
        return result;
    }

    @Override
    public Result<UserDO> queryByUserCode(String userCode) {
        Result result = new Result();
        if (StringUtils.isEmpty((CharSequence)userCode)) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u6839\u636e\u7528\u6237\u7f16\u7801\u67e5\u8be2\u5931\u8d25\uff0c\u7528\u6237\u7f16\u7801\u7a7a\uff01");
            logger.error(result.getErrorMessage());
            return result;
        }
        try {
            UserDO user = this.userDAO.selectOneByUserCode(userCode);
            result.setData((Object)user);
        }
        catch (Exception e) {
            result.setSuccess(Boolean.FALSE.booleanValue());
            result.setErrorMessage("\u6839\u636e\u7528\u6237\u7f16\u7801\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error(result.getErrorMessage());
            return result;
        }
        return result;
    }

    @Override
    public Result<Void> saveUserRoleMapping(String[] roles, String userCode) {
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return new Result();
        }
        return (Result)this.transactionTemplate.execute(status -> {
            Result result = new Result();
            try {
                this.userRoleMappingDAO.deleteByUserCode(userCode);
                if (null != roles && roles.length > 0) {
                    ArrayList<UserRoleMappingDO> list = new ArrayList<UserRoleMappingDO>();
                    for (int i = 0; i < roles.length; ++i) {
                        UserRoleMappingDO mapping = new UserRoleMappingDO();
                        mapping.setRoleCode(roles[i]);
                        mapping.setUserCode(userCode);
                        list.add(mapping);
                    }
                    this.userRoleMappingDAO.insertBatch(list);
                }
            }
            catch (Exception e) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setErrorMessage("\u4fdd\u5b58\u89d2\u8272\u6743\u9650\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                status.setRollbackOnly();
                logger.error(result.getErrorMessage());
            }
            return result;
        });
    }
}

