package com.naivete.framework.admin.boot.controller;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 页面跳转
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/11 0:25
 **/
@Controller("adminJumpController")
public class JumpController {

    /**
     * 跳转到首页
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 0:27
     **/
    @RequestMapping("/")
    public String index() {
        return "redirect:/index";
    }

    /**
     * 跳转到登陆页面
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 14:40
     **/
    @RequestMapping("/toLogin")
    public String toLogin() {
        return "admin-boot/login";
    }

    /**
     * 跳转到首页
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 0:27
     **/
    @RequestMapping("/index")
    public String toIndex() {
        return "admin-boot/index";
    }

    /**
     * 跳转到主页
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 0:27
     **/
    @RequestMapping("/toMain")
    public String toMain() {
        return "admin-boot/main";
    }

    /**
     * 跳转到菜单管理界面
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 0:27
     **/
    @RequestMapping("/toMenu")
    public String toMenu() {
        return "admin-boot/sys/menu";
    }

    /**
     * 跳转到角色管理界面
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 0:27
     **/
    @RequestMapping("/toRole")
    public String toRole() {
        return "admin-boot/sys/role";
    }

    /**
     * 跳转到用户管理界面
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 0:27
     **/
    @RequestMapping("/toUser")
    public String toUser() {
        return "admin-boot/sys/user";
    }

}
