package com.naivete.framework.admin.boot.controller;

import com.naivete.framework.common.dao.Result;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * LoginController
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/10 14:39
 **/
@Controller("adminLoginController")
public class LoginController {

    // 日志
    private final static Logger logger = LoggerFactory.getLogger(LoginController.class);

    /**
     * 登陆：
     * 1、校验登陆信息，校验失败返回失败信息
     * 2、登陆成功后查询当前登陆人的角色权限
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 14:40
     **/
    @RequestMapping(value = "/login", method = RequestMethod.POST)
    public @ResponseBody
    Object login(@RequestParam String userCode, @RequestParam String password) {
        Result<Void> result = new Result<>();
        try {
            // 邮箱密码不能为空
            if (StringUtils.isBlank(userCode) || StringUtils.isBlank(password)) {
                result.setSuccess(Boolean.FALSE);
                result.setErrorMessage("用户名密码不能为空!");
                return result;
            }
            // 获得当前Subject
            Subject subject = SecurityUtils.getSubject();
            // 验证用户是否验证，即是否登录
            if (!subject.isAuthenticated()) {
                // 把用户名和密码封装为 UsernamePasswordToken 对象
                UsernamePasswordToken token = new UsernamePasswordToken(userCode, password);
                // remembermMe记住密码
                token.setRememberMe(true);
                try {
                    // 执行登录
                    subject.login(token);
                    // 登录成功
                    subject.getSession().setAttribute("userCode", userCode);
                    return result;
                } catch (IncorrectCredentialsException e) {
                    result.setErrorMessage("登录密码错误！");
                } catch (ExcessiveAttemptsException e) {
                    result.setErrorMessage("登录失败次数过多!");
                } catch (LockedAccountException e) {
                    result.setErrorMessage("帐号已被锁定!");
                } catch (DisabledAccountException e) {
                    result.setErrorMessage("帐号已被禁用!");
                } catch (ExpiredCredentialsException e) {
                    result.setErrorMessage("帐号已过期!");
                } catch (UnknownAccountException e) {
                    result.setErrorMessage("帐号不存在!");
                } catch (UnauthorizedException e) {
                    result.setErrorMessage("您没有得到相应的授权!");
                } catch (Exception e) {
                    result.setErrorMessage("出错:" + e.getMessage());
                }
                result.setSuccess(Boolean.FALSE);
                logger.error(result.getErrorMessage());
                return result;
            } else {
                // 已登录
                return result;
            }
        } catch (Exception e) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("登录异常：" + e);
            logger.error(result.getErrorMessage());
            return result;
        }
    }

    /**
     * 退出登陆：清除登陆信息，返回登陆页面
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 14:40
     **/
    @RequestMapping("/logout")
    public String main() {
        // request.getSession().invalidate();
        // 获得当前Subject
        Subject currentUser = SecurityUtils.getSubject();
        currentUser.logout();
        return "admin-boot/login";
    }

}