package com.naivete.framework.admin.boot.controller;

import com.naivete.framework.admin.boot.model.RoleDO;
import com.naivete.framework.admin.boot.model.RoleTree;
import com.naivete.framework.admin.boot.model.UserDO;
import com.naivete.framework.admin.boot.service.RoleService;
import com.naivete.framework.admin.boot.service.UserService;
import com.naivete.framework.common.dao.Query;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;
import com.naivete.framework.common.util.PageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 用户管理Controller
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/11 1:43
 **/
@Controller("adminUserController")
@RequestMapping("/user")
public class UserController {

    //日志
    private final static Logger logger = LoggerFactory.getLogger(UserController.class);

    // 角色服务
    @Resource
    private UserService adminUserService;
    // 角色服务
    @Resource
    private RoleService adminRoleService;

    /**
     * 查询用户列表
     * 支持名称模糊查询
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/24 23:58
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST)
    public @ResponseBody
    Object list(@RequestBody Query<UserDO> query) {
        // 查询列表数据
        ResultList<UserDO> resultList = adminUserService.queryList(query);
        // 返回数据
        return PageUtils.resultJSON(resultList);
    }

    /**
     * 启用或禁用用户
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/25 23:24
     */
    @ResponseBody
    @RequestMapping(value = "/isForbidden", method = RequestMethod.POST)
    public Result<Void> isForbidden(UserDO user) {
        return adminUserService.forbiddenOrStartUser(user);
    }

    /**
     * 查询用户角色树
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/25 23:24
     */
    @ResponseBody
    @RequestMapping(value = "/getRoleTreeByUserCode", method = RequestMethod.GET)
    public List<RoleTree> getRoleTreeByUserCode(@RequestParam String userCode) {
        List<RoleTree> list = new ArrayList<>();
        // 根据用户编码查询角色
        ResultList<RoleDO> userRoleResult = adminRoleService.queryListByUserCode(userCode);
        List<RoleDO> userRoleList = (List<RoleDO>) userRoleResult.getDatalist();
        // 查询所有角色
        ResultList<RoleDO> roleResult = adminRoleService.queryAll();
        List<RoleDO> roleList = (List<RoleDO>) roleResult.getDatalist();
        for (RoleDO role : roleList) {
            RoleTree roleTree = new RoleTree();
            roleTree.initState(Boolean.TRUE, Boolean.FALSE);
            for (RoleDO userRole : userRoleList) {
                if (role.getRoleCode().equals(userRole.getRoleCode())) {
                    roleTree.initState(Boolean.TRUE, Boolean.TRUE);
                    break;
                }
            }
            roleTree.setId(role.getRoleCode());
            roleTree.setText(role.getRoleName());
            list.add(roleTree);
        }
        return list;
    }

    /**
     * 保存用户角色映射
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/11 1:41
     **/
    @ResponseBody
    @RequestMapping(value = "/saveUserRoleMapping", method = RequestMethod.POST)
    public Object saveRoleMapping(String[] roles, String userCode) {
        Result<Void> result = new Result<>();
        /** 用户编码不能为空 **/
        if (StringUtils.isEmpty(userCode)) {
            result.setSuccess(Boolean.FALSE);
            result.setErrorMessage("保存用户角色映射信息失败，用户编码为空！");
            logger.error(result.getErrorMessage());
            return result;
        }
        result = adminUserService.saveUserRoleMapping(roles, userCode);
        if (!result.isSuccess()) {
            logger.error("保存用户角色映射信息失败：" + result.getErrorMessage());
        }
        return result;
    }

}
