package com.naivete.framework.admin.boot.dao;

import com.naivete.framework.admin.boot.model.FunctionDO;
import com.naivete.framework.common.dao.BaseDAO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 功能表DAO，包含增删差改，只对单表操作
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/10 22:54
 **/
@Mapper
public interface FunctionDAO extends BaseDAO<FunctionDO> {

    /**
     * 根据功能编码集合查询功能集合
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 22:55
     **/
    List<FunctionDO> selectListByFunctionCode(List<String> functionCodes);

    /**
     * 查询所有的功能
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 22:55
     **/
    List<FunctionDO> selectAll();

    /**
     * 查询所有子功能
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 22:55
     **/
    List<FunctionDO> selectAllChild(String parentCode);

    /**
     * 根据编码删除功能
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 22:55
     **/
    Integer deleteByCode(String code);

}
