package com.naivete.framework.admin.boot.dao;

import com.naivete.framework.admin.boot.model.UserRoleMappingDO;
import com.naivete.framework.common.dao.BaseDAO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 用户角色映射表DAO，包含增删差改，只对单表操作
 *
 * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
 * @create 2018/8/10 22:58
 **/
@Mapper
public interface UserRoleMappingDAO extends BaseDAO<UserRoleMappingDO> {

    /**
     * 根据用户编码查询角色编码
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 22:59
     **/
    List<String> selectListByUserCode(String userCode);

    /**
     * 删除映射关系
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/26 21:37
     */
    Integer deleteByUserCode(String userCode);

    /**
     * 删除映射关系
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/26 22:01
     */
    Integer deleteByRole(String roleCode);

}
