package com.naivete.framework.admin.boot.model;

import java.io.Serializable;
import java.util.List;

/**
 * 菜单树
 *
 * @author wolf_314
 * @create 2018-06-09 17:53
 **/
public class MenuTree implements Serializable {
    private static final long serialVersionUID = 4043146707727735687L;
    // 树名称
    private String text;
    // 树图标
    private String icon;
    // 状态
    private State state;
    // 数据
    private Data data;
    // id,即功能编码
    private String id;
    // 下级
    private List<MenuTree> children;

    /**
     * 获取 树名称
     *
     * @return text 树名称
     */
    public String getText() {
        return this.text;
    }

    /**
     * 设置 树名称
     *
     * @param text 树名称
     */
    public void setText(String text) {
        this.text = text;
    }

    /**
     * 获取 树图标
     *
     * @return icon 树图标
     */
    public String getIcon() {
        return this.icon;
    }

    /**
     * 设置 树图标
     *
     * @param icon 树图标
     */
    public void setIcon(String icon) {
        this.icon = icon;
    }

    /**
     * 获取 状态
     *
     * @return state 状态
     */
    public State getState() {
        return this.state;
    }

    /**
     * 设置 状态
     *
     * @param state 状态
     */
    public void setState(State state) {
        this.state = state;
    }

    /**
     * 获取 数据
     *
     * @return data 数据
     */
    public Data getData() {
        return this.data;
    }

    /**
     * 设置 数据
     *
     * @param data 数据
     */
    public void setData(Data data) {
        this.data = data;
    }

    /**
     * 获取 下级
     *
     * @return children 下级
     */
    public List<MenuTree> getChildren() {
        return this.children;
    }

    /**
     * 设置 下级
     *
     * @param children 下级
     */
    public void setChildren(List<MenuTree> children) {
        this.children = children;
    }

    /**
     * 获取 id即功能编码
     *
     * @return id id即功能编码
     */
    public String getId() {
        return this.id;
    }

    /**
     * 设置 id即功能编码
     *
     * @param id id即功能编码
     */
    public void setId(String id) {
        this.id = id;
    }

    public void initState(Boolean opened, Boolean selected) {
        this.setState(new State(opened, selected));
    }

    public void initData(String code, String name, String parentCode, String parentName, String url, String type, String remark, String level, String icon) {
        this.setData(new Data(code, name, parentCode, parentName, url, type, remark, level, icon));
    }

    public String getDataParentCode() {
        return this.getData().getParentCode();
    }

    public String getDataCode() {
        return this.getData().getCode();
    }

}


class State implements Serializable {
    private static final long serialVersionUID = 1870602361330697624L;
    // 是否展开
    private Boolean opened;
    // 是否选中
    private Boolean selected;

    public State(Boolean opened, Boolean selected) {
        this.opened = opened;
        this.selected = selected;
    }

    public State() {
        super();
    }

    /**
     * 获取 是否展开
     *
     * @return opened 是否展开
     */
    public Boolean getOpened() {
        return this.opened;
    }

    /**
     * 设置 是否展开
     *
     * @param opened 是否展开
     */
    public void setOpened(Boolean opened) {
        this.opened = opened;
    }

    /**
     * 获取 是否选中
     *
     * @return selected 是否选中
     */
    public Boolean getSelected() {
        return this.selected;
    }

    /**
     * 设置 是否选中
     *
     * @param selected 是否选中
     */
    public void setSelected(Boolean selected) {
        this.selected = selected;
    }
}

class Data implements Serializable {
    private static final long serialVersionUID = -2044501009068122886L;
    // 编码
    private String code;
    // 名称
    private String name;
    // 父编码
    private String parentCode;
    // 父名称
    private String parentName;
    // 地址
    private String url;
    // 类型
    private String type;
    // 描述
    private String remark;
    // 级别
    private String level;
    // 图片
    private String icon;

    public Data(String code, String name, String parentCode, String parentName, String url, String type, String remark, String level, String icon) {
        this.code = code;
        this.name = name;
        this.parentCode = parentCode;
        this.parentName = parentName;
        this.url = url;
        this.type = type;
        this.remark = remark;
        this.level = level;
        this.icon = icon;
    }

    public Data() {
        super();
    }

    /**
     * 获取 编码
     *
     * @return code 编码
     */
    public String getCode() {
        return this.code;
    }

    /**
     * 设置 编码
     *
     * @param code 编码
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 获取 名称
     *
     * @return name 名称
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置 名称
     *
     * @param name 名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取 父编码
     *
     * @return parentCode 父编码
     */
    public String getParentCode() {
        return this.parentCode;
    }

    /**
     * 设置 父编码
     *
     * @param parentCode 父编码
     */
    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    /**
     * 获取 父名称
     *
     * @return parentName 父名称
     */
    public String getParentName() {
        return this.parentName;
    }

    /**
     * 设置 父名称
     *
     * @param parentName 父名称
     */
    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    /**
     * 获取 地址
     *
     * @return url 地址
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * 设置 地址
     *
     * @param url 地址
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * 获取 类型
     *
     * @return type 类型
     */
    public String getType() {
        return this.type;
    }

    /**
     * 设置 类型
     *
     * @param type 类型
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 获取 描述
     *
     * @return remark 描述
     */
    public String getRemark() {
        return this.remark;
    }

    /**
     * 设置 描述
     *
     * @param remark 描述
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 获取 级别
     *
     * @return level 级别
     */
    public String getLevel() {
        return this.level;
    }

    /**
     * 设置 级别
     *
     * @param level 级别
     */
    public void setLevel(String level) {
        this.level = level;
    }

    /**
     * 获取 图片
     *
     * @return icon 图片
     */
    public String getIcon() {
        return this.icon;
    }

    /**
     * 设置 图片
     *
     * @param icon 图片
     */
    public void setIcon(String icon) {
        this.icon = icon;
    }
}