package com.naivete.framework.admin.boot.service;

import com.naivete.framework.admin.boot.model.AuthInfoDO;
import com.naivete.framework.admin.boot.model.UserDO;
import com.naivete.framework.common.dao.Result;
import com.naivete.framework.common.dao.ResultList;

/**
 * 用户认证信息Service
 *
 * @author wolf_314
 * @create 2018/5/26 17:15
 **/
public interface AuthInfoService {

    /**
     * 根据用户编码查询认证信息
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    Result<AuthInfoDO> queryAuthInfoByUserCode(String userCode);

    /**
     * 登录验证
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @create 2018/8/10 23:26
     **/
    Result<UserDO> login(String userCode, String password);

    /**
     * 根据用户编码查询角色编码
     *
     * @author wolf_314 ~^o^~ <a href="http://blog.naivete.top/">blog.naivete.top</a>
     * @date 2018/8/26 17:55
     */
    ResultList<String> queryRoleCodeByUserCode(String userCode);

}
